/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.play_behavior;

import mod.azure.azurelib.animation.controller.AzAnimationController;
import mod.azure.azurelib.animation.controller.AzAnimationControllerTimer;
import mod.azure.azurelib.animation.controller.keyframe.AzKeyframeCallbackHandler;
import mod.azure.azurelib.animation.controller.keyframe.AzKeyframeManager;
import mod.azure.azurelib.animation.controller.state.machine.AzAnimationControllerStateMachine;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehavior;
import mod.azure.azurelib.animation.play_behavior.AzPlayBehaviorRegistry;

public class AzPlayBehaviors {
    public static final AzPlayBehavior REPEAT_X_TIMES = AzPlayBehaviorRegistry.register(new AzPlayBehavior("repeat_x_times"){
        private int currentRepeatCount = 0;

        @Override
        public void onFinish(AzAnimationControllerStateMachine.Context<?> context) {
            AzAnimationController<?> controller = context.animationController();
            double maxRepeats = controller.animationProperties().repeatXTimes();
            ++this.currentRepeatCount;
            if (maxRepeats > 1.0 && (double)this.currentRepeatCount <= maxRepeats) {
                AzAnimationControllerTimer<?> controllerTimer = controller.controllerTimer();
                AzKeyframeManager<?> keyframeManager = controller.keyframeManager();
                AzKeyframeCallbackHandler<?> keyframeCallbackHandler = keyframeManager.keyframeCallbackHandler();
                controllerTimer.reset();
                keyframeCallbackHandler.reset();
                context.stateMachine().play();
            } else {
                context.stateMachine().stop();
                this.currentRepeatCount = 0;
            }
        }
    });
    public static final AzPlayBehavior FREEZE_ON_FRAME = AzPlayBehaviorRegistry.register(new AzPlayBehavior("freeze_on_frame"){

        @Override
        public void onUpdate(AzAnimationControllerStateMachine.Context<?> context) {
            AzAnimationController<?> controller = context.animationController();
            AzAnimationControllerTimer<?> controllerTimer = controller.controllerTimer();
            double freezeTickOffset = controller.animationProperties().freezeTickOffset();
            if (controllerTimer.getAdjustedTick() >= freezeTickOffset) {
                controllerTimer.addToAdjustedTick(0.0);
                context.stateMachine().pause();
            }
        }

        @Override
        public void onFinish(AzAnimationControllerStateMachine.Context<?> context) {
            context.stateMachine().pause();
        }
    });
    public static final AzPlayBehavior HOLD_ON_LAST_FRAME = AzPlayBehaviorRegistry.register(new AzPlayBehavior("hold_on_last_frame"){

        @Override
        public void onFinish(AzAnimationControllerStateMachine.Context<?> context) {
            context.stateMachine().pause();
        }
    });
    public static final AzPlayBehavior LOOP = AzPlayBehaviorRegistry.register(new AzPlayBehavior("loop"){

        @Override
        public void onFinish(AzAnimationControllerStateMachine.Context<?> context) {
            AzAnimationController<?> controller = context.animationController();
            AzAnimationControllerTimer<?> controllerTimer = controller.controllerTimer();
            AzKeyframeManager<?> keyframeManager = controller.keyframeManager();
            AzKeyframeCallbackHandler<?> keyframeCallbackHandler = keyframeManager.keyframeCallbackHandler();
            controllerTimer.reset();
            keyframeCallbackHandler.reset();
        }
    });
    public static final AzPlayBehavior PLAY_ONCE = AzPlayBehaviorRegistry.register(new AzPlayBehavior("play_once"){

        @Override
        public void onFinish(AzAnimationControllerStateMachine.Context<?> context) {
            context.stateMachine().stop();
        }
    });

    private AzPlayBehaviors() {
    }
}

