/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.impl;

import java.util.UUID;
import mod.azure.azurelib.animation.AzAnimator;
import mod.azure.azurelib.animation.AzAnimatorConfig;
import mod.azure.azurelib.core.molang.MolangParser;
import mod.azure.azurelib.core.molang.MolangQueries;
import mod.azure.azurelib.util.client.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.WalkAnimationState;
import net.minecraft.world.phys.Vec3;

public abstract class AzEntityAnimator<T extends Entity>
extends AzAnimator<UUID, T> {
    protected AzEntityAnimator() {
    }

    protected AzEntityAnimator(AzAnimatorConfig config) {
        super(config);
    }

    @Override
    protected void applyMolangQueries(T entity, double animTime, float partialTicks) {
        super.applyMolangQueries(entity, animTime, partialTicks);
        MolangParser parser = MolangParser.INSTANCE;
        Minecraft minecraft = Minecraft.m_91087_();
        parser.setMemoizedValue(MolangQueries.DISTANCE_FROM_CAMERA, () -> minecraft.f_91063_.m_109153_().m_90583_().m_82554_(entity.m_20182_()));
        parser.setMemoizedValue(MolangQueries.IN_AIR, () -> RenderUtils.booleanToFloat(!entity.m_20096_()));
        parser.setMemoizedValue(MolangQueries.IS_ON_GROUND, () -> RenderUtils.booleanToFloat(entity.m_20096_()));
        parser.setMemoizedValue(MolangQueries.IS_IN_WATER, () -> RenderUtils.booleanToFloat(entity.m_20069_()));
        parser.setMemoizedValue(MolangQueries.IS_IN_WATER_OR_RAIN, () -> RenderUtils.booleanToFloat(entity.m_20070_()));
        parser.setMemoizedValue(MolangQueries.IS_ON_FIRE, () -> RenderUtils.booleanToFloat(entity.m_6060_()));
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            parser.setMemoizedValue(MolangQueries.IS_BLOCKING, () -> RenderUtils.booleanToFloat(livingEntity.m_21254_()));
            parser.setMemoizedValue(MolangQueries.IS_USING_ITEM, () -> RenderUtils.booleanToFloat(livingEntity.m_6117_()));
            parser.setMemoizedValue(MolangQueries.HEALTH, () -> ((LivingEntity)livingEntity).m_21223_());
            parser.setMemoizedValue(MolangQueries.MAX_HEALTH, () -> ((LivingEntity)livingEntity).m_21233_());
            parser.setMemoizedValue(MolangQueries.GROUND_SPEED, () -> {
                Vec3 velocity = livingEntity.m_20184_();
                return Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
            });
            parser.setMemoizedValue(MolangQueries.YAW_SPEED, () -> livingEntity.m_146908_() - livingEntity.f_19859_);
            parser.setValue(MolangQueries.HEAD_YAW, () -> livingEntity.m_5675_(partialTicks) - Mth.m_14179_((float)partialTicks, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_));
            parser.setValue(MolangQueries.HEAD_PITCH, () -> livingEntity.m_5686_(partialTicks));
            parser.setValue(MolangQueries.HURT_TIME, () -> livingEntity.f_20916_ == 0 ? 0.0 : (double)((float)livingEntity.f_20916_ - partialTicks));
            parser.setValue(MolangQueries.IS_BABY, () -> RenderUtils.booleanToFloat(livingEntity.m_6162_()));
            parser.setValue(MolangQueries.LIMB_SWING, () -> ((WalkAnimationState)livingEntity.f_267362_).m_267756_());
            parser.setValue(MolangQueries.LIMB_SWING_AMOUNT, () -> livingEntity.f_267362_.m_267711_(partialTicks));
        }
    }
}

