/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.controller.keyframe;

import java.util.List;
import mod.azure.azurelib.animation.controller.keyframe.AzAnimationPoint;
import mod.azure.azurelib.animation.controller.keyframe.AzKeyframe;
import mod.azure.azurelib.animation.controller.keyframe.AzKeyframeLocation;
import mod.azure.azurelib.core.math.Constant;
import mod.azure.azurelib.core.math.IValue;
import mod.azure.azurelib.core.object.Axis;

public class AzAbstractKeyframeExecutor {
    protected AzAbstractKeyframeExecutor() {
    }

    protected AzAnimationPoint getAnimationPointAtTick(List<AzKeyframe<IValue>> frames, double tick, boolean isRotation, Axis axis) {
        AzKeyframeLocation<AzKeyframe<IValue>> location = frames.isEmpty() ? new AzKeyframeLocation<AzKeyframe<IValue>>(new AzKeyframe<IValue>(0.0, () -> 0.0, () -> 0.0), 0.0) : this.getCurrentKeyframeLocation(frames, tick);
        AzKeyframe<IValue> currentFrame = location.keyframe();
        double startValue = currentFrame.startValue().get();
        double endValue = currentFrame.endValue().get();
        if (isRotation) {
            if (!(currentFrame.startValue() instanceof Constant)) {
                startValue = Math.toRadians(startValue);
                if (axis == Axis.X || axis == Axis.Y) {
                    startValue *= -1.0;
                }
            }
            if (!(currentFrame.endValue() instanceof Constant)) {
                endValue = Math.toRadians(endValue);
                if (axis == Axis.X || axis == Axis.Y) {
                    endValue *= -1.0;
                }
            }
        }
        return new AzAnimationPoint(currentFrame, location.startTick(), currentFrame.length(), startValue, endValue);
    }

    protected AzKeyframeLocation<AzKeyframe<IValue>> getCurrentKeyframeLocation(List<AzKeyframe<IValue>> frames, double ageInTicks) {
        double totalFrameTime = 0.0;
        for (AzKeyframe<IValue> frame : frames) {
            if (!((totalFrameTime += frame.length()) > ageInTicks)) continue;
            return new AzKeyframeLocation<AzKeyframe<IValue>>(frame, ageInTicks - (totalFrameTime - frame.length()));
        }
        return new AzKeyframeLocation<AzKeyframe<IValue>>(frames.get(frames.size() - 1), ageInTicks);
    }
}

