/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation;

import java.util.WeakHashMap;
import mod.azure.azurelib.animation.AzAnimationContext;
import mod.azure.azurelib.animation.AzAnimationTimer;
import mod.azure.azurelib.animation.AzAnimatorConfig;
import mod.azure.azurelib.animation.cache.AzBakedAnimationCache;
import mod.azure.azurelib.animation.cache.AzBoneCache;
import mod.azure.azurelib.animation.controller.AzAnimationController;
import mod.azure.azurelib.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.animation.primitive.AzBakedAnimation;
import mod.azure.azurelib.animation.primitive.AzBakedAnimations;
import mod.azure.azurelib.core.molang.MolangParser;
import mod.azure.azurelib.core.molang.MolangQueries;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class AzAnimator<K, T> {
    private AzAnimationContext<T> currentContext;
    private final WeakHashMap<K, AzAnimationContext<T>> contextCache = new WeakHashMap();
    private final AzAnimationControllerContainer<T> animationControllerContainer = new AzAnimationControllerContainer();
    protected final AzAnimatorConfig config;
    public boolean reloadAnimations;

    protected AzAnimator() {
        this(AzAnimatorConfig.defaultConfig());
    }

    protected AzAnimator(AzAnimatorConfig config) {
        this.config = config;
    }

    public AzBoneCache createBoneCache() {
        return new AzBoneCache();
    }

    public AzAnimationTimer createAzAnimationTimer(AzAnimatorConfig config) {
        return new AzAnimationTimer(config);
    }

    public AzAnimationContext<T> getOrCreateContext(K uuid) {
        AzAnimationContext ctx;
        this.currentContext = ctx = this.contextCache.computeIfAbsent(uuid, a -> new AzAnimationContext(this.createBoneCache(), this.config, this.createAzAnimationTimer(this.config)));
        return ctx;
    }

    public abstract void registerControllers(AzAnimationControllerContainer<T> var1);

    @NotNull
    public abstract ResourceLocation getAnimationLocation(T var1);

    public void animate(T animatable, float partialTicks, boolean updateTimer) {
        this.currentContext.animatable = animatable;
        AzBoneCache boneCache = this.currentContext.boneCache();
        AzAnimationTimer timer = this.currentContext.timer();
        if (updateTimer) {
            timer.tick();
        }
        this.preAnimationSetup(animatable, timer.getAnimTime(), partialTicks);
        if (!boneCache.isEmpty()) {
            for (AzAnimationController<T> controller : this.animationControllerContainer.getAll()) {
                controller.update();
            }
            this.reloadAnimations = false;
            boneCache.update(this.currentContext);
        }
        this.setCustomAnimations(animatable, partialTicks);
    }

    public void animate(T animatable, float partialTicks) {
        this.animate(animatable, partialTicks, true);
    }

    protected void preAnimationSetup(T animatable, double animTime, float partialTicks) {
        this.applyMolangQueries(animatable, animTime, partialTicks);
    }

    protected void applyMolangQueries(T animatable, double animTime, float partialTicks) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        MolangParser parser = MolangParser.INSTANCE;
        if (level == null) {
            return;
        }
        parser.setMemoizedValue(MolangQueries.LIFE_TIME, () -> animTime / 20.0);
        parser.setMemoizedValue(MolangQueries.ACTOR_COUNT, () -> ((ClientLevel)level).m_104813_());
        parser.setMemoizedValue(MolangQueries.TIME_OF_DAY, () -> (float)level.m_46468_() / 24000.0f);
        parser.setMemoizedValue(MolangQueries.MOON_PHASE, () -> ((ClientLevel)level).m_46941_());
    }

    public void setCustomAnimations(T animatable, float partialTicks) {
    }

    public AzBakedAnimation getAnimation(T animatable, String name) {
        ResourceLocation location = this.getAnimationLocation(animatable);
        AzBakedAnimations bakedAnimations = AzBakedAnimationCache.getInstance().getNullable(location);
        return bakedAnimations.getAnimation(name);
    }

    public AzAnimationContext<T> context() {
        return this.currentContext;
    }

    public AzAnimationControllerContainer<T> getAnimationControllerContainer() {
        return this.animationControllerContainer;
    }
}

