/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.entity.FlowerBoxBlockEntity;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.registry.AFItemTags;
import com.starfish_studios.another_furniture.util.block.BlockPart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FlowerBoxBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<HorizontalConnectionType> TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;
    public static final BooleanProperty ATTACHED = BlockStateProperties.f_61386_;
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)10.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)8.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)6.0, (double)12.0);
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)6.0, (double)16.0);

    public FlowerBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        boolean attached = (Boolean)state.m_61143_((Property)ATTACHED);
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.WEST -> {
                if (attached) {
                    yield WEST_AABB;
                }
                yield X_AXIS_AABB;
            }
            case Direction.EAST -> {
                if (attached) {
                    yield EAST_AABB;
                }
                yield X_AXIS_AABB;
            }
            case Direction.SOUTH -> {
                if (attached) {
                    yield SOUTH_AABB;
                }
                yield Z_AXIS_AABB;
            }
            default -> attached ? NORTH_AABB : Z_AXIS_AABB;
        };
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)ATTACHED)).booleanValue()) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            BlockPos facingPos = pos.m_121945_(direction.m_122424_());
            BlockState facingState = level.m_8055_(facingPos);
            return facingState.m_60783_((BlockGetter)level, facingPos, direction);
        }
        return super.m_7898_(state, level, pos);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        boolean r_side;
        BlockEntity blockentity;
        BlockState above = level.m_8055_(currentPos.m_7494_());
        boolean attached = (Boolean)state.m_61143_((Property)ATTACHED);
        if (direction == Direction.UP && attached && above.m_60783_((BlockGetter)level, currentPos, Direction.DOWN) && (blockentity = level.m_7702_(currentPos)) instanceof FlowerBoxBlockEntity) {
            FlowerBoxBlockEntity flowerBoxBE = (FlowerBoxBlockEntity)blockentity;
            flowerBoxBE.removeAllItems();
            return state;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (attached && direction.m_122424_() == facing && !state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (direction != facing.m_122427_() && direction != facing.m_122428_()) {
            return state;
        }
        BlockState l_state = level.m_8055_(currentPos.m_121945_(facing.m_122427_()));
        BlockState r_state = level.m_8055_(currentPos.m_121945_(facing.m_122428_()));
        boolean l_side = l_state.m_60734_() instanceof FlowerBoxBlock && (Boolean)l_state.m_61143_((Property)ATTACHED) == attached && (l_state.m_61143_((Property)FACING) == facing || !attached && l_state.m_61143_((Property)FACING) == facing.m_122424_());
        boolean bl = r_side = r_state.m_60734_() instanceof FlowerBoxBlock && (Boolean)r_state.m_61143_((Property)ATTACHED) == attached && (r_state.m_61143_((Property)FACING) == facing || !attached && r_state.m_61143_((Property)FACING) == facing.m_122424_());
        HorizontalConnectionType type = l_side && r_side ? HorizontalConnectionType.MIDDLE : (r_side ? HorizontalConnectionType.LEFT : (l_side ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction clickedFace = context.m_43719_();
        boolean attached = clickedFace != Direction.UP && clickedFace != Direction.DOWN;
        Direction facing = attached ? clickedFace : context.m_8125_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(attached))).m_61124_((Property)FACING, (Comparable)facing);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE, ATTACHED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FlowerBoxBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof FlowerBoxBlockEntity)) {
            return InteractionResult.PASS;
        }
        FlowerBoxBlockEntity flowerBoxBE = (FlowerBoxBlockEntity)blockEntity;
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_204117_(AFItemTags.FLOWER_BOX_PLACEABLES) || stack.m_204117_(AFItemTags.FLOWER_BOX_BANNED)) {
            return InteractionResult.PASS;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int slot = BlockPart.get1D(pos, hit.m_82450_(), facing.m_122427_(), 2);
        if (!level.f_46443_ && flowerBoxBE.placeFlower(player.m_150110_().f_35937_ ? stack.m_41777_() : stack, slot)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FlowerBoxBlockEntity) {
            FlowerBoxBlockEntity flowerBoxBE = (FlowerBoxBlockEntity)blockEntity;
            Containers.m_19010_((Level)level, (BlockPos)pos, flowerBoxBE.getItems());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

