/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.advspellarts.spells.ice;

import com.havnnek.advspellarts.entity.IcySnowflake;
import com.havnnek.advspellarts.init.AdvsSpellsArtsModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class SnowSquallSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("advs_spells_arts", "snowsquall");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.ICE_RESOURCE).setMaxLevel(7).setCooldownSeconds(100.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        int damage = this.getDamage(caster, spellLevel);
        int aoedamage = this.getAoeDamage(spellLevel, caster);
        float aoeradius = this.getRadius(spellLevel, caster);
        return List.of(Component.m_237110_((String)"ui.advs_spells_arts.damage", (Object[])new Object[]{Utils.stringTruncation((double)damage, (int)2)}), Component.m_237110_((String)"ui.irons_spellbooks.ring_count", (Object[])new Object[]{this.getRings(spellLevel, caster)}), Component.m_237110_((String)"ui.advs_spells_arts.aoe_damage", (Object[])new Object[]{Utils.stringTruncation((double)aoedamage, (int)2)}), Component.m_237110_((String)"ui.advs_spells_arts.aoeradius", (Object[])new Object[]{Utils.stringTruncation((double)aoeradius, (int)1)}), Component.m_237115_((String)"ui.advs_spells_arts.advtooltip"));
    }

    public SnowSquallSpell() {
        this.manaCostPerLevel = 25;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 30;
        this.baseManaCost = 100;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.CHARGE_RAISED_HAND;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.SELF_CAST_ANIMATION;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.CONE_OF_COLD_LOOP.get());
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)AdvsSpellsArtsModSounds.SNOWSQUALL_CAST_FINISH.get());
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Vec3 center = entity.m_146892_();
        int rings = this.getRings(spellLevel, entity);
        int count = 3;
        int damage = this.getDamage(entity, spellLevel);
        int aoedamage = this.getAoeDamage(spellLevel, entity);
        float aoeradius = this.getRadius(spellLevel, entity);
        for (int r = 0; r < rings; ++r) {
            float icy = count + r * r;
            int i = 0;
            while ((float)i < icy) {
                Vec3 spawn = center.m_82549_(new Vec3(0.0, 0.0, (double)(3 * (r + 1))).m_82524_(entity.m_146908_() * ((float)Math.PI / 180) + 6.281f / icy * (float)i));
                if (!level.m_8055_(BlockPos.m_274446_((Position)(spawn = Utils.moveToRelativeGroundLevel((Level)level, (Vec3)spawn, (int)30))).m_7495_()).m_60795_()) {
                    IcySnowflake ice = new IcySnowflake(level, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, this.get2DAngle(center, spawn), r, this.getDamage(entity, spellLevel), entity);
                    ice.m_146884_(spawn.m_82520_(0.0, 30.0, 0.0));
                    ice.setDamage(this.getDamage(entity, spellLevel));
                    ice.setExplosionRadius(this.getRadius(spellLevel, entity));
                    ice.setAoeDamage(this.getAoeDamage(spellLevel, entity));
                    level.m_7967_((Entity)ice);
                }
                ++i;
            }
        }
        MagicManager.spawnParticles((Level)level, (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)entity.m_20185_(), (double)(entity.m_20186_() + (double)(entity.m_20206_() * 0.5f)), (double)entity.m_20189_(), (int)50, (double)(entity.m_20205_() * 0.5f), (double)(entity.m_20206_() * 0.5f), (double)(entity.m_20205_() * 0.5f), (double)0.03, (boolean)false);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float get2DAngle(Vec3 a, Vec3 b) {
        return Utils.getAngle((Vec2)new Vec2((float)a.f_82479_, (float)a.f_82481_), (Vec2)new Vec2((float)b.f_82479_, (float)b.f_82481_));
    }

    public int getDamage(LivingEntity caster, int spellLevel) {
        return (int)(5.0 + (double)(this.getSpellPower(spellLevel, (Entity)caster) * 1.5f));
    }

    public int getAoeDamage(int spellLevel, LivingEntity caster) {
        return (int)(2.5 + (double)(this.getSpellPower(spellLevel, (Entity)caster) * 0.4f));
    }

    private int getRings(int spellLevel, LivingEntity entity) {
        return 3 + (spellLevel - 1) / 3;
    }

    public float getRadius(int spellLevel, LivingEntity caster) {
        return 2.0f + this.getEntityPowerMultiplier(caster);
    }
}

