/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.advspellarts.spells.evocation;

import com.havnnek.advspellarts.entity.RainingSwordEntity;
import com.havnnek.advspellarts.init.AdvsSpellsArtsModSounds;
import com.havnnek.advspellarts.init.MobRegistry;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class RainingSwordSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("advs_spells_arts", "raining_sword");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(4).setCooldownSeconds(50.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)1)}), Component.m_237110_((String)"ui.irons_spellbooks.projectile_count", (Object[])new Object[]{this.getCount(spellLevel, caster)}), Component.m_237115_((String)"ui.advs_spells_arts.advtooltip"));
    }

    public RainingSwordSpell() {
        this.manaCostPerLevel = 30;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 1;
        this.castTime = 50;
        this.baseManaCost = 140;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)AdvsSpellsArtsModSounds.RAINING_SWORD_PREPARE.get());
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity entity, MagicData playerMagicData) {
        Utils.preCastTargetHelper((Level)level, (LivingEntity)entity, (MagicData)playerMagicData, (AbstractSpell)this, (int)48, (float)0.25f, (boolean)false);
        return true;
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Vec3 targetLocation = null;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData) {
            TargetEntityCastData castTargetingData = (TargetEntityCastData)iCastData;
            targetLocation = castTargetingData.getTargetPosition((ServerLevel)level);
        }
        if (targetLocation == null) {
            targetLocation = Utils.raycastForEntity((Level)level, (Entity)entity, (float)100.0f, (boolean)true).m_82450_();
        }
        Vec3 backward = new Vec3(targetLocation.f_82479_ - entity.m_20185_(), 0.0, targetLocation.f_82481_ - entity.m_20189_()).m_82541_().m_82490_(-4.0);
        Vec3 raycastTarget = Utils.moveToRelativeGroundLevel((Level)level, (Vec3)targetLocation.m_82520_(0.0, 2.0, 0.0), (int)5).m_82549_(backward).m_82520_(0.0, 7.0, 0.0);
        Vec3 spawnLocation = Utils.raycastForBlock((Level)level, (Vec3)targetLocation, (Vec3)raycastTarget, (ClipContext.Fluid)ClipContext.Fluid.NONE).m_82450_();
        spawnLocation = spawnLocation.m_82546_(targetLocation).m_82490_((double)0.9f).m_82549_(targetLocation);
        float dx = Mth.m_14116_((float)((float)((spawnLocation.f_82479_ - targetLocation.f_82479_) * (spawnLocation.f_82479_ - targetLocation.f_82479_) + (spawnLocation.f_82481_ - targetLocation.f_82481_) * (spawnLocation.f_82481_ - targetLocation.f_82481_))));
        float swordAngleX = dx == 0.0f ? 70.0f : (float)(Mth.m_14136_((double)dx, (double)(spawnLocation.f_82480_ - targetLocation.f_82480_)) * 57.2957763671875);
        float swordAngleY = entity.m_20185_() == targetLocation.f_82479_ && entity.m_20189_() == targetLocation.f_82481_ ? (entity.m_146908_() - 90.0f) * ((float)Math.PI / 180) : Utils.getAngle((double)entity.m_20185_(), (double)entity.m_20189_(), (double)targetLocation.f_82479_, (double)targetLocation.f_82481_);
        RainingSwordEntity rainS = new RainingSwordEntity((EntityType<? extends Projectile>)((EntityType)MobRegistry.RAINING_SWORD_ENTITY.get()), level);
        rainS.m_20219_(spawnLocation);
        rainS.m_146922_(swordAngleY * 57.295776f + 90.0f);
        rainS.m_146926_(swordAngleX + 35.0f);
        rainS.setDamage(this.getDamage(spellLevel, entity));
        rainS.setSwordsPerRow(this.getSwordsPerRow(spellLevel, entity));
        rainS.setRows(this.getRows(spellLevel, entity));
        rainS.m_5602_((Entity)entity);
        level.m_7967_((Entity)rainS);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private int getCount(int spellLevel, LivingEntity entity) {
        return this.getRows(spellLevel, entity) * this.getSwordsPerRow(spellLevel, entity);
    }

    private int getRows(int spellLevel, LivingEntity entity) {
        return 8 + spellLevel;
    }

    private int getSwordsPerRow(int spellLevel, LivingEntity entity) {
        return 12 + spellLevel / 1;
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) * 0.75f;
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker).setIFrames(0);
    }
}

