/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.advspellarts.spells.evocation;

import com.havnnek.advspellarts.entity.Kunai;
import com.havnnek.advspellarts.init.AdvsSpellsArtsModMobEffects;
import com.havnnek.advspellarts.init.AdvsSpellsArtsModSounds;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class FuriousKnivesSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("advs_spells_arts", "furious_knives");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.EVOCATION_RESOURCE).setMaxLevel(5).setCooldownSeconds(40.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.advs_spells_arts.recast", (Object[])new Object[]{Utils.stringTruncation((double)this.getRecastCount(spellLevel, caster), (int)2)}), Component.m_237115_((String)"ui.advs_spells_arts.knives_of_recovery"), Component.m_237115_((String)"ui.advs_spells_arts.advtooltip"));
    }

    public FuriousKnivesSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 20;
        this.spellPowerPerLevel = 2;
        this.castTime = 0;
        this.baseManaCost = 75;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)AdvsSpellsArtsModSounds.KNIVES_THROW.get());
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Vec3 origin = entity.m_146892_();
        entity.m_7292_(new MobEffectInstance((MobEffect)AdvsSpellsArtsModMobEffects.WIND_FOCUS.get(), 200, 0, false, false, true));
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 160, castSource, null), playerMagicData);
        }
        Kunai kn = new Kunai(world, entity);
        kn.m_146884_(origin.m_82549_(entity.m_20156_()).m_82492_(0.0, (double)(kn.m_20206_() / 2.0f), 0.0));
        kn.shoot(entity.m_20154_());
        kn.setDamage(this.getDamage(spellLevel, entity));
        world.m_7967_((Entity)kn);
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity) * 0.5f;
    }

    public int getRecastCount(int spellLevel, LivingEntity entity) {
        return 5 + spellLevel / 3;
    }
}

