/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.advspellarts.spells.blood;

import com.havnnek.advspellarts.entity.RealHellfist;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class HellfistSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("advs_spells_arts", "hellfist");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchoolResource(SchoolRegistry.BLOOD_RESOURCE).setMaxLevel(6).setCooldownSeconds(30.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237115_((String)"ui.advs_spells_arts.hellfist_desc"), Component.m_237110_((String)"ui.advs_spells_arts.hellfist_count", (Object[])new Object[]{this.getCount(spellLevel, caster)}), Component.m_237110_((String)"ui.irons_spellbooks.ring_count", (Object[])new Object[]{this.getRings(spellLevel, caster)}), Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237115_((String)"ui.advs_spells_arts.advtooltip"));
    }

    public HellfistSpell() {
        this.manaCostPerLevel = 25;
        this.baseSpellPower = 12;
        this.spellPowerPerLevel = 2;
        this.castTime = 20;
        this.baseManaCost = 85;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public AnimationHolder getCastFinishAnimation() {
        return SpellAnimations.TOUCH_GROUND_ANIMATION;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.RAISE_DEAD_START.get());
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Vec3 forward = entity.m_20156_().m_82542_(1.0, 0.0, 1.0).m_82541_();
        Vec3 start = entity.m_146892_().m_82549_(forward.m_82490_(1.5));
        Vec3 center = entity.m_146892_();
        int rings = this.getRings(spellLevel, entity);
        int count = 6;
        for (int i = 0; i < this.getCount(spellLevel, entity); ++i) {
            Vec3 spawn = start.m_82549_(forward.m_82490_((double)i));
            if (world.m_8055_(BlockPos.m_274446_((Position)(spawn = new Vec3(spawn.f_82479_, (double)this.getGroundLevel(world, spawn, 8), spawn.f_82481_))).m_7495_()).m_60795_()) continue;
            int delay = i / 3;
            RealHellfist fist = new RealHellfist(world, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, (entity.m_146908_() - 90.0f) * ((float)Math.PI / 180), delay, this.getDamage(spellLevel, entity), entity);
            world.m_7967_((Entity)fist);
        }
        for (int r = 0; r < rings; ++r) {
            float fists = count + r * r;
            int i = 0;
            while ((float)i < fists) {
                Vec3 spawn = center.m_82549_(new Vec3(0.0, 0.0, 1.25 * (double)(r + 1)).m_82524_(entity.m_146908_() * ((float)Math.PI / 180) + 6.281f / fists * (float)i));
                if (!world.m_8055_(BlockPos.m_274446_((Position)(spawn = Utils.moveToRelativeGroundLevel((Level)world, (Vec3)spawn, (int)5))).m_7495_()).m_60795_()) {
                    RealHellfist fist = new RealHellfist(world, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, this.get2DAngle(center, spawn), r, this.getDamage(spellLevel, entity), entity);
                    world.m_7967_((Entity)fist);
                }
                ++i;
            }
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private float get2DAngle(Vec3 a, Vec3 b) {
        return Utils.getAngle((Vec2)new Vec2((float)a.f_82479_, (float)a.f_82481_), (Vec2)new Vec2((float)b.f_82479_, (float)b.f_82481_));
    }

    private int getGroundLevel(Level level, Vec3 start, int maxSteps) {
        if (!level.m_8055_(BlockPos.m_274446_((Position)start)).m_60795_()) {
            for (int i = 0; i < maxSteps && !level.m_8055_(BlockPos.m_274446_((Position)(start = start.m_82520_(0.0, 1.0, 0.0)))).m_60795_(); ++i) {
            }
        }
        Vec3 lower = level.m_45547_(new ClipContext(start, start.m_82520_(0.0, (double)(maxSteps * -2), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_82450_();
        return (int)lower.f_82480_;
    }

    public boolean shouldAIStopCasting(int spellLevel, Mob mob, LivingEntity target) {
        float f = (float)this.getCount(spellLevel, (LivingEntity)mob) * 1.2f;
        return mob.m_20280_((Entity)target) > (double)(f * f);
    }

    private int getCount(int spellLevel, LivingEntity entity) {
        return 10 + spellLevel;
    }

    private int getRings(int spellLevel, LivingEntity entity) {
        return 2 + (spellLevel - 1) / 2;
    }

    private float getDamage(int spellLevel, LivingEntity entity) {
        return this.getSpellPower(spellLevel, (Entity)entity);
    }
}

