/*
 * Decompiled with CFR 0.152.
 */
package com.havnnek.advspellarts.entity;

import com.havnnek.advspellarts.entity.IceField;
import com.havnnek.advspellarts.init.ADVSpellRegistry;
import com.havnnek.advspellarts.init.AdvsSpellsArtsModParticleTypes;
import com.havnnek.advspellarts.init.MobRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class IcySnowflake
extends AbstractMagicProjectile {
    private float customDamage;
    float aoeDamage;

    public IcySnowflake(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public IcySnowflake(Level level, double x, double y, double z, float angle, int ring, int damage, LivingEntity shooter) {
        this((EntityType<? extends Projectile>)((EntityType)MobRegistry.ICY_SNOWFLAKE.get()), level);
        this.m_5602_((Entity)shooter);
        this.aoeDamage = 1.0f;
        this.customDamage = 1.0f;
    }

    public void setCustomDamage(float damage) {
        this.customDamage = damage;
    }

    public float getCustomDamage() {
        return this.customDamage;
    }

    public void trailParticles() {
        Vec3 vec3 = this.m_20184_();
        double d0 = this.m_20185_() - vec3.f_82479_;
        double d1 = this.m_20186_() - vec3.f_82480_;
        double d2 = this.m_20189_() - vec3.f_82481_;
        for (int i = 0; i < 5; ++i) {
            Vec3 random = Utils.getRandomVec3((double)0.2);
            this.m_9236_().m_7106_(ParticleHelper.SNOW_DUST, d0 - random.f_82479_, d1 + 0.25 - random.f_82480_, d2 - random.f_82481_, random.f_82479_ * 0.25, random.f_82480_ * 0.25, random.f_82481_ * 0.25);
            this.m_9236_().m_7106_((ParticleOptions)AdvsSpellsArtsModParticleTypes.EXTRA_COLD_SNOW.get(), d0 - random.f_82479_, d1 + 0.35 - random.f_82480_, d2 - random.f_82481_, random.f_82479_ * (double)0.35f, random.f_82480_ * (double)0.35f, random.f_82481_ * (double)0.35f);
        }
    }

    public void impactParticles(double x, double y, double z) {
        MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleHelper.SNOWFLAKE, (double)x, (double)y, (double)z, (int)35, (double)0.01, (double)0.01, (double)0.01, (double)0.07, (boolean)false);
    }

    public float getSpeed() {
        return 0.65f;
    }

    protected void m_6532_(HitResult hitresult) {
        super.m_6532_(hitresult);
        this.CreateIceField(hitresult.m_82450_());
        float explosionRadius = this.getExplosionRadius();
        List entities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_((double)explosionRadius));
        for (Entity entity : entities) {
            double distance = entity.m_20238_(hitresult.m_82450_());
            if (!(distance < (double)(explosionRadius * explosionRadius)) || !this.m_5603_(entity) || !Utils.hasLineOfSight((Level)this.m_9236_(), (Vec3)hitresult.m_82450_(), (Vec3)entity.m_20182_().m_82520_(0.0, (double)(entity.m_20192_() * 0.5f), 0.0), (boolean)true)) continue;
            double p = 1.0 - Math.pow(Math.sqrt(distance) / (double)explosionRadius, 3.0);
            float damage = (float)((double)this.damage * p);
            DamageSources.applyDamage((Entity)entity, (float)damage, (DamageSource)((AbstractSpell)ADVSpellRegistry.SNOWSQUALL_SPELL.get()).getDamageSource((Entity)this, this.m_19749_()));
        }
        this.m_146870_();
    }

    public void CreateIceField(Vec3 location) {
        if (!this.m_9236_().f_46443_) {
            IceField ice = new IceField(this.m_9236_());
            ice.m_5602_(this.m_19749_());
            ice.setDuration(300);
            ice.setDamage(this.aoeDamage);
            ice.setRadius(this.getExplosionRadius());
            ice.setCircular();
            ice.m_20219_(location);
            this.m_9236_().m_7967_((Entity)ice);
        }
    }

    public void setAoeDamage(float damage) {
        this.aoeDamage = damage;
    }

    public float getAoeDamage() {
        return this.aoeDamage;
    }

    protected void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("AoeDamage", this.aoeDamage);
    }

    protected void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.aoeDamage = tag.m_128457_("AoeDamage");
    }

    protected void doImpactSound(SoundEvent sound) {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), sound, SoundSource.NEUTRAL, 2.0f, 1.2f + Utils.random.m_188501_() * 0.2f);
    }

    public Optional<SoundEvent> getImpactSound() {
        return Optional.of(SoundEvents.f_11983_);
    }
}

