/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.client.AccessoriesRendererRegistry;
import io.wispforest.accessories.api.client.AccessoryRenderer;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.impl.ExpandedSimpleContainer;
import java.util.Map;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin {
    @Unique
    private static HumanoidArm currentArm = null;

    @Shadow
    public abstract void m_7392_(AbstractClientPlayer var1, float var2, float var3, PoseStack var4, MultiBufferSource var5, int var6);

    @Inject(method={"renderHand"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/geom/ModelPart;render(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V", ordinal=1, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void accessories$firstPersonAccessories(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, ModelPart rendererArm, ModelPart rendererArmwear, CallbackInfo ci, PlayerModel playerModel) {
        if (currentArm != null) {
            AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)player);
            if (capability == null) {
                return;
            }
            for (Map.Entry<String, AccessoriesContainer> entry : capability.getContainers().entrySet()) {
                AccessoriesContainer container = entry.getValue();
                ExpandedSimpleContainer accessories = container.getAccessories();
                ExpandedSimpleContainer cosmetics = container.getCosmeticAccessories();
                for (int i = 0; i < accessories.m_6643_(); ++i) {
                    AccessoryRenderer renderer;
                    ItemStack stack = accessories.m_8020_(i);
                    ItemStack cosmeticStack = cosmetics.m_8020_(i);
                    if (!cosmeticStack.m_41619_()) {
                        stack = cosmeticStack;
                    }
                    if (stack.m_41619_() || (renderer = AccessoriesRendererRegistry.getRender(stack)) == null || !renderer.shouldRender(container.shouldRender(i))) continue;
                    poseStack.m_85836_();
                    renderer.renderOnFirstPerson(currentArm, stack, SlotReference.of((LivingEntity)player, container.getSlotName(), i), poseStack, playerModel, buffer, combinedLight);
                    poseStack.m_85849_();
                }
            }
        }
        currentArm = null;
    }

    @Inject(method={"renderRightHand"}, at={@At(value="HEAD")})
    private void accessories$firstPersonRightAccessories(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, CallbackInfo ci) {
        currentArm = HumanoidArm.RIGHT;
    }

    @Inject(method={"renderLeftHand"}, at={@At(value="HEAD")})
    private void accessories$firstPersonLeftAccessories(PoseStack poseStack, MultiBufferSource buffer, int combinedLight, AbstractClientPlayer player, CallbackInfo ci) {
        currentArm = HumanoidArm.LEFT;
    }
}

