/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.impl;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.impl.AccessoriesContainerImpl;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import it.unimi.dsi.fastutil.ints.Int2BooleanArrayMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanMap;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ExpandedSimpleContainer
extends SimpleContainer
implements Iterable<Pair<Integer, ItemStack>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AccessoriesContainerImpl container;
    private final String name;
    private final NonNullList<ItemStack> previousItems;
    private final Int2BooleanMap setFlags = new Int2BooleanArrayMap();
    private boolean newlyConstructed;

    public ExpandedSimpleContainer(AccessoriesContainerImpl container, int size, String name) {
        this(container, size, name, true);
    }

    public ExpandedSimpleContainer(AccessoriesContainerImpl container, int size, String name, boolean toggleNewlyConstructed) {
        super(size);
        this.container = container;
        this.m_19164_(container);
        if (toggleNewlyConstructed) {
            this.newlyConstructed = true;
        }
        this.name = name;
        this.previousItems = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    public String name() {
        return this.name;
    }

    public boolean wasNewlyConstructed() {
        boolean bl = this.newlyConstructed;
        this.newlyConstructed = false;
        return bl;
    }

    public boolean isSlotFlagged(int slot) {
        boolean bl = this.setFlags.getOrDefault(slot, false);
        if (bl) {
            this.setFlags.put(slot, false);
        }
        return bl;
    }

    public void setPreviousItem(int slot, ItemStack stack) {
        if (!this.validIndex(slot)) {
            return;
        }
        this.previousItems.set(slot, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public ItemStack getPreviousItem(int slot) {
        return slot >= 0 && slot < this.previousItems.size() ? (ItemStack)this.previousItems.get(slot) : ItemStack.f_41583_;
    }

    public ItemStack m_8020_(int slot) {
        if (!this.validIndex(slot)) {
            return ItemStack.f_41583_;
        }
        return super.m_8020_(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        if (!this.validIndex(slot)) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = super.m_7407_(slot, amount);
        if (!stack.m_41619_()) {
            this.setFlags.put(slot, true);
        }
        return stack;
    }

    public ItemStack m_8016_(int slot) {
        if (!this.validIndex(slot)) {
            return ItemStack.f_41583_;
        }
        return super.m_8016_(slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        if (!this.validIndex(slot)) {
            return;
        }
        super.m_6836_(slot, stack);
        this.setFlags.put(slot, true);
    }

    public boolean validIndex(int slot) {
        String nameInfo;
        boolean isValid = slot >= 0 && slot < this.m_6643_();
        String string = nameInfo = this.name != null ? "Container: " + this.name + ", " : "";
        if (!isValid && AccessoriesInternals.isDevelopmentEnv()) {
            try {
                throw new IllegalStateException("Access to a given Inventory was found to be out of the range valid for the container! [Name: " + nameInfo + " Index: " + slot + "]");
            }
            catch (Exception e) {
                LOGGER.debug("Full Exception: ", (Throwable)e);
            }
        }
        return isValid;
    }

    public void m_7797_(ListTag containerNbt) {
        this.container.containerListenerLock = true;
        AccessoriesCapability capability = this.container.capability;
        ArrayList<ItemStack> prevStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack currentStack = this.m_8020_(i);
            prevStacks.add(currentStack);
            this.m_6836_(i, ItemStack.f_41583_);
        }
        ArrayList<ItemStack> invalidStacks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> decodedStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < containerNbt.size(); ++i) {
            CompoundTag compoundTag = containerNbt.m_128728_(i);
            int j = compoundTag.m_128451_("Slot");
            ItemStack stack = ItemStack.m_41712_((CompoundTag)compoundTag);
            decodedStacks.add(stack);
            if (j >= 0 && j < this.m_6643_()) {
                this.m_6836_(j, stack);
                continue;
            }
            invalidStacks.add(stack);
        }
        this.container.containerListenerLock = false;
        if (!capability.entity().m_9236_().m_5776_()) {
            if (!prevStacks.equals(decodedStacks)) {
                this.m_6596_();
            }
            ((AccessoriesHolderImpl)capability.getHolder()).invalidStacks.addAll(invalidStacks);
        }
    }

    public ListTag m_7927_() {
        ListTag listTag = new ListTag();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128405_("Slot", i);
            listTag.add((Object)itemStack.m_41739_(compoundTag));
        }
        return listTag;
    }

    @Override
    @NotNull
    public Iterator<Pair<Integer, ItemStack>> iterator() {
        return new Iterator<Pair<Integer, ItemStack>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ExpandedSimpleContainer.this.m_6643_();
            }

            @Override
            public Pair<Integer, ItemStack> next() {
                Pair pair = new Pair((Object)this.index, (Object)ExpandedSimpleContainer.this.m_8020_(this.index));
                ++this.index;
                return pair;
            }
        };
    }

    public void setFromPrev(ExpandedSimpleContainer prevContainer) {
        prevContainer.forEach(pair -> this.setPreviousItem((Integer)pair.getFirst(), (ItemStack)pair.getSecond()));
    }

    public void copyPrev(ExpandedSimpleContainer prevContainer) {
        for (int i = 0; i < prevContainer.m_6643_(); ++i) {
            ItemStack prevItem;
            if (i >= this.m_6643_() || (prevItem = prevContainer.getPreviousItem(i)).m_41619_()) continue;
            this.setPreviousItem(i, prevItem);
        }
    }
}

