/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.client;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.slot.SlotGroup;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.client.AccessoriesMenuData;
import io.wispforest.accessories.client.ArmorSlot;
import io.wispforest.accessories.client.gui.AccessoriesInternalSlot;
import io.wispforest.accessories.data.SlotGroupLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.mixin.SlotAccessor;
import io.wispforest.accessories.networking.server.ScreenOpen;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class AccessoriesMenu
extends AbstractContainerMenu {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation BLOCK_ATLAS = new ResourceLocation("textures/atlas/blocks.png");
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SHIELD = new ResourceLocation("item/empty_armor_slot_shield");
    private static final Map<EquipmentSlot, ResourceLocation> TEXTURE_EMPTY_SLOTS = Map.of(EquipmentSlot.FEET, new ResourceLocation("item/empty_armor_slot_boots"), EquipmentSlot.LEGS, new ResourceLocation("item/empty_armor_slot_leggings"), EquipmentSlot.CHEST, new ResourceLocation("item/empty_armor_slot_chestplate"), EquipmentSlot.HEAD, new ResourceLocation("item/empty_armor_slot_helmet"));
    private static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    private final Player owner;
    @Nullable
    private final LivingEntity targetEntity;
    public int totalSlots = 0;
    public boolean overMaxVisibleSlots = false;
    public int scrolledIndex = 0;
    public float smoothScroll = 0.0f;
    private int maxScrollableIndex = 0;
    private int accessoriesSlotStartIndex = 0;
    private int cosmeticSlotStartIndex = 0;
    private final Set<SlotGroup> validGroups = new HashSet<SlotGroup>();
    private final Map<Integer, Boolean> slotToView = new HashMap<Integer, Boolean>();
    private Runnable onScrollToEvent = () -> {};
    @Nullable
    private Set<SlotType> usedSlots = null;

    public AccessoriesMenu(int containerId, Inventory inventory, @Nullable LivingEntity targetEntity) {
        super(Accessories.ACCESSORIES_MENU_TYPE, containerId);
        int i;
        this.owner = inventory.f_35978_;
        this.targetEntity = targetEntity;
        LivingEntity accessoryTarget = targetEntity != null ? targetEntity : this.owner;
        AccessoriesCapability capability = AccessoriesCapability.get(accessoryTarget);
        if (capability == null) {
            return;
        }
        for (i = 0; i < 4; ++i) {
            EquipmentSlot equipmentSlot = SLOT_IDS[i];
            ResourceLocation resourceLocation = TEXTURE_EMPTY_SLOTS.get(equipmentSlot);
            this.m_38897_(new ArmorSlot((Container)inventory, (LivingEntity)this.owner, equipmentSlot, 39 - i, 8, 8 + i * 18, resourceLocation));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)inventory, j + (i + 1) * 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 8 + i * 18, 142));
        }
        this.m_38897_(new Slot((Container)inventory, 40, 152, 62){

            public void m_269060_(ItemStack oldStack) {
                ItemStack newStack = this.m_7993_();
                AccessoriesMenu.this.owner.m_238392_(EquipmentSlot.OFFHAND, oldStack, newStack);
                super.m_269060_(oldStack);
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)BLOCK_ATLAS, (Object)EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        if (!this.areUnusedSlotsShown()) {
            this.usedSlots = ImmutableSet.copyOf(AccessoriesAPI.getUsedSlotsFor((LivingEntity)(targetEntity != null ? targetEntity : this.owner), (Container)this.owner.m_150109_()));
        }
        int minX = -46;
        int maxX = 60;
        int minY = 8;
        int maxY = 152;
        int yIndex = 0;
        this.accessoriesSlotStartIndex = this.f_38839_.size();
        HashMap<AccessoriesInternalSlot, Boolean> slotVisibility = new HashMap<AccessoriesInternalSlot, Boolean>();
        ArrayList<AccessoriesInternalSlot> accessoriesSlots = new ArrayList<AccessoriesInternalSlot>();
        ArrayList<AccessoriesInternalSlot> cosmeticSlots = new ArrayList<AccessoriesInternalSlot>();
        List<SlotGroup> groups = SlotGroupLoader.getGroups(inventory.f_35978_.m_9236_(), !this.areUniqueSlotsShown());
        Map<String, AccessoriesContainer> containers = capability.getContainers();
        List slotTypes = groups.stream().sorted(Comparator.comparingInt(SlotGroup::order).reversed()).flatMap(slotGroup -> slotGroup.slots().stream().map(s -> {
            SlotType slotType = SlotTypeLoader.getSlotType(this.owner.m_9236_(), s);
            if (this.usedSlots != null && !this.usedSlots.contains(slotType)) {
                return null;
            }
            this.validGroups.add((SlotGroup)slotGroup);
            return slotType;
        }).filter(Objects::nonNull).sorted(Comparator.comparingInt(SlotType::order).reversed())).toList();
        for (SlotType slot : slotTypes) {
            AccessoriesContainer accessoryContainer = containers.get(slot.name());
            if (accessoryContainer == null || accessoryContainer.slotType() == null) continue;
            int size = accessoryContainer.getSize();
            for (int i2 = 0; i2 < size; ++i2) {
                int currentY = yIndex * 18 + minY + 8;
                int currentX = minX;
                AccessoriesInternalSlot cosmeticSlot = new AccessoriesInternalSlot(yIndex, accessoryContainer, true, i2, currentX, currentY).isActive(slot1 -> this.isCosmeticsOpen() && this.slotToView.getOrDefault(slot1.f_40219_, true) != false).isAccessible(slot1 -> slot1.isCosmetic && this.isCosmeticsOpen());
                cosmeticSlots.add(cosmeticSlot);
                slotVisibility.put(cosmeticSlot, !this.overMaxVisibleSlots);
                AccessoriesInternalSlot baseSlot = new AccessoriesInternalSlot(yIndex, accessoryContainer, false, i2, currentX += 20, currentY).isActive(slot1 -> this.slotToView.getOrDefault(slot1.f_40219_, true));
                accessoriesSlots.add(baseSlot);
                slotVisibility.put(baseSlot, !this.overMaxVisibleSlots);
                ++yIndex;
                if (this.overMaxVisibleSlots || currentY + 18 <= maxY) continue;
                this.overMaxVisibleSlots = true;
            }
        }
        for (AccessoriesInternalSlot accessoriesSlot : accessoriesSlots) {
            this.m_38897_(accessoriesSlot);
            this.slotToView.put(accessoriesSlot.f_40219_, slotVisibility.getOrDefault((Object)accessoriesSlot, false));
        }
        this.cosmeticSlotStartIndex = this.f_38839_.size();
        for (AccessoriesInternalSlot cosmeticSlot : cosmeticSlots) {
            this.m_38897_(cosmeticSlot);
            this.slotToView.put(cosmeticSlot.f_40219_, slotVisibility.getOrDefault((Object)cosmeticSlot, false));
        }
        this.totalSlots = yIndex;
        this.maxScrollableIndex = this.totalSlots - 8;
    }

    public void setScrollEvent(Runnable event) {
        this.onScrollToEvent = event;
    }

    public boolean scrollTo(int i, boolean smooth) {
        int index = Math.min(Math.max(i, 0), this.maxScrollableIndex);
        if (index == this.scrolledIndex) {
            return false;
        }
        int diff = this.scrolledIndex - index;
        if (!smooth) {
            this.smoothScroll = Mth.m_14036_((float)((float)index / (float)this.maxScrollableIndex), (float)0.0f, (float)1.0f);
        }
        for (Slot slot : this.f_38839_) {
            if (!(slot instanceof AccessoriesInternalSlot)) continue;
            AccessoriesInternalSlot accessoriesSlot = (AccessoriesInternalSlot)slot;
            ((SlotAccessor)((Object)accessoriesSlot)).accessories$setY(accessoriesSlot.f_40221_ + diff * 18);
            int menuIndex = accessoriesSlot.menuIndex;
            this.slotToView.put(accessoriesSlot.f_40219_, menuIndex >= index && menuIndex < index + 8);
        }
        this.scrolledIndex = index;
        this.onScrollToEvent.run();
        return true;
    }

    public int maxScrollableIndex() {
        return this.maxScrollableIndex;
    }

    @Nullable
    public LivingEntity targetEntity() {
        return this.targetEntity;
    }

    public Player owner() {
        return this.owner;
    }

    public static AccessoriesMenu of(int containerId, Inventory inventory, AccessoriesMenuData data) {
        LivingEntity targetEntity = data.targetEntityId().map(i -> {
            Entity entity = inventory.f_35978_.m_9236_().m_6815_(i.intValue());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return livingEntity;
            }
            return null;
        }).orElse(null);
        return new AccessoriesMenu(containerId, inventory, targetEntity);
    }

    public boolean showingSlots() {
        return this.usedSlots == null || !this.usedSlots.isEmpty();
    }

    @Nullable
    public Set<SlotType> usedSlots() {
        return this.usedSlots;
    }

    public Set<SlotGroup> validGroups() {
        return this.validGroups;
    }

    public boolean isCosmeticsOpen() {
        return Optional.ofNullable(AccessoriesHolder.get((LivingEntity)this.owner)).map(AccessoriesHolder::cosmeticsShown).orElse(false);
    }

    public boolean areLinesShown() {
        return Optional.ofNullable(AccessoriesHolder.get((LivingEntity)this.owner)).map(AccessoriesHolder::linesShown).orElse(false);
    }

    public boolean areUnusedSlotsShown() {
        return Optional.ofNullable(AccessoriesHolder.get((LivingEntity)this.owner)).map(AccessoriesHolder::showUnusedSlots).orElse(false);
    }

    public boolean areUniqueSlotsShown() {
        return Optional.ofNullable(AccessoriesHolder.get((LivingEntity)this.owner)).map(AccessoriesHolder::showUniqueSlots).orElse(false);
    }

    public void reopenMenu() {
        AccessoriesInternals.getNetworkHandler().sendToServer(ScreenOpen.of(this.targetEntity));
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public ItemStack m_7648_(Player player, int clickedIndex) {
        int targetArmorSlotIndex;
        NonNullList slots = this.f_38839_;
        Slot clickedSlot = (Slot)slots.get(clickedIndex);
        if (!clickedSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack clickedStack = clickedSlot.m_7993_();
        ItemStack oldStack = clickedStack.m_41777_();
        EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)oldStack);
        int armorSlots = 4;
        int hotbarSlots = 9;
        int invSlots = 27;
        int armorStart = 0;
        int armorEnd = armorStart - 1 + armorSlots;
        int invStart = armorEnd + 1;
        int invEnd = invStart - 1 + invSlots;
        int hotbarStart = invEnd + 1;
        int hotbarEnd = hotbarStart - 1 + hotbarSlots;
        int offhand = hotbarEnd + 1;
        if (clickedIndex < this.accessoriesSlotStartIndex ? !this.m_38903_(clickedStack, this.accessoriesSlotStartIndex, this.f_38839_.size(), false) && (clickedIndex >= armorStart && clickedIndex <= armorEnd ? !this.m_38903_(clickedStack, invStart, hotbarEnd, false) : (equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(armorEnd - equipmentSlot.m_20749_())).m_6657_() ? !this.m_38903_(clickedStack, targetArmorSlotIndex = armorEnd - equipmentSlot.m_20749_(), targetArmorSlotIndex + 1, false) : (equipmentSlot == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(offhand)).m_6657_() ? !this.m_38903_(clickedStack, offhand, offhand + 1, false) : (clickedIndex >= hotbarStart && clickedIndex <= hotbarEnd ? !this.m_38903_(clickedStack, invStart, invEnd, false) : (clickedIndex >= invStart && clickedIndex <= invEnd ? !this.m_38903_(clickedStack, hotbarStart, hotbarEnd, false) : !this.m_38903_(clickedStack, invStart, hotbarEnd, false)))))) : !this.m_38903_(clickedStack, invStart, hotbarEnd, false)) {
            return ItemStack.f_41583_;
        }
        if (clickedStack.m_41619_()) {
            clickedSlot.m_269060_(ItemStack.f_41583_);
        } else {
            clickedSlot.m_6654_();
        }
        if (clickedStack.m_41613_() == oldStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        clickedSlot.m_142406_(player, clickedStack);
        return oldStack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack itemStack;
        Slot slot;
        boolean bl = false;
        int i = startIndex;
        if (reverseDirection) {
            i = endIndex - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && (reverseDirection ? i >= startIndex : i < endIndex)) {
                slot = (Slot)this.f_38839_.get(i);
                if (slot.m_5866_(itemStack = slot.m_7993_()) < itemStack.m_41613_() && !itemStack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack)) {
                    int j = itemStack.m_41613_() + stack.m_41613_();
                    if (j <= stack.m_41741_()) {
                        stack.m_41764_(0);
                        itemStack.m_41764_(j);
                        slot.m_6654_();
                        bl = true;
                    } else if (itemStack.m_41613_() < stack.m_41741_()) {
                        stack.m_41774_(stack.m_41741_() - itemStack.m_41613_());
                        itemStack.m_41764_(stack.m_41741_());
                        slot.m_6654_();
                        bl = true;
                    }
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = reverseDirection ? endIndex - 1 : startIndex;
            while (reverseDirection ? i >= startIndex : i < endIndex) {
                slot = (Slot)this.f_38839_.get(i);
                itemStack = slot.m_7993_();
                if (itemStack.m_41619_() && slot.m_5857_(stack)) {
                    if (stack.m_41613_() > slot.m_5866_(stack)) {
                        slot.m_269060_(stack.m_41620_(slot.m_5866_(stack)));
                    } else {
                        slot.m_269060_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot.m_6654_();
                    bl = true;
                    break;
                }
                if (reverseDirection) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return bl;
    }
}

