/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.events.extra;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.events.extra.AllowWalkingOnSnow;
import io.wispforest.accessories.api.events.extra.EndermanMasked;
import io.wispforest.accessories.api.events.extra.FortuneAdjustment;
import io.wispforest.accessories.api.events.extra.LootingAdjustment;
import io.wispforest.accessories.api.events.extra.PiglinNeutralInducer;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class ExtraEventHandler {
    private static final LoadingCache<Integer, Map<Integer, TriState>> endermanAngyCacheResults = CacheBuilder.newBuilder().concurrencyLevel(1).expireAfterAccess(Duration.ofSeconds(1L)).weakKeys().build(CacheLoader.from(() -> new HashMap()));

    public static int lootingAdjustments(LivingEntity entity, DamageSource damageSource, int currentLevel) {
        Entity entity2;
        if (damageSource != null && (entity2 = damageSource.m_7639_()) instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)entity2;
            AccessoriesCapability capability = AccessoriesCapability.get(entity);
            if (capability != null) {
                for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                    SlotReference reference = entryRef.reference();
                    ItemStack stack = entryRef.stack();
                    Accessory accessory = AccessoriesAPI.getAccessory(stack);
                    if (accessory instanceof LootingAdjustment) {
                        LootingAdjustment lootingAdjustment = (LootingAdjustment)((Object)accessory);
                        currentLevel += lootingAdjustment.getLootingAdjustment(stack, reference, targetEntity, damageSource, currentLevel);
                    }
                    currentLevel += ((LootingAdjustment)LootingAdjustment.EVENT.invoker()).getLootingAdjustment(stack, reference, targetEntity, damageSource, currentLevel);
                }
            }
        }
        return currentLevel;
    }

    public static int fortuneAdjustment(LootContext context, int currentLevel) {
        LivingEntity livingEntity;
        AccessoriesCapability capability;
        Object object = context.m_78953_(LootContextParams.f_81455_);
        if (object instanceof LivingEntity && (capability = AccessoriesCapability.get(livingEntity = (LivingEntity)object)) != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                SlotReference reference = entryRef.reference();
                ItemStack stack = entryRef.stack();
                Accessory accessory = AccessoriesAPI.getAccessory(stack);
                if (accessory instanceof FortuneAdjustment) {
                    FortuneAdjustment fortuneAdjustment = (FortuneAdjustment)((Object)accessory);
                    currentLevel += fortuneAdjustment.getFortuneAdjustment(stack, reference, context, currentLevel);
                }
                currentLevel += ((FortuneAdjustment)FortuneAdjustment.EVENT.invoker()).getFortuneAdjustment(stack, reference, context, currentLevel);
            }
        }
        return currentLevel;
    }

    public static TriState isPiglinsNeutral(LivingEntity entity) {
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                PiglinNeutralInducer inducer;
                SlotReference reference = entryRef.reference();
                ItemStack stack = entryRef.stack();
                Accessory accessory = AccessoriesAPI.getAccessory(stack);
                if (accessory instanceof PiglinNeutralInducer && (state = (inducer = (PiglinNeutralInducer)((Object)accessory)).makePiglinsNeutral(stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((PiglinNeutralInducer)PiglinNeutralInducer.EVENT.invoker()).makePiglinsNeutral(stack, reference);
                if (state == TriState.DEFAULT) continue;
                return state;
            }
        }
        return state;
    }

    public static TriState allowWalkingOnSnow(LivingEntity entity) {
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                AllowWalkingOnSnow event;
                SlotReference reference = entryRef.reference();
                ItemStack stack = entryRef.stack();
                Accessory accessory = AccessoriesAPI.getAccessory(stack);
                if (accessory instanceof AllowWalkingOnSnow && (state = (event = (AllowWalkingOnSnow)((Object)accessory)).allowWalkingOnSnow(stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((AllowWalkingOnSnow)AllowWalkingOnSnow.EVENT.invoker()).allowWalkingOnSnow(stack, reference);
                if (state == TriState.DEFAULT) continue;
                return state;
            }
        }
        return state;
    }

    public static TriState isEndermanMask(LivingEntity entity, EnderMan enderMan) {
        Map cache = (Map)endermanAngyCacheResults.getIfPresent((Object)entity.m_19879_());
        if (cache != null && cache.containsKey(enderMan.m_19879_())) {
            return (TriState)cache.get(enderMan.m_19879_());
        }
        TriState state = TriState.DEFAULT;
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability != null) {
            for (SlotEntryReference entryRef : capability.getAllEquipped()) {
                EndermanMasked masked;
                SlotReference reference = entryRef.reference();
                ItemStack stack = entryRef.stack();
                Accessory accessory = AccessoriesAPI.getAccessory(stack);
                if (accessory instanceof EndermanMasked && (state = (masked = (EndermanMasked)((Object)accessory)).isEndermanMasked(enderMan, stack, reference)) != TriState.DEFAULT) {
                    return state;
                }
                state = ((EndermanMasked)EndermanMasked.EVENT.invoker()).isEndermanMasked(enderMan, stack, reference);
                if (state == TriState.DEFAULT) continue;
                return state;
            }
        }
        ((Map)endermanAngyCacheResults.getUnchecked((Object)entity.m_19879_())).put(enderMan.m_19879_(), state);
        return state;
    }
}

