/*
 * Decompiled with CFR 0.152.
 */
package com.kekecreations.jinxedlib.core.util;

import com.google.common.collect.Sets;
import com.kekecreations.jinxedlib.JinxedLib;
import com.kekecreations.jinxedlib.core.mixin.SpriteSourcesInvoker;
import com.kekecreations.jinxedlib.core.mixin.WoodTypeInvoker;
import com.kekecreations.jinxedlib.core.platform.Services;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;

public class JinxedRegistryHelper {
    private static final Set<ResourceLocation> LOCATIONS = Sets.newHashSet();
    private static final Set<ResourceLocation> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);

    public static <T> Supplier<T> register(Registry<T> registry, String modID, String name, Supplier<T> supplier) {
        return Services.REGISTRY.register(registry, modID, name, supplier);
    }

    public static <T extends CreativeModeTab> Supplier<T> registerCreativeModeTab(String modID, String name, Supplier<T> supplier) {
        return Services.REGISTRY.registerCreativeModeTab(modID, name, supplier);
    }

    public static Supplier<Item> registerItem(String modID, String name, Supplier<Item> supplier) {
        return Services.REGISTRY.register(BuiltInRegistries.f_257033_, modID, name, supplier);
    }

    public static Supplier<Block> registerBlock(String modID, String name, boolean hasItem, Supplier<Block> supplier) {
        Supplier<Block> block = Services.REGISTRY.register(BuiltInRegistries.f_256975_, modID, name, supplier);
        if (hasItem) {
            JinxedRegistryHelper.registerItem(modID, name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
        }
        return block;
    }

    public static WoodType registerWoodType(WoodType woodType) {
        return WoodTypeInvoker.invokeRegister(woodType);
    }

    public static ResourceLocation registerBuiltInLootTable(String modID, String name) {
        return JinxedRegistryHelper.register(JinxedLib.customId(modID, name));
    }

    private static ResourceLocation register(ResourceLocation resourceLocation) {
        if (LOCATIONS.add(resourceLocation)) {
            return resourceLocation;
        }
        throw new IllegalArgumentException(String.valueOf(resourceLocation) + " is already a registered built-in loot table");
    }

    public static Set<ResourceLocation> all() {
        return IMMUTABLE_LOCATIONS;
    }

    public static SpriteSourceType registerSpriteSource(String id, Codec<? extends SpriteSource> codec) {
        return SpriteSourcesInvoker.invokeRegister(id, codec);
    }
}

