/*
 * Decompiled with CFR 0.152.
 */
package team.creative.itemphysic.common;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.itemphysic.ItemPhysic;

public class CommonPhysic {
    public static float getViscosity(Fluid fluid, Level level) {
        if (fluid == null) {
            return 0.0f;
        }
        return CreativeCore.loader().getFluidViscosityMultiplier(fluid, level);
    }

    public static Fluid getFluid(ItemEntity item) {
        return CommonPhysic.getFluid(item, false);
    }

    public static Fluid getFluid(ItemEntity item, boolean below) {
        if (item.m_9236_() == null) {
            return null;
        }
        double d0 = item.m_20186_();
        BlockPos pos = item.m_20183_();
        if (below) {
            pos = pos.m_7495_();
        }
        FluidState state = item.m_9236_().m_6425_(pos);
        Fluid fluid = state.m_76152_();
        if (state.m_76178_() || fluid == null) {
            return null;
        }
        if (below) {
            return fluid;
        }
        double filled = state.m_76155_((BlockGetter)item.m_9236_(), pos);
        if (d0 - (double)pos.m_123342_() - 0.2 <= filled) {
            return fluid;
        }
        return null;
    }

    public static double getReachDistance(Player player) {
        if (ItemPhysic.CONFIG.pickup.maximumPickupRange != 5.0) {
            return ItemPhysic.CONFIG.pickup.maximumPickupRange;
        }
        return PlayerUtils.getReach((Player)player);
    }

    public static HitResult getEntityItem(Player player, Vec3 position, Vec3 look) {
        Vec3 include = look.m_82546_(position);
        List list = player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82363_(include.f_82479_, include.f_82480_, include.f_82481_));
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(entity instanceof ItemEntity)) continue;
            AABB axisalignedbb = entity.m_20191_().m_82400_(ItemPhysic.CONFIG.pickup.hitboxIncrease);
            Optional vec = axisalignedbb.m_82371_(position, look);
            if (vec.isPresent()) {
                return new EntityHitResult(entity, (Vec3)vec.get());
            }
            if (!axisalignedbb.m_82390_(position)) continue;
            return new EntityHitResult(entity);
        }
        return null;
    }
}

