/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.compat;

import com.fizzware.dramaticdoors.forge.compat.Compats;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DDCompatRecipe {
    public static List<JsonObject> SHORT_DOOR_RECIPES = new ArrayList<JsonObject>();
    public static List<JsonObject> TALL_DOOR_RECIPES = new ArrayList<JsonObject>();
    public static final String WOODWORKS_SAWMILL = "woodworks:sawmill";
    public static final String UNIVERSAL_SAWMILL = "sawmill:woodcutting";
    public static final String AURORASDECO_SAWMILL = "aurorasdeco:woodcutting";

    public static JsonObject createShortDoorRecipe(String recipeID, ResourceLocation baseDoor) {
        JsonObject json = DDCompatRecipe.createStonecutterRecipeJson(new ResourceLocation(baseDoor.m_135827_(), baseDoor.m_135815_()), new ResourceLocation("dramaticdoors:" + recipeID));
        SHORT_DOOR_RECIPES.add(json);
        return json;
    }

    public static void createShortDoorRecipe(String recipeID, ResourceLocation baseDoor, boolean isWood) {
        if (isWood) {
            if (Compats.isModLoaded("woodworks", Compats.modChecker) || Compats.isModLoaded("aurorasdeco", Compats.modChecker) || Compats.isModLoaded("sawmill", Compats.modChecker)) {
                JsonObject json;
                if (Compats.isModLoaded("woodworks", Compats.modChecker)) {
                    json = DDCompatRecipe.createSawmillRecipeJson(new ResourceLocation(baseDoor.m_135827_(), baseDoor.m_135815_()), new ResourceLocation("dramaticdoors:" + recipeID), WOODWORKS_SAWMILL);
                    SHORT_DOOR_RECIPES.add(json);
                }
                if (Compats.isModLoaded("sawmill", Compats.modChecker)) {
                    json = DDCompatRecipe.createSawmillRecipeJson(new ResourceLocation(baseDoor.m_135827_(), baseDoor.m_135815_()), new ResourceLocation("dramaticdoors:" + recipeID), UNIVERSAL_SAWMILL);
                    SHORT_DOOR_RECIPES.add(json);
                }
                if (Compats.isModLoaded("aurorasdeco", Compats.modChecker)) {
                    json = DDCompatRecipe.createSawmillRecipeJson(new ResourceLocation(baseDoor.m_135827_(), baseDoor.m_135815_()), new ResourceLocation("dramaticdoors:" + recipeID), AURORASDECO_SAWMILL);
                    SHORT_DOOR_RECIPES.add(json);
                }
            } else {
                JsonObject json = DDCompatRecipe.createStonecutterRecipeJson(new ResourceLocation(baseDoor.m_135827_(), baseDoor.m_135815_()), new ResourceLocation("dramaticdoors:" + recipeID));
                SHORT_DOOR_RECIPES.add(json);
            }
        } else {
            JsonObject json = DDCompatRecipe.createStonecutterRecipeJson(new ResourceLocation(baseDoor.m_135827_(), baseDoor.m_135815_()), new ResourceLocation("dramaticdoors:" + recipeID));
            SHORT_DOOR_RECIPES.add(json);
        }
    }

    public static void createTallDoorRecipe(String recipeID, ResourceLocation baseDoor, @Nullable String group) {
        JsonObject json = DDCompatRecipe.createShapedRecipeJson(Lists.newArrayList((Object[])new Character[]{Character.valueOf('#')}), Lists.newArrayList((Object[])new ResourceLocation[]{new ResourceLocation(baseDoor.m_135827_(), baseDoor.m_135815_())}), Lists.newArrayList((Object[])new String[]{"item"}), Lists.newArrayList((Object[])new String[]{"#", "#", "#"}), new ResourceLocation("dramaticdoors:" + recipeID), group);
        TALL_DOOR_RECIPES.add(json);
    }

    public static JsonObject createShapedRecipeJson(ArrayList<Character> keys, ArrayList<ResourceLocation> items, ArrayList<String> type, ArrayList<String> pattern, ResourceLocation output, @Nullable String group) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:crafting_shaped");
        if (group != null) {
            json.addProperty("group", group);
        }
        JsonArray jsonArray = new JsonArray();
        jsonArray.add(pattern.get(0));
        jsonArray.add(pattern.get(1));
        jsonArray.add(pattern.get(2));
        json.add("pattern", (JsonElement)jsonArray);
        JsonObject keyList = new JsonObject();
        for (int i = 0; i < keys.size(); ++i) {
            JsonObject individualKey = new JsonObject();
            individualKey.addProperty(type.get(i), items.get(i).toString());
            keyList.add("" + keys.get(i), (JsonElement)individualKey);
        }
        json.add("key", (JsonElement)keyList);
        JsonObject result = new JsonObject();
        result.addProperty("item", output.toString());
        result.addProperty("count", (Number)2);
        json.add("result", (JsonElement)result);
        return json;
    }

    public static JsonObject createStonecutterRecipeJson(ResourceLocation input, ResourceLocation output) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:stonecutting");
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("item", input.toString());
        json.add("ingredient", (JsonElement)ingredient);
        json.addProperty("result", output.toString());
        json.addProperty("count", (Number)2);
        return json;
    }

    public static JsonObject createSawmillRecipeJson(ResourceLocation input, ResourceLocation output, String recipeType) {
        JsonObject json = new JsonObject();
        json.addProperty("type", recipeType);
        JsonObject ingredient = new JsonObject();
        ingredient.addProperty("item", input.toString());
        json.add("ingredient", (JsonElement)ingredient);
        json.addProperty("result", output.toString());
        json.addProperty("count", (Number)2);
        return json;
    }
}

