/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.client.audio;

import com.mojang.blaze3d.audio.OggAudioStream;
import com.mrbysco.disccord.client.audio.AudioHandlerClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.Util;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.LoopingAudioStream;
import net.minecraft.resources.ResourceLocation;

public class StreamHelper {
    public static CompletableFuture<AudioStream> getStream(ResourceLocation resourceLocation, boolean isWrapper) {
        if (!resourceLocation.m_135827_().equals("disccord")) {
            return null;
        }
        if (resourceLocation.m_135815_().contains("placeholder_sound.ogg")) {
            return null;
        }
        CharSequence[] splitNamespace = resourceLocation.m_135815_().split("/");
        splitNamespace = Arrays.copyOfRange(splitNamespace, 2, splitNamespace.length);
        String fileUrl = String.join((CharSequence)"/", splitNamespace);
        String finalFileUrl = fileUrl = fileUrl.substring(0, fileUrl.length() - 4);
        return CompletableFuture.supplyAsync(() -> {
            try {
                AudioHandlerClient audioHandler = new AudioHandlerClient();
                InputStream inputStream = audioHandler.getAudioInputStream(finalFileUrl);
                if (inputStream == null) {
                    return null;
                }
                return isWrapper ? new LoopingAudioStream(OggAudioStream::new, inputStream) : new OggAudioStream(inputStream);
            }
            catch (IOException ioexception) {
                throw new CompletionException(ioexception);
            }
        }, Util.m_183991_());
    }
}

