/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.disccord.client;

import com.mrbysco.disccord.client.audio.AudioHandlerClient;
import com.mrbysco.disccord.client.audio.sound.EntityBoundFileSound;
import com.mrbysco.disccord.client.audio.sound.FileSound;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ClientHandler {
    public static final Map<Vec3, FileSound> playingSounds = new HashMap<Vec3, FileSound>();
    public static final Map<UUID, FileSound> playingSoundsByUUID = new HashMap<UUID, FileSound>();

    public static void playRecord(Vec3 centerPos, String fileUrl, @NotNull UUID uuid, int entityId) {
        FileSound currentSound;
        boolean isEntityBound;
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null || mc.f_91074_ == null) {
            return;
        }
        if (entityId >= 0) {
            entity = level.m_6815_(entityId);
            isEntityBound = entity != null;
        } else {
            entity = null;
            isEntityBound = false;
        }
        FileSound fileSound = currentSound = !uuid.equals(Util.f_137441_) ? playingSoundsByUUID.get(uuid) : playingSounds.get(centerPos);
        if (currentSound != null) {
            mc.m_91106_().m_120399_((SoundInstance)currentSound);
            if (!uuid.equals(Util.f_137441_)) {
                playingSoundsByUUID.remove(uuid);
            } else {
                playingSounds.remove(centerPos);
            }
        }
        if (fileUrl.isEmpty()) {
            return;
        }
        AudioHandlerClient audioHandler = new AudioHandlerClient();
        if (!audioHandler.checkForAudioFile(fileUrl)) {
            mc.f_91074_.m_213846_((Component)Component.m_237115_((String)"disccord.song.downloading"));
            audioHandler.downloadVideoAsOgg(fileUrl).thenApply(in -> {
                mc.f_91074_.m_213846_((Component)Component.m_237115_((String)"disccord.song.succeed"));
                FileSound fileSound = isEntityBound ? new EntityBoundFileSound(fileUrl, entity) : new FileSound(fileUrl, centerPos);
                if (!uuid.equals(Util.f_137441_)) {
                    playingSoundsByUUID.put(uuid, fileSound);
                } else {
                    playingSounds.put(centerPos, fileSound);
                }
                mc.m_91106_().m_120367_((SoundInstance)fileSound);
                return null;
            });
            return;
        }
        FileSound fileSound2 = isEntityBound ? new EntityBoundFileSound(fileUrl, entity) : new FileSound(fileUrl, centerPos);
        if (!uuid.equals(Util.f_137441_)) {
            playingSoundsByUUID.put(uuid, fileSound2);
        } else {
            playingSounds.put(centerPos, fileSound2);
        }
        mc.m_91106_().m_120367_((SoundInstance)fileSound2);
    }
}

