/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.menu;

import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import tfar.davespotioneering.DavesPotioneering;
import tfar.davespotioneering.PotionUtils2;
import tfar.davespotioneering.init.ModMenuTypes;
import tfar.davespotioneering.inventory.BasicInventoryBridge;
import tfar.davespotioneering.menu.CAdvancedBrewingStandMenu;
import tfar.davespotioneering.platform.Services;

public class CPotionInjectorMenu
extends AbstractContainerMenu {
    private final BasicInventoryBridge inventory;
    public static final int BLAZE_CAP = 32;

    public CPotionInjectorMenu(int id, Inventory playerInventory) {
        this(id, playerInventory, Services.PLATFORM.makePotionInjector(8));
    }

    public CPotionInjectorMenu(int id, Inventory playerInventory, BasicInventoryBridge inventory) {
        super(ModMenuTypes.ALCHEMICAL_GAUNTLET, id);
        this.inventory = inventory;
        int potY = 77;
        for (int i = 0; i < 6; ++i) {
            this.m_38897_(Services.PLATFORM.makeBasic(inventory, i, 26 + 108 * (i / 3), 18 + 18 * (i % 3)));
        }
        this.m_38897_(Services.PLATFORM.makeBasic(inventory, 6, 80, 32));
        this.m_38897_(Services.PLATFORM.makeBasic(inventory, 7, 80, 55));
        int invX = 8;
        int invY = 109;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, invX + j * 18, invY + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, invX + k * 18, invY + 58));
        }
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.inventory.$getSlots() ? !this.m_38903_(itemstack1, this.inventory.$getSlots(), this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.inventory.$getSlots(), false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void handleButton(int button) {
        switch (button) {
            case 0: {
                this.storePotionsAndBlaze();
                break;
            }
            case 1: {
                this.removePotionsAndBlaze();
            }
        }
    }

    private void storePotionsAndBlaze() {
        ItemStack gauntlet = this.inventory.$getStackInSlot(6);
        if (!gauntlet.m_41619_()) {
            CompoundTag newNbt = new CompoundTag();
            ListTag potionList = new ListTag();
            CompoundTag oldNBT = gauntlet.m_41784_();
            CompoundTag info = oldNBT.m_128469_("info");
            ListTag oldPotionList = info.m_128437_("potions", 10);
            for (int i = 0; i < 6; ++i) {
                List oldCustomEffects;
                CompoundTag oldTag = oldPotionList.isEmpty() ? new CompoundTag() : oldPotionList.m_128728_(i);
                Potion oldPotion = oldPotionList.isEmpty() ? Potions.f_43598_ : PotionUtils.m_43577_((CompoundTag)oldTag);
                List list = oldCustomEffects = oldPotionList.isEmpty() ? List.of() : PotionUtils.m_43573_((CompoundTag)oldTag);
                if (oldPotion == Potions.f_43598_ && oldCustomEffects.isEmpty()) {
                    ItemStack potionStack = this.inventory.$getStackInSlot(i);
                    potionList.add((Object)PotionUtils2.saveAllEffects(new CompoundTag(), PotionUtils.m_43579_((ItemStack)potionStack), PotionUtils.m_43571_((ItemStack)potionStack)));
                    this.inventory.$extractItem(i, 1, false);
                    continue;
                }
                potionList.add((Object)oldPotionList.get(i));
            }
            newNbt.m_128405_("activePotionIndex", 0);
            newNbt.m_128365_("potions", (Tag)potionList);
            int presentBlaze = info.m_128451_("blaze");
            int blazeInsert = Math.min(32 - presentBlaze, Math.min(32, this.inventory.$getStackInSlot(7).m_41613_()));
            newNbt.m_128405_("blaze", blazeInsert + presentBlaze);
            this.inventory.$extractItem(7, blazeInsert, false);
            System.out.println(potionList.m_7264_());
            gauntlet.m_41783_().m_128365_("info", (Tag)newNbt);
        }
    }

    private void removePotionsAndBlaze() {
        ItemStack gauntlet = this.inventory.$getStackInSlot(6);
        if (!gauntlet.m_41619_()) {
            CompoundTag nbt = gauntlet.m_41783_().m_128469_("info");
            ListTag listNBT = nbt.m_128437_("potions", 10);
            boolean allRemoved = true;
            for (int i = 0; i < listNBT.size(); ++i) {
                CompoundTag inbt = listNBT.m_128728_(i);
                Potion potion = PotionUtils.m_43577_((CompoundTag)inbt);
                List customEffects = PotionUtils.m_43573_((CompoundTag)inbt);
                if (potion == Potions.f_43598_ && customEffects.isEmpty()) continue;
                ItemStack present = this.inventory.$getStackInSlot(i);
                if (present.m_41613_() < this.inventory.$getSlotLimit(i)) {
                    ItemStack stack = new ItemStack((ItemLike)Items.f_42739_);
                    PotionUtils.m_43549_((ItemStack)stack, (Potion)potion);
                    PotionUtils.m_43552_((ItemStack)stack, (Collection)customEffects);
                    this.inventory.$insertItem(i, stack, false);
                    listNBT.set(i, (Tag)new CompoundTag());
                    continue;
                }
                allRemoved = false;
            }
            if (allRemoved) {
                nbt.m_128473_("potions");
            }
            int presentBlaze = this.inventory.$getStackInSlot(7).m_41613_();
            int maxBlazeRemove = this.inventory.$getSlotLimit(7) - presentBlaze;
            int blaze = nbt.m_128451_("blaze");
            int blazeRemove = Math.min(maxBlazeRemove, blaze);
            this.inventory.$insertItem(7, new ItemStack((ItemLike)Items.f_42593_, blazeRemove), false);
            if (blaze > blazeRemove) {
                nbt.m_128405_("blaze", blaze - blazeRemove);
            } else {
                nbt.m_128473_("blaze");
            }
        }
    }

    protected boolean m_38903_(ItemStack pStack, int pStartIndex, int pEndIndex, boolean pReverseDirection) {
        if (DavesPotioneering.isFabric) {
            return CAdvancedBrewingStandMenu.patchedMoveTo(this, pStack, pStartIndex, pEndIndex, pReverseDirection);
        }
        return super.m_38903_(pStack, pStartIndex, pEndIndex, pReverseDirection);
    }

    public SoundTy getSound(boolean inject) {
        if (inject) {
            for (int i = 0; i < 6; ++i) {
                if (this.inventory.$getStackInSlot(i).m_41619_()) continue;
                return SoundTy.BOTH;
            }
            return this.inventory.$getStackInSlot(7).m_41619_() ? SoundTy.NONE : SoundTy.BLAZE;
        }
        ItemStack stack = this.inventory.$getStackInSlot(6);
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            CompoundTag info = nbt.m_128469_("info");
            ListTag listNBT = info.m_128437_("potions", 10);
            if (!listNBT.isEmpty()) {
                for (Tag nb : listNBT) {
                    CompoundTag tag = (CompoundTag)nb;
                    Potion potion = PotionUtils.m_43577_((CompoundTag)tag);
                    if (potion == Potions.f_43598_) continue;
                    return SoundTy.BOTH;
                }
            }
            if (info.m_128451_("blaze") > 0) {
                return SoundTy.BLAZE;
            }
        }
        return SoundTy.NONE;
    }

    public static enum SoundTy {
        NONE,
        BLAZE,
        BOTH;

    }
}

