/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import tfar.davespotioneering.PotionUtils2;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.platform.Services;

public class CGauntletItem
extends SwordItem {
    public static final String ACTIVE = "active";
    public static final String ACTIVE_POTION = "activePotionIndex";
    public static final String BLAZE = "blaze";
    public static final String INFO = "info";
    public static final String COOLDOWNS = "potionCooldownMap";
    public static final String POTIONS = "potions";
    public static final int SLOTS = 6;
    public static final int C_LINES = 3;

    public CGauntletItem(Tier $$0, int $$1, float $$2, Item.Properties $$3) {
        super($$0, $$1, $$2, $$3);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".hold_shift.desc")));
        if (Screen.m_96638_()) {
            tooltip.add((Component)this.getShiftDescription().m_130940_(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".hold_ctrl.desc")));
        if (Screen.m_96637_()) {
            for (int i = 0; i < 3; ++i) {
                tooltip.add((Component)this.getCtrlDescriptions(i).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (!stack.m_41782_()) {
            return;
        }
        ListTag nbts = stack.m_41783_().m_128469_(INFO).m_128437_(POTIONS, 10);
        if (nbts.isEmpty()) {
            return;
        }
        tooltip.add((Component)Component.m_237113_((String)" "));
        for (Tag instance : nbts) {
            PotionUtils2.addPotionTooltip((CompoundTag)instance, tooltip, 0.125f);
            tooltip.add((Component)Component.m_237113_((String)"----------------"));
        }
    }

    public boolean m_142522_(ItemStack stack) {
        CompoundTag info = stack.m_41784_().m_128469_(INFO);
        double blaze = info.m_128451_(BLAZE);
        return blaze > 0.0;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity victim, LivingEntity attacker) {
        if (stack.m_41720_() instanceof CGauntletItem) {
            CompoundTag info = stack.m_41784_().m_128469_(INFO);
            boolean active = stack.m_41783_().m_128471_(ACTIVE);
            if (active) {
                CompoundTag activeEffect = CGauntletItem.getActiveEffectFromNBT(info);
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    int cooldown = CGauntletItem.getCooldownFromPotionByIndex(info.m_128451_(ACTIVE_POTION), player);
                    if (activeEffect != null && cooldown <= 0 && info.m_128451_(BLAZE) > 0) {
                        for (MobEffectInstance effectInstance : PotionUtils.m_43566_((CompoundTag)activeEffect)) {
                            victim.m_7292_(new MobEffectInstance(effectInstance));
                        }
                        int blaze = info.m_128451_(BLAZE);
                        info.m_128405_(BLAZE, --blaze);
                        if (blaze <= 0) {
                            stack.m_41783_().m_128379_(ACTIVE, false);
                        }
                        CGauntletItem.setPotionCooldownByIndex(info.m_128451_(ACTIVE_POTION), Services.PLATFORM.gauntletCooldown(), player);
                    }
                }
            }
        }
        return super.m_7579_(stack, victim, attacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn.m_6144_()) {
            boolean active = stack.m_41784_().m_128471_(ACTIVE);
            int blaze = CGauntletItem.getBlaze(stack);
            if (!world.f_46443_ && (blaze > 0 || active)) {
                stack.m_41784_().m_128379_(ACTIVE, !active);
                world.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), active ? ModSoundEvents.GAUNTLET_TURNING_OFF : ModSoundEvents.GAUNTLET_TURNING_ON, SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return stack.m_41613_() == 1;
    }

    public MutableComponent getShiftDescription() {
        return Component.m_237115_((String)(this.m_5524_() + ".shift.desc"));
    }

    public MutableComponent getCtrlDescription() {
        return Component.m_237115_((String)(this.m_5524_() + ".ctrl.desc"));
    }

    public static int getBlaze(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        int blaze = 0;
        if (tag != null) {
            CompoundTag info = tag.m_128469_(INFO);
            blaze = info.m_128451_(BLAZE);
        }
        return blaze;
    }

    public int m_142158_(ItemStack stack) {
        int blaze = CGauntletItem.getBlaze(stack);
        return 13 * blaze / 32;
    }

    public int m_142159_(ItemStack stack) {
        return ChatFormatting.GOLD.m_126665_();
    }

    public static Potion[] getVisibleEffects(CompoundTag info) {
        ListTag nbts = info.m_128437_(POTIONS, 10);
        if (nbts.isEmpty()) {
            return null;
        }
        int index = info.m_128451_(ACTIVE_POTION);
        CompoundTag tag = nbts.m_128728_(index);
        if (--index < 0) {
            index = 5;
        }
        CompoundTag pre = nbts.m_128728_(index);
        index += 2;
        CompoundTag post = nbts.m_128728_(index %= 6);
        Potion activePotion = PotionUtils.m_43577_((CompoundTag)tag);
        Potion prePotion = PotionUtils.m_43577_((CompoundTag)pre);
        Potion postPotion = PotionUtils.m_43577_((CompoundTag)post);
        return new Potion[]{activePotion, prePotion, postPotion};
    }

    public static void tickCooldownsCommon(ServerPlayer player) {
        int[] cooldowns = Services.PLATFORM.getGauntletCooldowns((Player)player);
        int[] newCooldowns = Arrays.copyOf(cooldowns, cooldowns.length);
        for (int i = 0; i < newCooldowns.length; ++i) {
            int cooldown = newCooldowns[i];
            if (cooldown <= 0) continue;
            newCooldowns[i] = --cooldown;
        }
        if (!Arrays.equals(cooldowns, newCooldowns)) {
            Services.PLATFORM.setGauntletCooldowns((Player)player, newCooldowns);
            Services.PLATFORM.syncGauntletCooldowns((Player)player, newCooldowns);
        }
    }

    public static CompoundTag getActiveEffectFromNBT(CompoundTag info) {
        ListTag nbts = info.m_128437_(POTIONS, 10);
        if (nbts.isEmpty()) {
            return null;
        }
        int index = info.m_128451_(ACTIVE_POTION);
        return nbts.m_128728_(index);
    }

    public static void cycleGauntletForward(Player player) {
        if (player == null) {
            return;
        }
        CompoundTag info = player.m_21205_().m_41784_().m_128469_(INFO);
        ListTag nbts = info.m_128437_(POTIONS, 10);
        if (nbts.isEmpty()) {
            return;
        }
        int index = info.m_128451_(ACTIVE_POTION);
        if (++index > 5) {
            index = 0;
        }
        info.m_128405_(ACTIVE_POTION, index);
    }

    public static void cycleGauntletBackward(Player player) {
        if (player == null) {
            return;
        }
        CompoundTag info = player.m_21205_().m_41784_().m_128469_(INFO);
        ListTag nbts = info.m_128437_(POTIONS, 10);
        if (nbts.isEmpty()) {
            return;
        }
        int index = info.m_128451_(ACTIVE_POTION);
        if (--index < 0) {
            index = 5;
        }
        info.m_128405_(ACTIVE_POTION, index);
    }

    public static void setPotionCooldownByIndex(int index, int cooldown, Player living) {
        int[] cooldowns = Services.PLATFORM.getGauntletCooldowns(living);
        if (cooldowns.length == 0) {
            cooldowns = new int[6];
        }
        cooldowns[index] = cooldown;
        Services.PLATFORM.setGauntletCooldowns(living, cooldowns);
    }

    public static int getCooldownFromPotionByIndex(int indexOfPotion, Player living) {
        int[] cooldowns = Services.PLATFORM.getGauntletCooldowns(living);
        if (cooldowns.length == 0) {
            return 0;
        }
        return cooldowns[indexOfPotion];
    }

    public MutableComponent getCtrlDescriptions(int i) {
        return Component.m_237115_((String)(this.m_5524_() + i + ".ctrl.desc"));
    }
}

