/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.inv;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import tfar.davespotioneering.inv.BrewingHandler;

public class SidedItemHandler
implements IItemHandlerModifiable {
    protected final BrewingHandler inv;
    private final Direction direction;

    public static Map<Direction, LazyOptional<? extends IItemHandler>> create(Supplier<BrewingHandler> inv) {
        EnumMap<Direction, LazyOptional<? extends IItemHandler>> ret = new EnumMap<Direction, LazyOptional<? extends IItemHandler>>(Direction.class);
        for (Direction direction : Direction.values()) {
            ret.put(direction, (LazyOptional<? extends IItemHandler>)LazyOptional.of(() -> new SidedItemHandler((BrewingHandler)inv.get(), direction)));
        }
        return ret;
    }

    public SidedItemHandler(BrewingHandler inv, Direction direction) {
        this.inv = inv;
        this.direction = direction;
    }

    public int mapSlot(int slot) {
        int[] accessible = this.inv.getSlotsForFace(this.direction);
        if (slot < accessible.length) {
            return accessible[slot];
        }
        return -1;
    }

    public int getSlots() {
        return this.inv.getSlotsForFace(this.direction).length;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int i = this.mapSlot(slot);
        return i == -1 ? ItemStack.f_41583_ : this.inv.getStackInSlot(i);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int slot1 = this.mapSlot(slot);
        if (slot1 == -1) {
            return stack;
        }
        return this.inv.insertItem(slot1, stack, simulate);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        int slot1 = this.mapSlot(slot);
        if (slot1 != -1) {
            this.inv.setStackInSlot(slot, stack);
        }
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        int slot1 = this.mapSlot(slot);
        if (slot1 == -1) {
            return ItemStack.f_41583_;
        }
        return this.inv.extractItem(slot1, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.inv.getSlotLimit(this.mapSlot(slot));
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        int slot1 = this.mapSlot(slot);
        return slot1 != -1 && this.inv.isItemValid(slot1, stack);
    }
}

