/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.init;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import tfar.davespotioneering.init.ModBlocks;
import tfar.davespotioneering.item.CGauntletItem;
import tfar.davespotioneering.item.SimpleGauntletItem;
import tfar.davespotioneering.platform.Services;

public class ModItems {
    private static List<Item> MOD_ITEMS;
    public static final Item COMPOUND_BREWING_STAND;
    public static final Item REINFORCED_CAULDRON;
    public static final Item POTIONEER_GAUNTLET;
    public static final Item NETHERITE_GAUNTLET;
    public static final Item RUDIMENTARY_GAUNTLET;
    public static final Item MAGIC_LECTERN;
    public static final Item POTION_INJECTOR;
    public static final Item WHITE_UMBRELLA;
    public static final Item ORANGE_UMBRELLA;
    public static final Item MAGENTA_UMBRELLA;
    public static final Item LIGHT_BLUE_UMBRELLA;
    public static final Item YELLOW_UMBRELLA;
    public static final Item LIME_UMBRELLA;
    public static final Item PINK_UMBRELLA;
    public static final Item GRAY_UMBRELLA;
    public static final Item LIGHT_GRAY_UMBRELLA;
    public static final Item CYAN_UMBRELLA;
    public static final Item PURPLE_UMBRELLA;
    public static final Item BLUE_UMBRELLA;
    public static final Item BROWN_UMBRELLA;
    public static final Item GREEN_UMBRELLA;
    public static final Item RED_UMBRELLA;
    public static final Item BLACK_UMBRELLA;
    public static final Item GILDED_UMBRELLA;
    public static final Item AGED_UMBRELLA;
    public static final TagKey<Item> BLACKLISTED;
    public static final TagKey<Item> WHITELISTED;
    public static final TagKey<Item> CATALYST;

    public static TagKey<Item> create(ResourceLocation name) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)name);
    }

    public static Item.Properties baseUmbrella() {
        return new Item.Properties().m_41503_(300);
    }

    public static List<Item> getAllItems() {
        if (MOD_ITEMS == null) {
            MOD_ITEMS = Arrays.stream(ModItems.class.getFields()).map(field -> {
                try {
                    return field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }).filter(Item.class::isInstance).map(Item.class::cast).collect(Collectors.toList());
        }
        return MOD_ITEMS;
    }

    static {
        COMPOUND_BREWING_STAND = new BlockItem(ModBlocks.COMPOUND_BREWING_STAND, new Item.Properties());
        REINFORCED_CAULDRON = new BlockItem(ModBlocks.REINFORCED_CAULDRON, new Item.Properties());
        POTIONEER_GAUNTLET = new CGauntletItem((Tier)Tiers.NETHERITE, 4, -2.8f, new Item.Properties());
        NETHERITE_GAUNTLET = new SimpleGauntletItem((Tier)Tiers.NETHERITE, 4, -2.8f, new Item.Properties());
        RUDIMENTARY_GAUNTLET = new SimpleGauntletItem((Tier)Tiers.IRON, 3, -2.8f, new Item.Properties());
        MAGIC_LECTERN = new BlockItem(ModBlocks.MAGIC_LECTERN, new Item.Properties());
        POTION_INJECTOR = new BlockItem(ModBlocks.POTION_INJECTOR, new Item.Properties());
        WHITE_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.WHITE, "classic");
        ORANGE_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.ORANGE, "classic");
        MAGENTA_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.MAGENTA, "classic");
        LIGHT_BLUE_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.LIGHT_BLUE, "classic");
        YELLOW_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.YELLOW, "classic");
        LIME_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.LIME, "classic");
        PINK_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.PINK, "classic");
        GRAY_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.GRAY, "classic");
        LIGHT_GRAY_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.LIGHT_GRAY, "classic");
        CYAN_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.CYAN, "classic");
        PURPLE_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.PURPLE, "classic");
        BLUE_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.BLUE, "classic");
        BROWN_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.BROWN, "classic");
        GREEN_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.GREEN, "classic");
        RED_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.RED, "classic");
        BLACK_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), DyeColor.BLACK, "classic");
        GILDED_UMBRELLA = Services.PLATFORM.makeBasicUmbrella(ModItems.baseUmbrella(), "gilded", "gilded");
        AGED_UMBRELLA = Services.PLATFORM.makeAgedUmbrella(ModItems.baseUmbrella(), "aged");
        BLACKLISTED = ModItems.create(new ResourceLocation("davespotioneering", "blacklisted"));
        WHITELISTED = ModItems.create(new ResourceLocation("davespotioneering", "whitelisted"));
        CATALYST = ModItems.create(new ResourceLocation("davespotioneering", "catalyst"));
    }
}

