/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.datagen.assets;

import java.util.Locale;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.loaders.SeparateTransformsModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import tfar.davespotioneering.init.ModItems;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput generator, ExistingFileHelper existingFileHelper) {
        super(generator, "davespotioneering", existingFileHelper);
    }

    protected void registerModels() {
        this.makeOneLayerItem(ModItems.COMPOUND_BREWING_STAND);
        this.makeOneLayerItem(ModItems.REINFORCED_CAULDRON);
        this.makeSimpleBlockItem(ModItems.MAGIC_LECTERN);
        this.makeSimpleBlockItem(ModItems.POTION_INJECTOR);
        this.makeSpriteModel("rudimentary_gauntlet");
        this.makeSpriteModel("netherite_gauntlet");
        String s = "potioneer_gauntlet";
        this.makeSpriteModel(s);
        this.makeSpriteModel("lit_" + s);
        ModelFile.UncheckedModelFile unlitFile = new ModelFile.UncheckedModelFile(this.modLoc("item/perspective/" + s));
        ModelFile.UncheckedModelFile litFile = new ModelFile.UncheckedModelFile(this.modLoc("item/perspective/lit_" + s));
        ModelFile.ExistingModelFile GENERATE = this.getExistingFile(this.mcLoc("item/generated"));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(s)).parent((ModelFile)GENERATE)).override().model((ModelFile)unlitFile).predicate(this.mcLoc("active"), 0.0f).end().override().model((ModelFile)litFile).predicate(this.mcLoc("active"), 1.0f).end();
        for (DyeColor dyeColor : DyeColor.values()) {
            this.classicUmbrella(dyeColor);
        }
        this.umbrella("aged");
        this.umbrella("gilded");
    }

    private void classicUmbrella(DyeColor color) {
        String s = color.name().toLowerCase(Locale.ROOT);
        this.umbrella(s);
    }

    private void umbrella(String s) {
        ItemModelBuilder openRed = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder("open_" + s + "_umbrella")).parent((ModelFile)this.getExistingFile(new ResourceLocation("davespotioneering", "item/open_umbrella")));
        ItemModelBuilder closedRed = (ItemModelBuilder)((ItemModelBuilder)this.getBuilder("closed_" + s + "_umbrella")).parent((ModelFile)this.getExistingFile(new ResourceLocation("davespotioneering", "item/closed_umbrella")));
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(s + "_umbrella")).parent((ModelFile)new ModelFile.UncheckedModelFile(new ResourceLocation("builtin/entity")))).texture("particle", this.mcLoc("block/dark_oak_planks"))).guiLight(BlockModel.GuiLight.FRONT)).override().model((ModelFile)openRed).predicate(this.mcLoc("blocking"), 0.0f).end().override().model((ModelFile)closedRed).predicate(this.mcLoc("blocking"), 1.0f).end();
    }

    private void otherGauntlets() {
        this.perspectiveGauntlet("rudimentary_gauntlet");
        this.perspectiveGauntlet("netherite_gauntlet");
    }

    protected ItemModelBuilder makeSpriteModel(String name) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/sprite/" + name)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", "item/sprite/" + name);
    }

    private void perspectiveGauntlet(String name) {
        ItemModelBuilder r3dFile = (ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)this.getExistingFile(this.modLoc("item/3d/" + name)));
        ItemModelBuilder rSpriteFile = this.makeSpriteModel(name);
        ((SeparateTransformsModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(name)).guiLight(BlockModel.GuiLight.FRONT)).customLoader(SeparateTransformsModelBuilder::begin)).base((ModelBuilder)rSpriteFile).perspective(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, (ModelBuilder)r3dFile).perspective(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, (ModelBuilder)r3dFile).perspective(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, (ModelBuilder)r3dFile).perspective(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, (ModelBuilder)r3dFile).end();
    }

    private void alchemicalGauntlet() {
        String s = "potioneer_gauntlet";
        ModelFile.ExistingModelFile unlitFile = this.getExistingFile(this.modLoc("item/perspective/" + s));
        ModelFile.ExistingModelFile litFile = this.getExistingFile(this.modLoc("item/perspective/lit_" + s));
        ModelFile.ExistingModelFile GENERATE = this.getExistingFile(this.mcLoc("item/generated"));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(s)).parent((ModelFile)GENERATE)).override().model((ModelFile)unlitFile).predicate(this.mcLoc("active"), 0.0f).end().override().model((ModelFile)litFile).predicate(this.mcLoc("active"), 1.0f).end();
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/sprite/" + s)).parent((ModelFile)GENERATE)).texture("layer0", this.modLoc("item/sprite/" + s));
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder("item/sprite/lit_" + s)).parent((ModelFile)GENERATE)).texture("layer0", this.modLoc("item/sprite/lit_" + s));
    }

    protected void makeSimpleBlockItem(Item item, ResourceLocation loc) {
        String s = BuiltInRegistries.f_257033_.m_7981_((Object)item).toString();
        ((ItemModelBuilder)this.getBuilder(s)).parent((ModelFile)this.getExistingFile(loc));
    }

    protected void makeSimpleBlockItem(Item item) {
        this.makeSimpleBlockItem(item, new ResourceLocation("davespotioneering", "block/" + BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_()));
    }

    protected void makeOneLayerItem(Item item, ResourceLocation texture) {
        String path = BuiltInRegistries.f_257033_.m_7981_((Object)item).m_135815_();
        if (this.existingFileHelper.exists(new ResourceLocation(texture.m_135827_(), "item/" + texture.m_135815_()), PackType.CLIENT_RESOURCES, ".png", "textures")) {
            ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)this.getExistingFile(this.mcLoc("item/generated")))).texture("layer0", new ResourceLocation(texture.m_135827_(), "item/" + texture.m_135815_()));
        } else {
            System.out.println("no texture for " + item + " found, skipping");
        }
    }

    protected void makeOneLayerItem(Item item) {
        ResourceLocation texture = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        this.makeOneLayerItem(item, texture);
    }
}

