/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.client.model.gecko;

import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import software.bernie.geckolib.model.GeoModel;

public class GeoItemModel<T extends Item>
extends GeoModel<T> {
    protected final ResourceLocation animation;
    protected final ResourceLocation modelLoc;
    protected final ResourceLocation textureLoc;
    private static final ResourceLocation DUMMY = new ResourceLocation("davespotioneering", "animations/animation.dummy.json");

    public static <T extends Item> GeoItemModel<T> makeClosedUmbrella(DyeColor color) {
        return new GeoItemModel<T>(new ResourceLocation("closed_umbrella"), new ResourceLocation("davespotioneering", "closed_" + color.name().toLowerCase(Locale.ROOT) + "_umbrella"), DUMMY);
    }

    public static <T extends Item> GeoItemModel<T> makeOpenUmbrella(DyeColor color) {
        return new GeoItemModel<T>(new ResourceLocation("open_umbrella"), new ResourceLocation("davespotioneering", "open_" + color.name().toLowerCase(Locale.ROOT) + "_umbrella"), DUMMY);
    }

    public static <T extends Item> GeoItemModel<T> makeClosedUmbrella(String color) {
        return new GeoItemModel<T>(new ResourceLocation("closed_umbrella"), new ResourceLocation("davespotioneering", "closed_" + color + "_umbrella"), DUMMY);
    }

    public static <T extends Item> GeoItemModel<T> makeOpenUmbrella(String color) {
        return new GeoItemModel<T>(new ResourceLocation("open_umbrella"), new ResourceLocation("davespotioneering", "open_" + color + "_umbrella"), DUMMY);
    }

    public static <T extends Item> GeoItemModel<T> makeOpenAgedUmbrella() {
        return new GeoItemModel<T>(new ResourceLocation("open_aged_umbrella"), new ResourceLocation("davespotioneering", "open_aged_umbrella"), DUMMY);
    }

    public GeoItemModel(ResourceLocation item) {
        this(item, DUMMY);
    }

    public GeoItemModel(ResourceLocation item, ResourceLocation animation) {
        this(item, item, animation);
    }

    public GeoItemModel(ResourceLocation model, ResourceLocation texture, ResourceLocation animation) {
        this.animation = animation;
        this.modelLoc = new ResourceLocation("davespotioneering", "geo/item/" + model.m_135815_() + ".geo.json");
        this.textureLoc = new ResourceLocation("davespotioneering", "textures/item/" + texture.m_135815_() + ".png");
    }

    public ResourceLocation getModelResource(T object) {
        return this.modelLoc;
    }

    public ResourceLocation getTextureResource(T object) {
        return this.textureLoc;
    }

    public ResourceLocation getAnimationResource(T animatable) {
        return this.animation;
    }
}

