/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import tfar.davespotioneering.client.HudPreset;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.item.CGauntletItem;
import tfar.davespotioneering.mixin.GuiAccess;
import tfar.davespotioneering.platform.Services;

public class GauntletHUDCommon {
    public static final ResourceLocation GAUNTLET_ICON_LOC = new ResourceLocation("davespotioneering", "textures/gauntlet_icons/");
    public static final Minecraft mc = Minecraft.m_91087_();
    static final int TEX_HEIGHT = 41;
    static final int TEX_WIDTH = 121;
    static final ResourceLocation hud = GauntletHUDCommon.getGauntletIconLoc("hud");
    static final int maxCooldown = 40;
    public static int[] cooldowns = new int[6];
    static int cooldown = 40;
    static boolean forwardCycle = false;
    static Potion activePotion = null;
    static Potion prePotion = null;
    static Potion postPotion = null;
    static boolean backwardCycle = false;

    public static ResourceLocation getGauntletIconLoc(String fileName) {
        return new ResourceLocation(GAUNTLET_ICON_LOC.m_135827_(), GAUNTLET_ICON_LOC.m_135815_() + fileName + ".png");
    }

    public static void init(Potion activePotion, Potion prePotion, Potion postPotion) {
        GauntletHUDCommon.activePotion = activePotion;
        GauntletHUDCommon.prePotion = prePotion;
        GauntletHUDCommon.postPotion = postPotion;
    }

    static int getScaledCooldown(float pixels, float cooldown) {
        float totalCooldown = Services.PLATFORM.gauntletCooldown();
        if (totalCooldown != 0.0f) {
            float result = cooldown * pixels / totalCooldown;
            return Math.round(result);
        }
        return 0;
    }

    static void renderPotion(Potion potion, GuiGraphics matrixStack, int x, int y, int cooldown) {
        if (potion == null) {
            return;
        }
        if (potion.m_43488_().isEmpty()) {
            return;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (potion.m_43488_().size() > 1) {
            String name = BuiltInRegistries.f_256980_.m_7981_((Object)potion).toString();
            ResourceLocation resourceLocation = name.contains("turtle_master") ? GauntletHUDCommon.getGauntletIconLoc("turtle_master") : (mc.m_91098_().m_213713_(GauntletHUDCommon.getGauntletIconLoc(name)).isPresent() ? GauntletHUDCommon.getGauntletIconLoc(name) : GauntletHUDCommon.getGauntletIconLoc("unknown"));
            matrixStack.m_280398_(resourceLocation, x, y, 0, 0.0f, 0.0f, 18, 18, 18, 18);
        } else {
            MobEffect effect = ((MobEffectInstance)potion.m_43488_().get(0)).m_19544_();
            TextureAtlasSprite sprite = mc.m_91306_().m_118732_(effect);
            matrixStack.m_280159_(x, y, 0, 18, 18, sprite);
        }
        if (cooldown > 0) {
            if (Services.PLATFORM.isDevelopmentEnvironment()) {
                matrixStack.m_280488_(GauntletHUDCommon.mc.f_91062_, String.valueOf(cooldown), x, y - 20, 0xFF0000);
            }
            int w = 18;
            int scale = GauntletHUDCommon.getScaledCooldown(w, cooldown);
            matrixStack.m_280509_(x, y + w - scale, x + 18, y + w, Integer.MAX_VALUE);
        }
    }

    public static void render(Gui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        int hudX = Services.PLATFORM.gauntletHudX();
        int hudY = Services.PLATFORM.gauntletHudY();
        LocalPlayer player = GauntletHUDCommon.mc.f_91074_;
        if (player == null) {
            return;
        }
        ItemStack g = player.m_21205_();
        if (g.m_41720_() instanceof CGauntletItem) {
            int yOffset;
            CompoundTag info = player.m_21205_().m_41784_().m_128469_("info");
            Potion[] potions = CGauntletItem.getVisibleEffects(info);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (Services.PLATFORM.preset() == HudPreset.ABOVE_HOTBAR) {
                hudX = (screenWidth - 121) / 2;
                hudY = screenHeight - Math.min(Services.PLATFORM.leftHeight(gui), Services.PLATFORM.rightHeight(gui)) - 41;
                if (((GuiAccess)gui).getToolHighlightTimer() > 0) {
                    hudY -= 10;
                }
            }
            int xFixed = hudX;
            int yFixed = hudY;
            if (forwardCycle) {
                yOffset = 2;
                if (--cooldown <= 0) {
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)ModSoundEvents.GAUNTLET_SCROLL, (float)1.0f));
                    forwardCycle = false;
                    cooldown = 40;
                }
            } else if (backwardCycle) {
                yOffset = 1;
                if (--cooldown <= 0) {
                    mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)ModSoundEvents.GAUNTLET_SCROLL, (float)1.0f));
                    backwardCycle = false;
                    cooldown = 40;
                }
            } else {
                yOffset = 0;
            }
            guiGraphics.m_280398_(hud, xFixed, yFixed, 0, 0.0f, (float)(1 + 43 * yOffset), 121, 41, 128, 128);
            int active = info.m_128451_("activePotionIndex");
            int prev = active > 0 ? active - 1 : 5;
            int next = active < 5 ? active + 1 : 0;
            GauntletHUDCommon.renderPotion(prePotion, guiGraphics, xFixed + 3, yFixed + 21, cooldowns[prev]);
            GauntletHUDCommon.renderPotion(activePotion, guiGraphics, xFixed + 51, yFixed + 5, cooldowns[active]);
            GauntletHUDCommon.renderPotion(postPotion, guiGraphics, xFixed + 99, yFixed + 21, cooldowns[next]);
            if (potions == null) {
                GauntletHUDCommon.init(null, null, null);
                return;
            }
            GauntletHUDCommon.init(potions[0], potions[1], potions[2]);
        }
    }

    public static void forwardCycle() {
        forwardCycle = true;
    }

    public static void backwardCycle() {
        backwardCycle = true;
    }
}

