/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import tfar.davespotioneering.ModConfig;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.client.DavesPotioneeringClient;
import tfar.davespotioneering.client.GauntletHUDCommon;
import tfar.davespotioneering.client.particle.FastDripParticle;
import tfar.davespotioneering.client.particle.TintedSplashParticle;
import tfar.davespotioneering.client.renderer.PotionInjectorRenderer;
import tfar.davespotioneering.client.screens.AdvancedBrewingStandScreen;
import tfar.davespotioneering.client.screens.PotionInjectorScreen;
import tfar.davespotioneering.init.ModBlockEntityTypes;
import tfar.davespotioneering.init.ModBlocks;
import tfar.davespotioneering.init.ModMenuTypes;
import tfar.davespotioneering.init.ModParticleTypes;

public class DavesPotioneeringClientForge {
    public static final IGuiOverlay OVERLAY = GauntletHUDCommon::render;

    public static void particle(RegisterParticleProvidersEvent e) {
        ParticleEngine manager = Minecraft.m_91087_().f_91061_;
        manager.m_107378_((ParticleType)ModParticleTypes.FAST_DRIPPING_WATER, FastDripParticle.DrippingWaterFactory::new);
        manager.m_107378_((ParticleType)ModParticleTypes.FAST_FALLING_WATER, FastDripParticle.FallingWaterFactory::new);
        manager.m_107378_((ParticleType)ModParticleTypes.TINTED_SPLASH, TintedSplashParticle.Factory::new);
    }

    public static void registerLoader(ModelEvent.RegisterGeometryLoaders event) {
    }

    public static void onMouseInput(InputEvent.MouseButton e) {
        DavesPotioneeringClient.onMouseInput(e.getButton());
    }

    public static void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        boolean cancel = DavesPotioneeringClient.onMouseScroll(event.getScrollDelta());
        if (cancel) {
            event.setCanceled(true);
        }
    }

    public static void tooltips(ItemTooltipEvent e) {
        DavesPotioneeringClient.tooltips(e.getItemStack(), e.getToolTip());
    }

    public static void doClientStuff(FMLClientSetupEvent event) {
        DavesPotioneeringClient.clientSetup();
        MinecraftForge.EVENT_BUS.addListener(DavesPotioneeringClientForge::tooltips);
        MinecraftForge.EVENT_BUS.addListener(DavesPotioneeringClientForge::onMouseInput);
        MinecraftForge.EVENT_BUS.addListener(DavesPotioneeringClientForge::onMouseScroll);
        MinecraftForge.EVENT_BUS.addListener(DavesPotioneeringClientForge::playerTick);
        MinecraftForge.EVENT_BUS.addListener(DavesPotioneeringClientForge::stackAdj1);
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.COMPOUND_BREWING_STAND, (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.POTION_INJECTOR, (RenderType)RenderType.m_110466_());
        if (!DavesPotioneeringClient.IS_EMBEDDIUM_OR_SODIUM_HERE) {
            ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.REINFORCED_WATER_CAULDRON, (RenderType)RenderType.m_110466_());
        } else {
            ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.REINFORCED_WATER_CAULDRON, (RenderType)RenderType.m_110457_());
        }
        MenuScreens.m_96206_(ModMenuTypes.ADVANCED_BREWING_STAND, AdvancedBrewingStandScreen::new);
        MenuScreens.m_96206_(ModMenuTypes.ALCHEMICAL_GAUNTLET, PotionInjectorScreen::new);
        BlockEntityRenderers.m_173590_(ModBlockEntityTypes.POTION_INJECTOR, PotionInjectorRenderer::new);
        Minecraft.m_91087_().m_91298_().m_92589_(DavesPotioneeringClient.CAULDRON, new Block[]{ModBlocks.REINFORCED_WATER_CAULDRON});
    }

    public static void overlay(RegisterGuiOverlaysEvent e) {
        e.registerBelow(VanillaGuiOverlay.CHAT_PANEL.id(), "davespotioneering", OVERLAY);
    }

    private static void stackAdj1(ClientPlayerNetworkEvent.LoggingIn e) {
        Util.setStackSize(Items.f_42589_, (Integer)ModConfig.Server.potion_stack_size.get());
        Util.setStackSize(Items.f_42736_, (Integer)ModConfig.Server.splash_potion_stack_size.get());
        Util.setStackSize(Items.f_42739_, (Integer)ModConfig.Server.lingering_potion_stack_size.get());
    }

    public static void playerTick(TickEvent.PlayerTickEvent e) {
        Player player = e.player;
        if (player != null && e.phase == TickEvent.Phase.END && e.side == LogicalSide.CLIENT) {
            DavesPotioneeringClient.clientPlayerTick(player);
        }
    }
}

