/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.blockentity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import tfar.davespotioneering.PotionUtils2;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.block.CLayeredReinforcedCauldronBlock;
import tfar.davespotioneering.init.ModPotions;
import tfar.davespotioneering.platform.Services;

public abstract class CReinforcedCauldronBlockEntity
extends BlockEntity {
    @Nonnull
    protected Potion potion = Potions.f_43598_;
    protected List<MobEffectInstance> customEffects = new ArrayList<MobEffectInstance>();
    @Nullable
    protected Integer customPotionColor;

    public CReinforcedCauldronBlockEntity(BlockEntityType<?> $$0, BlockPos $$1, BlockState $$2) {
        super($$0, $$1, $$2);
    }

    @Nonnull
    public Potion getPotion() {
        return this.potion;
    }

    public void setPotion(@Nonnull Potion potion) {
        this.potion = potion;
        this.m_6596_();
    }

    public List<MobEffectInstance> getCustomEffects() {
        return this.customEffects;
    }

    public void setCustomEffects(List<MobEffectInstance> customEffects) {
        this.customEffects = customEffects;
        this.m_6596_();
    }

    @Nullable
    public Integer getCustomPotionColor() {
        return this.customPotionColor;
    }

    public void setCustomPotionColor(@Nullable Integer customPotionColor) {
        this.customPotionColor = customPotionColor;
    }

    public int getColor() {
        if (this.potion == Potions.f_43599_) {
            return BiomeColors.m_108811_((BlockAndTintGetter)this.f_58857_, (BlockPos)this.f_58858_);
        }
        if (this.customPotionColor != null) {
            return this.customPotionColor;
        }
        return PotionUtils.m_43559_((Potion)this.potion);
    }

    public void m_142466_(CompoundTag nbt) {
        this.potion = PotionUtils.m_43577_((CompoundTag)nbt);
        this.customEffects = PotionUtils.m_43573_((CompoundTag)nbt);
        if (nbt.m_128441_("CustomPotionColor")) {
            this.customPotionColor = nbt.m_128451_("CustomPotionColor");
        }
        super.m_142466_(nbt);
    }

    public void m_183515_(CompoundTag compound) {
        PotionUtils2.saveAllEffects(compound, this.potion, this.customEffects, this.customPotionColor);
        super.m_183515_(compound);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onEntityCollision(Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemStack stack = ((ItemEntity)entity).m_32055_();
            boolean dragon = (Boolean)this.m_58900_().m_61143_((Property)CLayeredReinforcedCauldronBlock.DRAGONS_BREATH);
            Util.CoatingType coatingType = Util.CoatingType.getCoatingType(stack);
            if (coatingType == null) {
                return;
            }
            BlockState blockState = this.m_58900_();
            int cLevel = (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_);
            if (this.potion == ModPotions.MILK && PotionUtils.m_43579_((ItemStack)stack) != Potions.f_43598_ && !Util.isPotion(stack)) {
                CLayeredReinforcedCauldronBlock.removeCoating(blockState, this.f_58857_, this.f_58858_, null, stack);
            } else if (coatingType == Util.CoatingType.FOOD) {
                if (Services.PLATFORM.spikeFood() && stack.m_41613_() >= 8) {
                    CLayeredReinforcedCauldronBlock.handleFoodSpiking(blockState, this.f_58857_, this.f_58858_, null, null, stack);
                }
            } else if (stack.m_41720_() == Items.f_42412_ && cLevel > 0) {
                if (dragon) {
                    CLayeredReinforcedCauldronBlock.handleArrowCoating(blockState, this.f_58857_, this.f_58858_, null, stack);
                }
            } else if (cLevel == 3 && dragon) {
                entity.m_9236_().m_5594_(null, this.f_58858_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.8f, 1.0f);
                CLayeredReinforcedCauldronBlock.setWaterLevel(this.f_58857_, this.f_58858_, blockState, 2);
                this.scheduleTick();
            }
        }
    }

    private void scheduleTick() {
        this.f_58857_.m_186460_(this.m_58899_(), this.m_58900_().m_60734_(), CLayeredReinforcedCauldronBlock.brew_speed);
    }
}

