/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.blockentity;

import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BrewingStandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.duck.BrewingStandDuck;
import tfar.davespotioneering.inventory.BasicInventoryBridge;
import tfar.davespotioneering.menu.CAdvancedBrewingStandMenu;

public abstract class CAdvancedBrewingStandBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable,
BrewingStandDuck {
    public static final int FUEL_USES = 40;
    public static final int DATA_BREW_TIME = 0;
    public static final int DATA_FUEL_USES = 1;
    public static final int[] POTIONS = new int[]{0, 1, 2};
    public static final int[] INGREDIENTS = new int[]{3, 4, 5, 6, 7};
    public static final int FUEL = 8;
    public static final int TIME = 200;
    protected int xp;
    @Nullable
    private Component name;
    public static final int SLOTS = POTIONS.length + INGREDIENTS.length + 1;
    protected BasicInventoryBridge handler;
    protected int brewTime;
    protected boolean[] filledSlots;
    protected Item ingredientID;
    protected int fuel;
    protected final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return CAdvancedBrewingStandBlockEntity.this.brewTime;
                }
                case 1: {
                    return CAdvancedBrewingStandBlockEntity.this.fuel;
                }
            }
            return 0;
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CAdvancedBrewingStandBlockEntity.this.brewTime = value;
                    break;
                }
                case 1: {
                    CAdvancedBrewingStandBlockEntity.this.fuel = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public CAdvancedBrewingStandBlockEntity(BlockEntityType<?> $$0, BlockPos $$1, BlockState $$2) {
        super($$0, $$1, $$2);
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"container.davespotioneering.compound_brewing");
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component m_7755_() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    public BasicInventoryBridge getBrewingHandler() {
        return this.handler;
    }

    public static void serverTick(Level p_155286_, BlockPos p_155287_, BlockState p_155288_, CAdvancedBrewingStandBlockEntity brewingStand) {
        ItemStack fuelStack = brewingStand.handler.$getStackInSlot(8);
        if (brewingStand.fuel <= 0 && fuelStack.m_41720_() == Items.f_42593_) {
            brewingStand.fuel = 40;
            fuelStack.m_41774_(1);
            brewingStand.m_6596_();
        }
        boolean canBrew = brewingStand.canBrew();
        boolean brewing = brewingStand.brewTime > 0;
        ItemStack ing = (ItemStack)brewingStand.getPriorityIngredient().getRight();
        if (brewing) {
            boolean done;
            --brewingStand.brewTime;
            boolean bl = done = brewingStand.brewTime == 0;
            if (done && canBrew) {
                brewingStand.brewPotions();
                brewingStand.m_6596_();
            } else if (!canBrew) {
                brewingStand.brewTime = 0;
                brewingStand.m_6596_();
            } else if (brewingStand.ingredientID != ing.m_41720_()) {
                brewingStand.brewTime = 0;
                brewingStand.m_6596_();
            }
        } else if (canBrew && brewingStand.fuel > 0) {
            --brewingStand.fuel;
            brewingStand.brewTime = 200;
            brewingStand.ingredientID = ing.m_41720_();
            brewingStand.m_6596_();
        }
        if (!brewingStand.f_58857_.f_46443_) {
            brewingStand.setBottleBlockStates();
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new CAdvancedBrewingStandMenu(id, playerInventory, this.handler, this.data, this);
    }

    @Override
    public void addXp(double xp) {
        this.xp = (int)((double)this.xp + xp);
    }

    @Override
    public void dump(Player player) {
        if (this.xp > 0) {
            Util.splitAndSpawnExperience(this.f_58857_, player.m_20182_(), this.xp);
            this.xp = 0;
            this.m_6596_();
        }
    }

    public boolean[] createFilledSlotsArray() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (this.handler.$getStackInSlot(i).m_41619_()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    protected void setBottleBlockStates() {
        boolean[] aboolean = this.createFilledSlotsArray();
        if (!Arrays.equals(aboolean, this.filledSlots)) {
            this.filledSlots = aboolean;
            BlockState blockstate = this.f_58857_.m_8055_(this.m_58899_());
            if (!(blockstate.m_60734_() instanceof BrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < BrewingStandBlock.f_50905_.length; ++i) {
                blockstate = (BlockState)blockstate.m_61124_((Property)BrewingStandBlock.f_50905_[i], (Comparable)Boolean.valueOf(aboolean[i]));
            }
            this.f_58857_.m_7731_(this.f_58858_, blockstate, 2);
        }
    }

    protected abstract boolean canBrew();

    protected void brewPotions() {
        this.f_58857_.m_46796_(1035, this.f_58858_, 0);
    }

    public Pair<Integer, ItemStack> getPriorityIngredient() {
        for (int i = 7; i > 2; --i) {
            ItemStack ing = this.handler.$getStackInSlot(i);
            if (ing.m_41619_() || !this.isThereARecipe(ing)) continue;
            return Pair.of((Object)i, (Object)ing);
        }
        return Pair.of((Object)-1, (Object)ItemStack.f_41583_);
    }

    public boolean isThereARecipe(ItemStack ingredient) {
        for (int i : POTIONS) {
            ItemStack potion = this.handler.$getStackInSlot(i);
            if (!PotionBrewing.m_43508_((ItemStack)potion, (ItemStack)ingredient)) continue;
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.brewTime = nbt.m_128448_("BrewTime");
        this.fuel = nbt.m_128451_("Fuel");
        this.xp = nbt.m_128451_("xp");
        ContainerHelper.m_18980_((CompoundTag)nbt, this.handler.$getStacks());
        if (nbt.m_128425_("CustomName", 8)) {
            this.name = Component.Serializer.m_130701_((String)nbt.m_128461_("CustomName"));
        }
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128376_("BrewTime", (short)this.brewTime);
        compound.m_128405_("Fuel", this.fuel);
        compound.m_128405_("xp", this.xp);
        ContainerHelper.m_18973_((CompoundTag)compound, this.handler.$getStacks());
        if (this.name != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.name));
        }
    }
}

