/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.blockentity;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import tfar.davespotioneering.DavesPotioneering;
import tfar.davespotioneering.ForgeUtil;
import tfar.davespotioneering.blockentity.CAdvancedBrewingStandBlockEntity;
import tfar.davespotioneering.init.ModBlockEntityTypes;
import tfar.davespotioneering.inv.BrewingHandler;
import tfar.davespotioneering.inv.SidedItemHandler;

public class AdvancedBrewingStandBlockEntity
extends CAdvancedBrewingStandBlockEntity {
    Map<Direction, LazyOptional<? extends IItemHandler>> handlers = SidedItemHandler.create(() -> (BrewingHandler)this.handler);

    public AdvancedBrewingStandBlockEntity(BlockPos p_155283_, BlockState p_155284_) {
        this(ModBlockEntityTypes.COMPOUND_BREWING_STAND, p_155283_, p_155284_);
    }

    protected AdvancedBrewingStandBlockEntity(BlockEntityType<?> typeIn, BlockPos p_155283_, BlockState p_155284_) {
        super(typeIn, p_155283_, p_155284_);
        this.handler = new BrewingHandler(SLOTS);
    }

    @Override
    public boolean isThereARecipe(ItemStack ingredient) {
        if (!ingredient.m_41619_()) {
            return BrewingRecipeRegistry.canBrew(this.handler.$getStacks(), (ItemStack)ingredient, (int[])POTIONS) || ingredient.m_41720_() == Items.f_42455_;
        }
        if (ingredient.m_41619_()) {
            return false;
        }
        if (!PotionBrewing.m_43506_((ItemStack)ingredient)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = this.handler.$getStackInSlot(i);
            if (itemstack1.m_41619_() || !PotionBrewing.m_43508_((ItemStack)itemstack1, (ItemStack)ingredient)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canBrew() {
        ItemStack itemstack = (ItemStack)this.getPriorityIngredient().getRight();
        if (!itemstack.m_41619_()) {
            return BrewingRecipeRegistry.canBrew(this.handler.$getStacks(), (ItemStack)itemstack, (int[])POTIONS);
        }
        if (itemstack.m_41619_()) {
            return false;
        }
        if (!PotionBrewing.m_43506_((ItemStack)itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = this.handler.$getStackInSlot(i);
            if (itemstack1.m_41619_() || !PotionBrewing.m_43508_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void brewPotions() {
        if (ForgeEventFactory.onPotionAttemptBrew(this.handler.$getStacks())) {
            return;
        }
        Pair<Integer, ItemStack> pair = this.getPriorityIngredient();
        ItemStack ingredient = (ItemStack)pair.getRight();
        ForgeUtil.brewPotions(this.handler.$getStacks(), ingredient, POTIONS);
        ForgeEventFactory.onPotionBrewed(this.handler.$getStacks());
        DavesPotioneering.potionBrew(this, ingredient);
        BlockPos blockpos = this.m_58899_();
        if (ingredient.hasCraftingRemainingItem()) {
            ItemStack ingredientContainerItem = ingredient.getCraftingRemainingItem();
            ingredient.m_41774_(1);
            if (ingredient.m_41619_()) {
                ingredient = ingredientContainerItem;
            } else if (!this.f_58857_.f_46443_) {
                Containers.m_18992_((Level)this.f_58857_, (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), (ItemStack)ingredientContainerItem);
            }
        } else {
            ingredient.m_41774_(1);
        }
        this.handler.$setStackInSlot((Integer)pair.getLeft(), ingredient);
        super.brewPotions();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag items = nbt.m_128469_("Items");
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handlers.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (Map.Entry<Direction, LazyOptional<? extends IItemHandler>> entry : this.handlers.entrySet()) {
            entry.getValue().invalidate();
        }
    }
}

