/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering.block;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import tfar.davespotioneering.PotionUtils2;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.block.ModCauldronInteractions;
import tfar.davespotioneering.blockentity.CReinforcedCauldronBlockEntity;
import tfar.davespotioneering.init.ModBlocks;
import tfar.davespotioneering.init.ModPotions;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.platform.Services;

public class CLayeredReinforcedCauldronBlock
extends LayeredCauldronBlock
implements EntityBlock {
    public static final BooleanProperty DRAGONS_BREATH = BooleanProperty.m_61465_((String)"dragons_breath");
    public static int brew_speed = 12;
    public static final String TAG_USES = "uses";

    public CLayeredReinforcedCauldronBlock(BlockBehaviour.Properties properties) {
        this(properties, LayeredCauldronBlock.f_153515_, ModCauldronInteractions.WATER);
    }

    public CLayeredReinforcedCauldronBlock(BlockBehaviour.Properties p_153522_, Predicate<Biome.Precipitation> p_153523_, Map<Item, CauldronInteraction> p_153524_) {
        super(p_153522_, p_153523_, p_153524_);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DRAGONS_BREATH, (Comparable)Boolean.valueOf(false)));
    }

    public static void lowerFillLevel0(BlockState p_153560_, Level p_153561_, BlockPos pos) {
        int i = (Integer)p_153560_.m_61143_((Property)f_153514_) - 1;
        p_153561_.m_46597_(pos, i == 0 ? ModBlocks.REINFORCED_CAULDRON.m_49966_() : (BlockState)p_153560_.m_61124_((Property)f_153514_, (Comparable)Integer.valueOf(i)));
    }

    public static void boom(Level level, BlockPos pos) {
        level.m_46597_(pos, ModBlocks.REINFORCED_CAULDRON.m_49966_());
        level.m_255391_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 1.0f, false, Level.ExplosionInteraction.NONE);
    }

    public static void handleWeaponCoating(BlockState state, Level level, BlockPos pos, @javax.annotation.Nullable Player player, ItemStack stack) {
        if (((Boolean)state.m_61143_((Property)DRAGONS_BREATH)).booleanValue()) {
            CReinforcedCauldronBlockEntity reinforcedCauldronBlockEntity = (CReinforcedCauldronBlockEntity)level.m_7702_(pos);
            Potion potion = reinforcedCauldronBlockEntity.getPotion();
            List<MobEffectInstance> customEffects = reinforcedCauldronBlockEntity.getCustomEffects();
            if (!level.f_46443_) {
                if (player != null && !player.m_150110_().f_35937_) {
                    player.m_36220_(Stats.f_12944_);
                }
                CLayeredReinforcedCauldronBlock.addCoating(stack, potion, customEffects, reinforcedCauldronBlockEntity.getCustomPotionColor());
                level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_46597_(pos, ModBlocks.REINFORCED_CAULDRON.m_49966_());
            }
        }
    }

    public static void handleArrowCoating(BlockState state, Level level, BlockPos pos, @javax.annotation.Nullable Player player, ItemStack stack) {
        int wLevel = (Integer)state.m_61143_((Property)f_153514_);
        if (((Boolean)state.m_61143_((Property)DRAGONS_BREATH)).booleanValue()) {
            if (stack.m_41613_() < 8) {
                return;
            }
            CReinforcedCauldronBlockEntity reinforcedCauldronBlockEntity = (CReinforcedCauldronBlockEntity)level.m_7702_(pos);
            Potion potion = reinforcedCauldronBlockEntity.getPotion();
            List<MobEffectInstance> customEffects = reinforcedCauldronBlockEntity.getCustomEffects();
            if (!level.f_46443_) {
                if (player != null && !player.m_150110_().f_35937_) {
                    player.m_36220_(Stats.f_12944_);
                }
                ItemStack tippedArrows = new ItemStack((ItemLike)Items.f_42738_, 8);
                CLayeredReinforcedCauldronBlock.addCoating(tippedArrows, potion, customEffects, reinforcedCauldronBlockEntity.getCustomPotionColor());
                stack.m_41774_(8);
                level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), tippedArrows));
                if (wLevel <= 1) {
                    level.m_46597_(pos, ModBlocks.REINFORCED_CAULDRON.m_49966_());
                } else {
                    level.m_46597_(pos, (BlockState)ModBlocks.REINFORCED_WATER_CAULDRON.m_49966_().m_61124_((Property)f_153514_, (Comparable)Integer.valueOf(wLevel - 1)));
                }
            }
        }
    }

    public static void handleFoodSpiking(BlockState state, Level level, BlockPos pos, @javax.annotation.Nullable Player player, InteractionHand p_175715_, ItemStack stack) {
        int wLevel = (Integer)state.m_61143_((Property)f_153514_);
        if (stack.m_41613_() < 8) {
            return;
        }
        CReinforcedCauldronBlockEntity reinforcedCauldronBlockEntity = (CReinforcedCauldronBlockEntity)level.m_7702_(pos);
        Potion potion = reinforcedCauldronBlockEntity.getPotion();
        List<MobEffectInstance> customEffects = reinforcedCauldronBlockEntity.getCustomEffects();
        if (!level.f_46443_) {
            if (player != null && !player.m_150110_().f_35937_) {
                player.m_36220_(Stats.f_12944_);
            }
            ItemStack tippedArrows = stack.m_41620_(8);
            CLayeredReinforcedCauldronBlock.addCoating(tippedArrows, potion, customEffects, reinforcedCauldronBlockEntity.getCustomPotionColor());
            level.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)pos.m_123343_(), tippedArrows));
            if (wLevel <= 1) {
                level.m_46597_(pos, ModBlocks.REINFORCED_CAULDRON.m_49966_());
            } else {
                level.m_46597_(pos, (BlockState)ModBlocks.REINFORCED_WATER_CAULDRON.m_49966_().m_61124_((Property)f_153514_, (Comparable)Integer.valueOf(wLevel - 1)));
            }
        }
    }

    public static void removeCoating(BlockState state, Level world, BlockPos pos, @javax.annotation.Nullable Player player, ItemStack stack) {
        CReinforcedCauldronBlockEntity reinforcedCauldronBlockEntity = (CReinforcedCauldronBlockEntity)world.m_7702_(pos);
        Potion potion = reinforcedCauldronBlockEntity.getPotion();
        if (potion == ModPotions.MILK && !world.f_46443_) {
            if (player != null && !player.m_150110_().f_35937_) {
                player.m_36220_(Stats.f_12944_);
            }
            CLayeredReinforcedCauldronBlock.removeCoating(stack);
            world.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static void setWaterLevel(Level world, BlockPos pos, BlockState state, int level) {
        CReinforcedCauldronBlockEntity reinforcedCauldronBlockEntity = (CReinforcedCauldronBlockEntity)world.m_7702_(pos);
        if (level == 0) {
            reinforcedCauldronBlockEntity.setPotion(Potions.f_43598_);
        } else if (reinforcedCauldronBlockEntity.getPotion() == Potions.f_43598_ && reinforcedCauldronBlockEntity.getCustomEffects().isEmpty()) {
            reinforcedCauldronBlockEntity.setPotion(Potions.f_43599_);
        }
    }

    public static void removeCoating(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        nbt.m_128473_(TAG_USES);
        nbt.m_128473_("Potion");
        nbt.m_128473_("CustomPotionEffects");
        nbt.m_128473_("CustomPotionColor");
    }

    public static void addCoating(ItemStack stack, Potion potion, List<MobEffectInstance> customEffects, @javax.annotation.Nullable Integer color) {
        PotionUtils.m_43549_((ItemStack)stack, (Potion)potion);
        PotionUtils.m_43552_((ItemStack)stack, customEffects);
        if (color != null) {
            PotionUtils2.setCustomColor(stack, color);
        }
        if (Util.CoatingType.getCoatingType(stack) != Util.CoatingType.FOOD) {
            stack.m_41783_().m_128405_(TAG_USES, Services.PLATFORM.coatingUses());
        }
    }

    public static void useCharge(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            int uses = nbt.m_128451_(TAG_USES);
            if (--uses > 0) {
                nbt.m_128405_(TAG_USES, uses);
            } else {
                CLayeredReinforcedCauldronBlock.removeCoating(stack);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DRAGONS_BREATH});
    }

    public void m_214162_(BlockState stateIn, Level world, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.m_61143_((Property)DRAGONS_BREATH)).booleanValue()) {
            world.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSoundEvents.BUBBLING_WATER_CAULDRON, SoundSource.BLOCKS, 0.25f, 1.0f, false);
        }
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof CReinforcedCauldronBlockEntity) {
            ((CReinforcedCauldronBlockEntity)tileentity).onEntityCollision(entityIn);
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        int wLevel = (Integer)state.m_61143_((Property)f_153514_);
        if (wLevel > 1) {
            world.m_5594_(null, pos, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.8f, 1.0f);
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)f_153514_, (Comparable)Integer.valueOf(wLevel - 1)));
            world.m_186460_(pos, (Block)this, brew_speed);
        } else {
            List items = world.m_45976_(ItemEntity.class, new AABB(pos));
            if (items.size() == 1) {
                CLayeredReinforcedCauldronBlock.handleWeaponCoating(state, (Level)world, pos, null, ((ItemEntity)items.get(0)).m_32055_());
            } else {
                CLayeredReinforcedCauldronBlock.boom((Level)world, pos);
            }
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return Services.PLATFORM.makeReinforcedCauldron(p_153215_, p_153216_);
    }
}

