/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.Event;
import tfar.davespotioneering.DavesPotioneering;
import tfar.davespotioneering.ModConfig;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.client.DavesPotioneeringClient;
import tfar.davespotioneering.init.ModPotions;

public class ForgeEvents {
    public static void potionCooldown(PlayerInteractEvent.RightClickItem e) {
        ItemStack stack = e.getItemStack();
        Player player = e.getEntity();
        if (!player.m_9236_().f_46443_ && stack.m_41720_() instanceof ThrowablePotionItem) {
            player.m_36335_().m_41524_(stack.m_41720_(), ((Integer)ModConfig.Server.potion_throw_cooldown.get()).intValue());
        }
    }

    public static void milkCow(PlayerInteractEvent.EntityInteractSpecific e) {
        Entity clicked = e.getTarget();
        Player player = e.getEntity();
        if (((Boolean)ModConfig.Server.milk.get()).booleanValue() && clicked instanceof Cow) {
            Cow cowEntity = (Cow)clicked;
            ItemStack itemstack = player.m_21120_(e.getHand());
            if (itemstack.m_41720_() == Items.f_42590_ && !cowEntity.m_6162_()) {
                player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
                itemstack.m_41774_(1);
                ItemStack milkBottle = new ItemStack((ItemLike)Items.f_42589_);
                PotionUtils.m_43549_((ItemStack)milkBottle, (Potion)ModPotions.MILK);
                player.m_36356_(milkBottle);
            }
        }
    }

    public static void afterHit(LivingDamageEvent e) {
        LivingEntity victim = e.getEntity();
        DamageSource source = e.getSource();
        Entity trueSource = source.m_7639_();
        if (trueSource instanceof Player) {
            Player attacker = (Player)trueSource;
            DavesPotioneering.afterHit(attacker, victim);
        }
    }

    public static void playerBrew(PlayerBrewedPotionEvent e) {
        DavesPotioneering.playerTakeBrewedPotion(e.getEntity());
    }

    public static void canApplyEffect(MobEffectEvent.Applicable e) {
        if (!DavesPotioneering.canApplyEffect(e.getEntity())) {
            e.setResult(Event.Result.DENY);
        }
    }

    public static void serverStart(ServerStartingEvent e) {
        Util.setStackSize(Items.f_42589_, (Integer)ModConfig.Server.potion_stack_size.get());
        Util.setStackSize(Items.f_42736_, (Integer)ModConfig.Server.splash_potion_stack_size.get());
        Util.setStackSize(Items.f_42739_, (Integer)ModConfig.Server.lingering_potion_stack_size.get());
    }

    public static void effectColor(PotionColorCalculationEvent e) {
        int old = e.getColor();
        if (old == 0) {
            for (MobEffectInstance effectinstance : e.getEffects()) {
                if (!effectinstance.equals((Object)ModPotions.INVIS_2)) continue;
                e.setColor(DavesPotioneeringClient.computeinvis2Color(effectinstance));
            }
        }
    }

    public static void register() {
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::potionCooldown);
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::milkCow);
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::afterHit);
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::playerBrew);
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::canApplyEffect);
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::effectColor);
        MinecraftForge.EVENT_BUS.addListener(ForgeEvents::serverStart);
    }
}

