/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import tfar.davespotioneering.DavesPotioneering;
import tfar.davespotioneering.ForgeEvents;
import tfar.davespotioneering.ModConfig;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.client.DavesPotioneeringClientForge;
import tfar.davespotioneering.datagen.ModDatagen;
import tfar.davespotioneering.effect.PotionIngredient;
import tfar.davespotioneering.init.ModCreativeTab;
import tfar.davespotioneering.init.ModPotions;
import tfar.davespotioneering.item.CGauntletItem;
import tfar.davespotioneering.net.PacketHandler;

@Mod(value="davespotioneering")
public class DavesPotioneeringForge {
    public static final ModConfig.Client CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ModConfig.Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static Map<Registry<?>, List<Pair<ResourceLocation, Supplier<?>>>> registerLater;

    public DavesPotioneeringForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ModDatagen::start);
        bus.addListener(this::register);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_SPEC);
        bus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.addListener(this::stackAdj);
        MinecraftForge.EVENT_BUS.addListener(this::playerTick);
        MinecraftForge.EVENT_BUS.addListener(this::tagReload);
        if (FMLEnvironment.dist.isClient()) {
            bus.addListener(DavesPotioneeringClientForge::doClientStuff);
            bus.addListener(DavesPotioneeringClientForge::registerLoader);
            bus.addListener(DavesPotioneeringClientForge::particle);
            bus.addListener(DavesPotioneeringClientForge::overlay);
        }
        DavesPotioneering.earlySetup();
    }

    private void register(RegisterEvent e) {
        for (Map.Entry<Registry<?>, List<Pair<ResourceLocation, Supplier<?>>>> entry : registerLater.entrySet()) {
            Registry<?> registry = entry.getKey();
            List<Pair<ResourceLocation, Supplier<?>>> toRegister = entry.getValue();
            for (Pair<ResourceLocation, Supplier<?>> pair : toRegister) {
                e.register(registry.m_123023_(), (ResourceLocation)pair.getLeft(), (Supplier)pair.getValue());
            }
        }
        e.register(Registries.f_279569_, new ResourceLocation("davespotioneering", "davespotioneering"), () -> ModCreativeTab.DAVESPOTIONEERING);
    }

    private void tagReload(TagsUpdatedEvent event) {
        DavesPotioneering.tagsUpdated();
    }

    private void setup(FMLCommonSetupEvent event) {
        ForgeEvents.register();
        ItemStack milkPot = new ItemStack((ItemLike)Items.f_42589_);
        PotionUtils.m_43549_((ItemStack)milkPot, (Potion)ModPotions.MILK);
        ItemStack splashMilkPot = new ItemStack((ItemLike)Items.f_42736_);
        PotionUtils.m_43549_((ItemStack)splashMilkPot, (Potion)ModPotions.MILK);
        ItemStack lingerMilkPot = new ItemStack((ItemLike)Items.f_42739_);
        PotionUtils.m_43549_((ItemStack)lingerMilkPot, (Potion)ModPotions.MILK);
        BrewingRecipeRegistry.addRecipe((Ingredient)PotionIngredient.create(milkPot), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42403_}), (ItemStack)splashMilkPot);
        BrewingRecipeRegistry.addRecipe((Ingredient)PotionIngredient.create(milkPot), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42735_}), (ItemStack)lingerMilkPot);
        DavesPotioneeringForge.strongRecipe(Potions.f_43605_, ModPotions.STRONG_INVISIBILITY);
        PacketHandler.registerMessages();
        DavesPotioneering.commonSetup();
    }

    private void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CGauntletItem.tickCooldownsCommon(serverPlayer);
        }
    }

    private void stackAdj(ServerStartingEvent e) {
        Util.setStackSize(Items.f_42589_, (Integer)ModConfig.Server.potion_stack_size.get());
        Util.setStackSize(Items.f_42736_, (Integer)ModConfig.Server.splash_potion_stack_size.get());
        Util.setStackSize(Items.f_42739_, (Integer)ModConfig.Server.lingering_potion_stack_size.get());
    }

    protected static void strongRecipe(Potion potion, Potion strong) {
        BrewingRecipeRegistry.addRecipe((Ingredient)PotionIngredient.create(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion)), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42525_}), (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)strong));
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ModConfig.Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (ModConfig.Client)specPair.getLeft();
        Pair specPair2 = new ForgeConfigSpec.Builder().configure(ModConfig.Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair2.getRight();
        SERVER = (ModConfig.Server)specPair2.getLeft();
        registerLater = new HashMap();
    }
}

