/*
 * Decompiled with CFR 0.152.
 */
package tfar.davespotioneering;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tfar.davespotioneering.Util;
import tfar.davespotioneering.block.CLayeredReinforcedCauldronBlock;
import tfar.davespotioneering.block.ModCauldronInteractions;
import tfar.davespotioneering.duck.BrewingStandDuck;
import tfar.davespotioneering.init.ModBlockEntityTypes;
import tfar.davespotioneering.init.ModBlocks;
import tfar.davespotioneering.init.ModEffects;
import tfar.davespotioneering.init.ModItems;
import tfar.davespotioneering.init.ModMenuTypes;
import tfar.davespotioneering.init.ModParticleTypes;
import tfar.davespotioneering.init.ModPotions;
import tfar.davespotioneering.init.ModRecipeSerializers;
import tfar.davespotioneering.init.ModSoundEvents;
import tfar.davespotioneering.item.CUmbrellaItem;
import tfar.davespotioneering.menu.CAdvancedBrewingStandMenu;
import tfar.davespotioneering.mixin.BlockEntityTypeAcces;
import tfar.davespotioneering.mixin.BrewingStandContainerAccess;
import tfar.davespotioneering.platform.Services;

public class DavesPotioneering {
    public static final String MOD_NAME = "Dave's Potioneering";
    public static final Logger LOG = LoggerFactory.getLogger((String)"Dave's Potioneering");
    public static final String MODID = "davespotioneering";
    public static final boolean isFabric = Services.PLATFORM.getPlatformName().equals("Fabric");

    public static void earlySetup() {
        Services.PLATFORM.superRegister(ModBlocks.class, BuiltInRegistries.f_256975_, Block.class);
        Services.PLATFORM.superRegister(ModEffects.class, BuiltInRegistries.f_256974_, MobEffect.class);
        Services.PLATFORM.superRegister(ModItems.class, BuiltInRegistries.f_257033_, Item.class);
        Services.PLATFORM.superRegister(ModBlockEntityTypes.class, BuiltInRegistries.f_257049_, BlockEntityType.class);
        Services.PLATFORM.superRegister(ModMenuTypes.class, BuiltInRegistries.f_256818_, MenuType.class);
        Services.PLATFORM.superRegister(ModPotions.class, BuiltInRegistries.f_256980_, Potion.class);
        Services.PLATFORM.superRegister(ModParticleTypes.class, BuiltInRegistries.f_257034_, ParticleType.class);
        Services.PLATFORM.superRegister(ModSoundEvents.class, BuiltInRegistries.f_256894_, SoundEvent.class);
        Services.PLATFORM.superRegister(ModRecipeSerializers.class, BuiltInRegistries.f_256769_, RecipeSerializer.class);
    }

    public static void commonSetup() {
        HashSet<Block> newSet = new HashSet<Block>(((BlockEntityTypeAcces)BlockEntityType.f_58908_).getValidBlocks());
        newSet.add(ModBlocks.MAGIC_LECTERN);
        ((BlockEntityTypeAcces)BlockEntityType.f_58908_).setValidBlocks(newSet);
    }

    public static void onEat(Player player, ItemStack stack) {
        List mobEffectInstances = PotionUtils.m_43547_((ItemStack)stack);
        for (MobEffectInstance effectInstance : mobEffectInstances) {
            player.m_7292_(new MobEffectInstance(effectInstance.m_19544_(), Math.max(effectInstance.m_19557_() / 8, 1), effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19575_()));
        }
    }

    public static void potionBrew(BlockEntity brewingStandTileEntity, ItemStack ingredient) {
        ((BrewingStandDuck)brewingStandTileEntity).addXp(Util.getBrewXp(ingredient));
    }

    public static void heldItemChangeEvent(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof LingeringPotionItem || stack.m_41720_() instanceof SplashPotionItem) {
            player.m_36335_().m_41524_(Items.f_42736_, Services.PLATFORM.potionSwitchCooldown());
            player.m_36335_().m_41524_(Items.f_42739_, Services.PLATFORM.potionSwitchCooldown());
        }
    }

    public static void playerTakeBrewedPotion(Player player) {
        if (!player.m_9236_().f_46443_) {
            AbstractContainerMenu container = player.f_36096_;
            Object entity = null;
            if (container instanceof BrewingStandMenu) {
                entity = (BrewingStandBlockEntity)((BrewingStandContainerAccess)container).getBrewingStand();
            } else if (container instanceof CAdvancedBrewingStandMenu) {
                entity = ((CAdvancedBrewingStandMenu)container).blockEntity;
            }
            if (entity != null) {
                ((BrewingStandDuck)entity).dump(player);
            }
        }
    }

    public static boolean canApplyEffect(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return !(player.m_21211_().m_41720_() instanceof CUmbrellaItem);
        }
        return true;
    }

    public static void afterHit(Player player, LivingEntity victim) {
        ItemStack weapon = player.m_21205_();
        if (DavesPotioneering.isCoatable(weapon)) {
            List potion = PotionUtils.m_43547_((ItemStack)weapon);
            for (MobEffectInstance effectinstance : potion) {
                victim.m_7292_(new MobEffectInstance(effectinstance.m_19544_(), Math.max(effectinstance.m_19557_() / 8, 1), effectinstance.m_19564_(), effectinstance.m_19571_(), effectinstance.m_19572_()));
            }
            if (!player.m_150110_().f_35937_) {
                CLayeredReinforcedCauldronBlock.useCharge(weapon);
            }
        }
    }

    public static boolean isCoatable(ItemStack stack) {
        return stack.m_204117_(ModItems.WHITELISTED) && !stack.m_204117_(ModItems.BLACKLISTED);
    }

    public static void tagsUpdated() {
        long start = net.minecraft.Util.m_137569_();
        ModCauldronInteractions.reload();
        long end = net.minecraft.Util.m_137569_();
        long time = end - start;
        float ms = (float)time / 1000000.0f;
        DecimalFormat df = new DecimalFormat("#.####");
        df.setRoundingMode(RoundingMode.DOWN);
        String s = df.format(ms);
        LOG.info("Took " + s + " ms to reload cauldron interactions");
    }
}

