/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.controls.simple;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiRowLabel;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.TextMapBuilder;

public class GuiButtonContext
extends GuiButton {
    protected GuiChildControl extension;
    protected TextMapBuilder<Consumer<Integer>> map;
    protected boolean isHovered = false;

    public GuiButtonContext(String name, TextMapBuilder<Consumer<Integer>> map) {
        super(name, map.first());
        this.map = map;
    }

    @Override
    public void mouseMoved(Rect rect, double x, double y) {
        super.mouseMoved(rect, x, y);
        this.isHovered = rect.inside(x + rect.minX, y + rect.minY);
        if (this.isHovered && this.extension == null) {
            this.openExtension(rect);
        }
    }

    public void openExtension(Rect rect) {
        GuiParent parent = new GuiParent(){

            @Override
            public void mouseMoved(Rect rect, double x, double y) {
                super.mouseMoved(rect, x, y);
                if (!GuiButtonContext.this.isHovered && !GuiButtonContext.this.extension.rect.inside(x + rect.minX, y + rect.minY)) {
                    GuiButtonContext.this.closeExtension();
                }
            }

            @Override
            public ControlFormatting getControlFormatting() {
                return ControlFormatting.NESTED;
            }
        };
        parent.flow = GuiFlow.STACK_Y;
        parent.align = Align.STRETCH;
        int i = 0;
        for (Map.Entry<Consumer<Integer>, List<Component>> entry : this.map.entrySet()) {
            parent.add((GuiControl)new GuiRowLabel("" + i, i, false, x -> ((Consumer)entry.getKey()).accept(x)).setTitle(entry.getValue()));
            ++i;
        }
        this.extension = this.getLayer().addHoverControl(parent);
        rect = this.toLayerRect(new Rect(0.0, 0.0, rect.getWidth(), rect.getHeight()));
        this.extension.control.init();
        this.extension.setX((int)rect.maxX);
        this.extension.setY((int)rect.minY);
        int available = (int)this.getLayer().rect.getWidth() - this.getContentOffset() * 2;
        this.extension.setWidth(this.extension.getPreferredWidth(available), available);
        this.extension.flowX();
        int height = (int)this.getLayer().rect.getHeight() - this.getContentOffset() * 2;
        this.extension.setHeight(this.extension.getPreferredHeight(height), height);
        this.extension.flowY();
        Rect absolute = this.toScreenRect(this.extension.rect.copy());
        Rect screen = Rect.getScreenRect();
        if (absolute.maxY > screen.maxY && absolute.minY - absolute.getHeight() >= screen.minX) {
            this.extension.setY((int)this.extension.rect.minY + (int)rect.getHeight() - this.extension.getHeight());
        }
    }

    public void closeExtension() {
        if (this.extension != null) {
            this.getLayer().remove(this.extension);
            this.extension = null;
        }
    }
}

