/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.RandomStringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.sinytra.connector.ConnectorUtil;
import reloc.net.minecraftforge.fart.api.Transformer;

public class ModMetadataGenerator
implements Transformer {
    public static final String RESOURCE = "pack.mcmeta";
    public static final int RESOURCE_PACK_FORMAT = 15;
    private static final String MOD_ANNOTATION_DESC = "Lnet/minecraftforge/fml/common/Mod;";
    private final String modid;
    private boolean seen;

    public ModMetadataGenerator(String modid) {
        this.modid = modid;
    }

    @Override
    public Transformer.ResourceEntry process(Transformer.ResourceEntry entry) {
        if (RESOURCE.equals(entry.getName())) {
            this.seen = true;
        }
        return entry;
    }

    @Override
    public Collection<? extends Transformer.Entry> getExtras() {
        ArrayList<Transformer.Entry> extras = new ArrayList<Transformer.Entry>();
        String className = "org/sinytra/generated/%s_%s/Entrypoint_%s".formatted(this.modid, RandomStringUtils.randomAlphabetic((int)5), this.modid);
        byte[] classData = this.generateFMLModEntrypoint(className);
        extras.add(Transformer.ClassEntry.create(className + ".class", 318211200000L, classData));
        if (!this.seen) {
            byte[] data = ModMetadataGenerator.generatePackMetadataFile(this.modid);
            extras.add(Transformer.ResourceEntry.create(RESOURCE, 318211200000L, data));
        }
        return extras;
    }

    private byte[] generateFMLModEntrypoint(String className) {
        ClassWriter cw = new ClassWriter(0);
        cw.visit(52, 33, className, null, "java/lang/Object", null);
        AnnotationVisitor modAnnotation = cw.visitAnnotation(MOD_ANNOTATION_DESC, true);
        modAnnotation.visit("value", (Object)this.modid);
        modAnnotation.visitEnd();
        MethodVisitor constructor = cw.visitMethod(1, "<init>", "()V", null, null);
        constructor.visitCode();
        Label start = new Label();
        constructor.visitLabel(start);
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        constructor.visitInsn(177);
        Label end = new Label();
        constructor.visitLabel(end);
        constructor.visitLocalVariable("this", "L" + className + ";", null, start, end, 0);
        constructor.visitMaxs(1, 1);
        constructor.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    public static byte[] generatePackMetadataFile(String modid) {
        byte[] byArray;
        JsonObject packMeta = new JsonObject();
        JsonObject pack = new JsonObject();
        JsonObject description = new JsonObject();
        description.addProperty("text", modid + " resources, generated by Connector");
        pack.add("description", (JsonElement)description);
        pack.addProperty("pack_format", (Number)15);
        packMeta.add("pack", (JsonElement)pack);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        try {
            byte[] data;
            try (OutputStreamWriter writer = new OutputStreamWriter(byteStream);){
                ConnectorUtil.prettyGson().toJson((JsonElement)packMeta, (Appendable)writer);
                ((Writer)writer).flush();
            }
            byArray = data = byteStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    byteStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        byteStream.close();
        return byArray;
    }
}

