/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.MethodContextImpl;
import org.sinytra.adapter.patch.PatchContextImpl;
import org.sinytra.adapter.patch.api.ClassTransform;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.api.PatchEnvironment;
import org.sinytra.adapter.patch.selector.AnnotationHandle;
import org.sinytra.adapter.patch.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.transformer.ChangeModifiedVariableIndex;
import org.sinytra.adapter.patch.transformer.ExtractMixin;
import org.sinytra.adapter.patch.transformer.ModifyInjectionTarget;
import org.sinytra.adapter.patch.transformer.ModifyMethodAccess;
import org.sinytra.adapter.patch.transformer.ModifyMethodParams;
import org.sinytra.adapter.patch.transformer.ModifyMixinType;
import org.sinytra.adapter.patch.transformer.ModifyTargetClasses;
import org.sinytra.adapter.patch.transformer.ModifyVarUpgradeToModifyExprVal;
import org.sinytra.adapter.patch.transformer.SplitMixinTransform;
import org.sinytra.adapter.patch.transformer.param.TransformParameters;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class PatchInstance
implements Patch {
    public static final Collection<String> KNOWN_MIXIN_TYPES = Set.of("Lorg/spongepowered/asm/mixin/injection/Inject;", "Lorg/spongepowered/asm/mixin/injection/Redirect;", "Lorg/spongepowered/asm/mixin/injection/ModifyArg;", "Lorg/spongepowered/asm/mixin/injection/ModifyArgs;", "Lorg/spongepowered/asm/mixin/injection/ModifyVariable;", "Lorg/spongepowered/asm/mixin/injection/ModifyConstant;", "Lcom/llamalad7/mixinextras/injector/ModifyExpressionValue;", "Lcom/llamalad7/mixinextras/injector/wrapoperation/WrapOperation;", "Lcom/llamalad7/mixinextras/injector/WrapWithCondition;", "Lcom/llamalad7/mixinextras/injector/ModifyReturnValue;");
    public static final Marker MIXINPATCH = MarkerFactory.getMarker((String)"MIXINPATCH");
    protected final List<String> targetClasses;
    protected final List<String> targetAnnotations;
    @Nullable
    protected final Predicate<AnnotationHandle> targetAnnotationValues;
    protected final List<ClassTransform> classTransforms;
    protected final List<MethodTransform> transforms;

    protected PatchInstance(List<String> targetClasses, List<String> targetAnnotations, List<MethodTransform> transforms) {
        this(targetClasses, targetAnnotations, map -> true, List.of(), transforms);
    }

    protected PatchInstance(List<String> targetClasses, List<String> targetAnnotations, Predicate<AnnotationHandle> targetAnnotationValues, List<ClassTransform> classTransforms, List<MethodTransform> transforms) {
        this.targetClasses = targetClasses;
        this.targetAnnotations = targetAnnotations;
        this.targetAnnotationValues = targetAnnotationValues;
        this.classTransforms = classTransforms;
        this.transforms = transforms;
    }

    public abstract Codec<? extends PatchInstance> codec();

    @Override
    public Patch.Result apply(ClassNode classNode, PatchEnvironment environment) {
        Patch.Result result = Patch.Result.PASS;
        ClassTarget classTarget = this.checkClassTarget(classNode);
        if (classTarget != null) {
            PatchContextImpl context = new PatchContextImpl(classNode, classTarget.targetTypes(), environment);
            AnnotationValueHandle<?> classAnnotation = classTarget.handle();
            for (ClassTransform classTransform : this.classTransforms) {
                result = result.or(classTransform.apply(classNode, classTarget.handle(), context));
            }
            for (MethodNode method : classNode.methods) {
                MethodContext methodContext = this.checkMethodTarget(classAnnotation, classNode, method, environment, classTarget.targetTypes(), context);
                if (methodContext == null) continue;
                for (MethodTransform transform : this.transforms) {
                    Collection<String> accepted = transform.getAcceptedAnnotations();
                    if (!accepted.isEmpty() && !accepted.contains(methodContext.methodAnnotation().getDesc())) continue;
                    result = result.or(transform.apply(classNode, method, methodContext, context));
                }
            }
            context.run();
        }
        return result;
    }

    private ClassTarget checkClassTarget(ClassNode classNode) {
        if (classNode.invisibleAnnotations != null) {
            for (AnnotationNode annotation : classNode.invisibleAnnotations) {
                if (!annotation.desc.equals("Lorg/spongepowered/asm/mixin/Mixin;")) continue;
                return PatchInstance.findAnnotationValue(annotation.values, "value").map(types -> {
                    for (Type targetType : (List)types.get()) {
                        if (!this.targetClasses.isEmpty() && !this.targetClasses.contains(targetType.getInternalName())) continue;
                        return new ClassTarget((AnnotationValueHandle<?>)types, (List)types.get());
                    }
                    return null;
                }).or(() -> PatchInstance.findAnnotationValue(annotation.values, "targets").map(types -> {
                    for (String targetType : (List)types.get()) {
                        if (!this.targetClasses.isEmpty() && !this.targetClasses.contains(targetType)) continue;
                        return new ClassTarget((AnnotationValueHandle<?>)types, ((List)types.get()).stream().map(Type::getObjectType).toList());
                    }
                    return null;
                })).orElse(null);
            }
        }
        return this.targetClasses.isEmpty() ? new ClassTarget(null, List.of()) : null;
    }

    @Nullable
    private MethodContext checkMethodTarget(@Nullable AnnotationValueHandle<?> classAnnotation, ClassNode owner, MethodNode method, PatchEnvironment remaper, List<Type> targetTypes, PatchContext context) {
        if (method.visibleAnnotations != null) {
            for (AnnotationNode annotation : method.visibleAnnotations) {
                AnnotationHandle annotationHandle;
                if (!this.targetAnnotations.isEmpty() && !this.targetAnnotations.contains(annotation.desc)) continue;
                MethodContextImpl.Builder builder = MethodContextImpl.builder();
                if (classAnnotation != null) {
                    builder.classNode(owner);
                    builder.classAnnotation(classAnnotation);
                    builder.targetTypes(targetTypes);
                }
                if (!this.checkAnnotation(owner.name, method, annotationHandle = new AnnotationHandle(annotation), remaper, builder) || this.targetAnnotationValues != null && !this.targetAnnotationValues.test(annotationHandle)) continue;
                return builder.build(context);
            }
        }
        return null;
    }

    protected abstract boolean checkAnnotation(String var1, MethodNode var2, AnnotationHandle var3, PatchEnvironment var4, MethodContextImpl.Builder var5);

    public static <T> Optional<AnnotationValueHandle<T>> findAnnotationValue(@Nullable List<Object> values, String key) {
        if (values != null) {
            for (int i = 0; i < values.size(); i += 2) {
                String atKey = (String)values.get(i);
                if (!atKey.equals(key)) continue;
                int index = i + 1;
                return Optional.of(new AnnotationValueHandle(values, index, key));
            }
        }
        return Optional.empty();
    }

    private record ClassTarget(@Nullable AnnotationValueHandle<?> handle, List<Type> targetTypes) {
    }

    protected static abstract class BaseBuilder<T extends Patch.Builder<T>>
    implements Patch.Builder<T> {
        protected final Set<String> targetClasses = new HashSet<String>();
        protected final Set<String> targetAnnotations = new HashSet<String>();
        protected Predicate<AnnotationHandle> targetAnnotationValues;
        protected final List<ClassTransform> classTransforms = new ArrayList<ClassTransform>();
        protected final List<MethodTransform> transforms = new ArrayList<MethodTransform>();

        protected BaseBuilder() {
        }

        @Override
        public T targetClass(String ... targets) {
            this.targetClasses.addAll(List.of(targets));
            return this.coerce();
        }

        @Override
        public T targetMixinType(String ... annotationDescs) {
            this.targetAnnotations.addAll(List.of(annotationDescs));
            return this.coerce();
        }

        @Override
        public T targetAnnotationValues(Predicate<AnnotationHandle> values) {
            this.targetAnnotationValues = this.targetAnnotationValues == null ? values : this.targetAnnotationValues.or(values);
            return this.coerce();
        }

        @Override
        public T modifyTargetClasses(Consumer<List<Type>> consumer) {
            return this.transform(new ModifyTargetClasses(consumer));
        }

        @Override
        public T modifyParams(Consumer<ModifyMethodParams.Builder> consumer) {
            ModifyMethodParams.Builder builder = ModifyMethodParams.builder();
            consumer.accept(builder);
            return this.transform(builder.build());
        }

        @Override
        public T transformParams(Consumer<TransformParameters.Builder> consumer) {
            TransformParameters.Builder builder = new TransformParameters.Builder();
            consumer.accept(builder);
            return this.transform(builder.build());
        }

        @Override
        public T modifyTarget(String ... methods) {
            return this.transform(new ModifyInjectionTarget(List.of(methods)));
        }

        @Override
        public T modifyTarget(ModifyInjectionTarget.Action action, String ... methods) {
            return this.transform(new ModifyInjectionTarget(List.of(methods), action));
        }

        @Override
        public T modifyVariableIndex(int start, int offset) {
            return this.transform(new ChangeModifiedVariableIndex(start, offset));
        }

        @Override
        public T modifyMethodAccess(ModifyMethodAccess.AccessChange ... changes) {
            return this.transform(new ModifyMethodAccess(List.of(changes)));
        }

        @Override
        public T extractMixin(String targetClass) {
            return this.transform(ModifyVarUpgradeToModifyExprVal.INSTANCE).transform(new ExtractMixin(targetClass));
        }

        @Override
        public T splitMixin(String targetClass) {
            return this.transform(new SplitMixinTransform(targetClass));
        }

        @Override
        public T improveModifyVar() {
            return this.transform(ModifyVarUpgradeToModifyExprVal.INSTANCE);
        }

        @Override
        public T modifyMixinType(String newType, Consumer<ModifyMixinType.Builder> consumer) {
            return this.transform(new ModifyMixinType(newType, consumer));
        }

        @Override
        public T transform(List<ClassTransform> classTransforms) {
            this.classTransforms.addAll(classTransforms);
            return this.coerce();
        }

        @Override
        public T transform(ClassTransform transformer) {
            this.classTransforms.add(transformer);
            return this.coerce();
        }

        @Override
        public T transform(MethodTransform transformer) {
            this.transforms.add(transformer);
            return this.coerce();
        }

        @Override
        public T transformMethods(List<MethodTransform> transformers) {
            transformers.forEach(this::transform);
            return this.coerce();
        }

        @Override
        public T chain(Consumer<T> consumer) {
            consumer.accept(this.coerce());
            return this.coerce();
        }

        private T coerce() {
            return (T)this;
        }
    }
}

