/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.mod_menu.gui.widget.entries;

import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.mod_menu.ModMenu;
import com.terraformersmc.mod_menu.gui.widget.ModListWidget;
import com.terraformersmc.mod_menu.gui.widget.entries.ChildParentEntry;
import com.terraformersmc.mod_menu.gui.widget.entries.ParentEntry;
import com.terraformersmc.mod_menu.util.DrawingUtil;
import com.terraformersmc.mod_menu.util.mod.Mod;
import com.terraformersmc.mod_menu.util.mod.ModBadgeRenderer;
import java.awt.Dimension;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.ModContainer;

public class ModListEntry
extends ObjectSelectionList.Entry<ModListEntry> {
    public static final ResourceLocation UNKNOWN_ICON = new ResourceLocation("textures/misc/unknown_pack.png");
    private static final ResourceLocation MOD_CONFIGURATION_ICON = new ResourceLocation("mod_menu", "textures/gui/mod_configuration.png");
    private static final ResourceLocation ERROR_ICON = new ResourceLocation("minecraft", "textures/gui/world_selection.png");
    protected final Minecraft client;
    public final Mod mod;
    protected final ModListWidget list;
    protected Tuple<ResourceLocation, Dimension> iconLocation;
    protected Tuple<ResourceLocation, Dimension> smallIconLocation;
    protected static final int FULL_ICON_SIZE = 32;
    protected static final int COMPACT_ICON_SIZE = 19;
    protected long sinceLastClick;

    public ModListEntry(Mod mod, ModListWidget list) {
        this.mod = mod;
        this.list = list;
        this.client = Minecraft.m_91087_();
    }

    public Component m_142172_() {
        return Component.m_237113_((String)this.mod.getTranslatedName());
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float delta) {
        MutableComponent name;
        x += this.getXOffset();
        rowWidth -= this.getXOffset();
        int iconSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 19 : 32;
        String modId = this.mod.getId();
        if ("java".equals(modId)) {
            DrawingUtil.drawRandomVersionBackground(this.mod, guiGraphics, x, y, iconSize, iconSize);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        if (((Dimension)this.getIconTexture().m_14419_()).height == ((Dimension)this.getIconTexture().m_14419_()).width) {
            guiGraphics.m_280163_((ResourceLocation)this.getIconTexture().m_14418_(), x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        } else if (((Dimension)this.getSquareIconTexture().m_14419_()).height == ((Dimension)this.getSquareIconTexture().m_14419_()).width) {
            guiGraphics.m_280163_((ResourceLocation)this.getSquareIconTexture().m_14418_(), x, y, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        } else {
            guiGraphics.m_280163_((ResourceLocation)this.getSquareIconTexture().m_14418_(), (int)((float)x + (float)(iconSize - ((Dimension)this.getSquareIconTexture().m_14419_()).width) / 2.0f), (int)((float)y + (float)(iconSize - ((Dimension)this.getSquareIconTexture().m_14419_()).height) / 2.0f), 0.0f, 0.0f, ((Dimension)this.getSquareIconTexture().m_14419_()).width, ((Dimension)this.getSquareIconTexture().m_14419_()).height, ((Dimension)this.getSquareIconTexture().m_14419_()).width, ((Dimension)this.getSquareIconTexture().m_14419_()).height);
        }
        RenderSystem.disableBlend();
        MutableComponent trimmedName = name = Component.m_237113_((String)this.mod.getTranslatedName());
        int maxNameWidth = rowWidth - iconSize - 3;
        Font font = this.client.f_91062_;
        if (font.m_92852_((FormattedText)name) > maxNameWidth) {
            FormattedText ellipsis = FormattedText.m_130775_((String)"...");
            trimmedName = FormattedText.m_130773_((FormattedText[])new FormattedText[]{font.m_92854_((FormattedText)name, maxNameWidth - font.m_92852_(ellipsis)), ellipsis});
        }
        guiGraphics.m_280649_(font, Language.m_128107_().m_5536_((FormattedText)trimmedName), x + iconSize + 3, y + 1, 0xFFFFFF, false);
        int updateBadgeXOffset = 0;
        if (!((Boolean)ModMenu.getConfig().HIDE_BADGES.get()).booleanValue()) {
            new ModBadgeRenderer(x + iconSize + 3 + font.m_92852_((FormattedText)name) + 2 + updateBadgeXOffset, y, x + rowWidth, this.mod, this.list.getParent()).draw(guiGraphics);
        }
        if (!((Boolean)ModMenu.getConfig().COMPACT_LIST.get()).booleanValue()) {
            String summary = this.mod.getSummary();
            Objects.requireNonNull(this.client.f_91062_);
            DrawingUtil.drawWrappedString(guiGraphics, summary, x + iconSize + 3 + 4, y + 9 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        } else {
            String string = this.mod.getPrefixedVersion();
            Objects.requireNonNull(this.client.f_91062_);
            DrawingUtil.drawWrappedString(guiGraphics, string, x + iconSize + 3, y + 9 + 2, rowWidth - iconSize - 7, 2, 0x808080);
        }
        if (!(this instanceof ParentEntry) && !(this instanceof ChildParentEntry) && ((Boolean)ModMenu.getConfig().QUICK_CONFIGURE.get()).booleanValue() && (this.list.getParent().getModHasConfigScreen(this.mod.getContainer()) || this.list.getParent().modScreenErrors.containsKey(modId))) {
            int textureSize;
            int n = textureSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 152 : 256;
            if (((Boolean)this.client.f_91066_.m_231828_().m_231551_()).booleanValue() || hovered) {
                int v;
                guiGraphics.m_280509_(x, y, x + iconSize, y + iconSize, -1601138544);
                boolean hoveringIcon = mouseX - x < iconSize;
                int n2 = v = hoveringIcon ? iconSize : 0;
                if (this.list.getParent().modScreenErrors.containsKey(modId)) {
                    guiGraphics.m_280163_(ERROR_ICON, x, y, 96.0f, (float)v, iconSize, iconSize, textureSize, textureSize);
                    if (hoveringIcon) {
                        Throwable e = this.list.getParent().modScreenErrors.get(modId);
                        this.list.getParent().m_257959_(this.client.f_91062_.m_92923_((FormattedText)Component.m_237110_((String)"mod_menu.configure.error", (Object[])new Object[]{modId, modId}).m_6881_().m_130946_("\n\n").m_130946_(e.toString()).m_130940_(ChatFormatting.RED), 175));
                    }
                } else {
                    guiGraphics.m_280163_(MOD_CONFIGURATION_ICON, x, y, 0.0f, (float)v, iconSize, iconSize, textureSize, textureSize);
                }
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int delta) {
        this.list.select(this);
        if (((Boolean)ModMenu.getConfig().QUICK_CONFIGURE.get()).booleanValue() && this.list.getParent().getModHasConfigScreen(this.mod.getContainer())) {
            int iconSize;
            int n = iconSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 19 : 32;
            if (mouseX - (double)this.list.m_5747_() <= (double)(iconSize + this.getXOffset())) {
                this.openConfig();
            } else if (Util.m_137550_() - this.sinceLastClick < 250L) {
                this.openConfig();
            }
        }
        this.sinceLastClick = Util.m_137550_();
        return true;
    }

    public void openConfig() {
        this.mod.getContainer().ifPresent(modContainer -> this.list.getParent().safelyOpenConfigScreen((ModContainer)modContainer));
    }

    public Mod getMod() {
        return this.mod;
    }

    public Tuple<ResourceLocation, Dimension> getIconTexture() {
        if (ModMenu.shouldResetCache) {
            this.smallIconLocation = null;
            this.iconLocation = null;
            ModMenu.shouldResetCache = false;
        }
        if (this.iconLocation == null) {
            this.iconLocation = new Tuple((Object)new ResourceLocation("mod_menu", this.mod.getId() + "_icon"), (Object)new Dimension());
            Tuple<DynamicTexture, Dimension> icon = this.mod.getIcon(this.list.getNeoforgeIconHandler(), 64 * (Integer)this.client.f_91066_.m_231928_().m_231551_(), false);
            if (icon != null) {
                float multiplier = 32.0f / (float)((Dimension)icon.m_14419_()).height;
                this.iconLocation.m_145025_((Object)new Dimension((int)((float)((Dimension)icon.m_14419_()).width * multiplier), (int)((float)((Dimension)icon.m_14419_()).height * multiplier)));
                this.client.m_91097_().m_118495_((ResourceLocation)this.iconLocation.m_14418_(), (AbstractTexture)icon.m_14418_());
            } else {
                this.iconLocation.m_145023_((Object)UNKNOWN_ICON);
            }
        }
        return this.iconLocation;
    }

    public Tuple<ResourceLocation, Dimension> getSquaredIconTexture() {
        Tuple icon = new Tuple((Object)((ResourceLocation)this.getIconTexture().m_14418_()), (Object)((Dimension)this.iconLocation.m_14419_()).getSize());
        float iconSize = (Boolean)ModMenu.getConfig().COMPACT_LIST.get() != false ? 19.0f : 32.0f;
        float biggerValue = Math.max(((Dimension)icon.m_14419_()).width, ((Dimension)icon.m_14419_()).height);
        ((Dimension)icon.m_14419_()).setSize((float)((Dimension)icon.m_14419_()).width / biggerValue * iconSize, (float)((Dimension)icon.m_14419_()).height / biggerValue * iconSize);
        return icon;
    }

    public Tuple<ResourceLocation, Dimension> getSquareIconTexture() {
        if (this.smallIconLocation == null) {
            this.smallIconLocation = new Tuple((Object)new ResourceLocation("mod_menu", this.mod.getId() + "_icon_small"), (Object)new Dimension());
            Tuple<DynamicTexture, Dimension> icon = this.mod.getIcon(this.list.getNeoforgeIconHandler(), 64 * (Integer)this.client.f_91066_.m_231928_().m_231551_(), true);
            if (icon != null) {
                this.smallIconLocation.m_145025_((Object)new Dimension());
                this.client.m_91097_().m_118495_((ResourceLocation)this.smallIconLocation.m_14418_(), (AbstractTexture)icon.m_14418_());
            } else {
                this.smallIconLocation = this.getSquaredIconTexture();
            }
        }
        return this.smallIconLocation;
    }

    public int getXOffset() {
        return 0;
    }

    public String toString() {
        return "ModListEntry{mod_id=\"" + this.getMod().getId() + "\"}";
    }
}

