/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.luaj.vm2.luajc.BasicBlock;
import org.luaj.vm2.luajc.ProtoInfo;
import org.luaj.vm2.luajc.UpvalInfo;

public class VarInfo {
    public static VarInfo INVALID = new VarInfo(-1, -1);
    public final int slot;
    public final int pc;
    public UpvalInfo upvalue;
    public boolean allocupvalue;
    public boolean isreferenced;

    public static VarInfo PARAM(int slot) {
        return new ParamVarInfo(slot, -1);
    }

    public static VarInfo NIL(int slot) {
        return new NilVarInfo(slot, -1);
    }

    public static VarInfo PHI(ProtoInfo pi, int slot, int pc) {
        return new PhiVarInfo(pi, slot, pc);
    }

    public VarInfo(int slot, int pc) {
        this.slot = slot;
        this.pc = pc;
    }

    public String toString() {
        return this.slot < 0 ? "x.x" : this.slot + "." + this.pc;
    }

    public VarInfo resolvePhiVariableValues() {
        return null;
    }

    protected void collectUniqueValues(Set visitedBlocks, Set vars) {
        vars.add(this);
    }

    public boolean isPhiVar() {
        return false;
    }

    private static final class ParamVarInfo
    extends VarInfo {
        private ParamVarInfo(int slot, int pc) {
            super(slot, pc);
        }

        @Override
        public String toString() {
            return this.slot + ".p";
        }
    }

    private static final class NilVarInfo
    extends VarInfo {
        private NilVarInfo(int slot, int pc) {
            super(slot, pc);
        }

        @Override
        public String toString() {
            return "nil";
        }
    }

    private static final class PhiVarInfo
    extends VarInfo {
        private final ProtoInfo pi;
        VarInfo[] values;

        private PhiVarInfo(ProtoInfo pi, int slot, int pc) {
            super(slot, pc);
            this.pi = pi;
        }

        @Override
        public boolean isPhiVar() {
            return true;
        }

        @Override
        public String toString() {
            int n;
            StringBuffer sb = new StringBuffer();
            sb.append(super.toString());
            sb.append("={");
            int n2 = n = this.values != null ? this.values.length : 0;
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(String.valueOf(this.values[i]));
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public VarInfo resolvePhiVariableValues() {
            HashSet visitedBlocks = new HashSet();
            HashSet vars = new HashSet();
            this.collectUniqueValues(visitedBlocks, vars);
            if (vars.contains(INVALID)) {
                return INVALID;
            }
            int n = vars.size();
            Iterator it = vars.iterator();
            if (n == 1) {
                VarInfo v = (VarInfo)it.next();
                v.isreferenced |= this.isreferenced;
                return v;
            }
            this.values = new VarInfo[n];
            for (int i = 0; i < n; ++i) {
                this.values[i] = (VarInfo)it.next();
                this.values[i].isreferenced |= this.isreferenced;
            }
            return null;
        }

        @Override
        protected void collectUniqueValues(Set visitedBlocks, Set vars) {
            int n;
            BasicBlock b = this.pi.blocks[this.pc];
            if (this.pc == 0) {
                vars.add(this.pi.params[this.slot]);
            }
            int n2 = n = b.prev != null ? b.prev.length : 0;
            for (int i = 0; i < n; ++i) {
                BasicBlock bp = b.prev[i];
                if (visitedBlocks.contains(bp)) continue;
                visitedBlocks.add(bp);
                VarInfo v = this.pi.vars[this.slot][bp.pc1];
                if (v == null) continue;
                v.collectUniqueValues(visitedBlocks, vars);
            }
        }
    }
}

