/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.GOTO;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.IFNE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.ThreeArgFunction;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;
import org.luaj.vm2.lib.ZeroArgFunction;
import org.luaj.vm2.luajc.ProtoInfo;

public class JavaBuilder {
    private static final String STR_VARARGS = Varargs.class.getName();
    private static final String STR_LUAVALUE = LuaValue.class.getName();
    private static final String STR_LUASTRING = LuaString.class.getName();
    private static final String STR_LUAINTEGER = LuaInteger.class.getName();
    private static final String STR_LUANUMBER = LuaNumber.class.getName();
    private static final String STR_LUABOOLEAN = LuaBoolean.class.getName();
    private static final String STR_LUATABLE = LuaTable.class.getName();
    private static final String STR_BUFFER = Buffer.class.getName();
    private static final String STR_STRING = String.class.getName();
    private static final String STR_JSEPLATFORM = "org.luaj.vm2.lib.jse.JsePlatform";
    private static final ObjectType TYPE_VARARGS = new ObjectType(STR_VARARGS);
    private static final ObjectType TYPE_LUAVALUE = new ObjectType(STR_LUAVALUE);
    private static final ObjectType TYPE_LUASTRING = new ObjectType(STR_LUASTRING);
    private static final ObjectType TYPE_LUAINTEGER = new ObjectType(STR_LUAINTEGER);
    private static final ObjectType TYPE_LUANUMBER = new ObjectType(STR_LUANUMBER);
    private static final ObjectType TYPE_LUABOOLEAN = new ObjectType(STR_LUABOOLEAN);
    private static final ObjectType TYPE_LUATABLE = new ObjectType(STR_LUATABLE);
    private static final ObjectType TYPE_BUFFER = new ObjectType(STR_BUFFER);
    private static final ObjectType TYPE_STRING = new ObjectType(STR_STRING);
    private static final ArrayType TYPE_LOCALUPVALUE = new ArrayType(TYPE_LUAVALUE, 1);
    private static final ArrayType TYPE_CHARARRAY = new ArrayType(Type.CHAR, 1);
    private static final ArrayType TYPE_STRINGARRAY = new ArrayType(TYPE_STRING, 1);
    private static final String STR_FUNCV = VarArgFunction.class.getName();
    private static final String STR_FUNC0 = ZeroArgFunction.class.getName();
    private static final String STR_FUNC1 = OneArgFunction.class.getName();
    private static final String STR_FUNC2 = TwoArgFunction.class.getName();
    private static final String STR_FUNC3 = ThreeArgFunction.class.getName();
    private static final Type[] ARG_TYPES_NONE = new Type[0];
    private static final Type[] ARG_TYPES_INT = new Type[]{Type.INT};
    private static final Type[] ARG_TYPES_DOUBLE = new Type[]{Type.DOUBLE};
    private static final Type[] ARG_TYPES_STRING = new Type[]{Type.STRING};
    private static final Type[] ARG_TYPES_CHARARRAY = new Type[]{TYPE_CHARARRAY};
    private static final Type[] ARG_TYPES_INT_LUAVALUE = new Type[]{Type.INT, TYPE_LUAVALUE};
    private static final Type[] ARG_TYPES_INT_VARARGS = new Type[]{Type.INT, TYPE_VARARGS};
    private static final Type[] ARG_TYPES_LUAVALUE_VARARGS = new Type[]{TYPE_LUAVALUE, TYPE_VARARGS};
    private static final Type[] ARG_TYPES_LUAVALUE_LUAVALUE_VARARGS = new Type[]{TYPE_LUAVALUE, TYPE_LUAVALUE, TYPE_VARARGS};
    private static final Type[] ARG_TYPES_LUAVALUEARRAY = new Type[]{new ArrayType(TYPE_LUAVALUE, 1)};
    private static final Type[] ARG_TYPES_LUAVALUEARRAY_VARARGS = new Type[]{new ArrayType(TYPE_LUAVALUE, 1), TYPE_VARARGS};
    private static final Type[] ARG_TYPES_LUAVALUE_LUAVALUE_LUAVALUE = new Type[]{TYPE_LUAVALUE, TYPE_LUAVALUE, TYPE_LUAVALUE};
    private static final Type[] ARG_TYPES_VARARGS = new Type[]{TYPE_VARARGS};
    private static final Type[] ARG_TYPES_LUAVALUE_LUAVALUE = new Type[]{TYPE_LUAVALUE, TYPE_LUAVALUE};
    private static final Type[] ARG_TYPES_INT_INT = new Type[]{Type.INT, Type.INT};
    private static final Type[] ARG_TYPES_LUAVALUE = new Type[]{TYPE_LUAVALUE};
    private static final Type[] ARG_TYPES_BUFFER = new Type[]{TYPE_BUFFER};
    private static final Type[] ARG_TYPES_STRINGARRAY = new Type[]{TYPE_STRINGARRAY};
    private static final Type[] ARG_TYPES_LUAVALUE_STRINGARRAY = new Type[]{TYPE_LUAVALUE, TYPE_STRINGARRAY};
    private static final String[] SUPER_NAME_N = new String[]{STR_FUNC0, STR_FUNC1, STR_FUNC2, STR_FUNC3, STR_FUNCV};
    private static final ObjectType[] RETURN_TYPE_N = new ObjectType[]{TYPE_LUAVALUE, TYPE_LUAVALUE, TYPE_LUAVALUE, TYPE_LUAVALUE, TYPE_VARARGS};
    private static final Type[][] ARG_TYPES_N = new Type[][]{ARG_TYPES_NONE, ARG_TYPES_LUAVALUE, ARG_TYPES_LUAVALUE_LUAVALUE, ARG_TYPES_LUAVALUE_LUAVALUE_LUAVALUE, ARG_TYPES_VARARGS};
    private static final String[][] ARG_NAMES_N = new String[][]{new String[0], {"arg"}, {"arg1", "arg2"}, {"arg1", "arg2", "arg3"}, {"args"}};
    private static final String[] METH_NAME_N = new String[]{"call", "call", "call", "call", "onInvoke"};
    private static final String PREFIX_CONSTANT = "k";
    private static final String PREFIX_UPVALUE = "u";
    private static final String PREFIX_PLAIN_SLOT = "s";
    private static final String PREFIX_UPVALUE_SLOT = "a";
    private static final String NAME_VARRESULT = "v";
    private final ProtoInfo pi;
    private final Prototype p;
    private final String classname;
    private final ClassGen cg;
    private final ConstantPoolGen cp;
    private final InstructionFactory factory;
    private final InstructionList init;
    private final InstructionList main;
    private final MethodGen mg;
    private int superclassType;
    private static int SUPERTYPE_VARARGS = 4;
    private final int[] targets;
    private final BranchInstruction[] branches;
    private final InstructionHandle[] branchDestHandles;
    private final InstructionHandle[] lastInstrHandles;
    private InstructionHandle beginningOfLuaInstruction;
    private LocalVariableGen varresult = null;
    private int prev_line = -1;
    private final Map<Integer, Integer> plainSlotVars = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> upvalueSlotVars = new HashMap<Integer, Integer>();
    private final Map<Integer, LocalVariableGen> localVarGenBySlot = new HashMap<Integer, LocalVariableGen>();
    private final Map<LuaValue, String> constants = new HashMap<LuaValue, String>();
    public static final int BRANCH_GOTO = 1;
    public static final int BRANCH_IFNE = 2;
    public static final int BRANCH_IFEQ = 3;

    public JavaBuilder(ProtoInfo pi, String classname, String filename) {
        this.pi = pi;
        this.p = pi.prototype;
        this.classname = classname;
        this.superclassType = this.p.numparams;
        if (this.p.is_vararg != 0 || this.superclassType >= SUPERTYPE_VARARGS) {
            this.superclassType = SUPERTYPE_VARARGS;
        }
        for (int inst : this.p.code) {
            int o = Lua.GET_OPCODE(inst);
            if (o != 30 && (o != 31 || Lua.GETARG_B(inst) >= 1 && Lua.GETARG_B(inst) <= 2)) continue;
            this.superclassType = SUPERTYPE_VARARGS;
            break;
        }
        this.cg = new ClassGen(classname, SUPER_NAME_N[this.superclassType], filename, 33, null);
        this.cp = this.cg.getConstantPool();
        this.factory = new InstructionFactory(this.cg);
        this.init = new InstructionList();
        this.main = new InstructionList();
        for (int i = 0; i < this.p.upvalues.length; ++i) {
            boolean isrw = pi.isReadWriteUpvalue(pi.upvals[i]);
            ReferenceType uptype = isrw ? TYPE_LOCALUPVALUE : TYPE_LUAVALUE;
            FieldGen fg = new FieldGen(0, uptype, JavaBuilder.upvalueName(i), this.cp);
            this.cg.addField(fg.getField());
        }
        this.mg = new MethodGen(17, RETURN_TYPE_N[this.superclassType], ARG_TYPES_N[this.superclassType], ARG_NAMES_N[this.superclassType], METH_NAME_N[this.superclassType], STR_LUAVALUE, this.main, this.cp);
        this.initializeSlots();
        int nc = this.p.code.length;
        this.targets = new int[nc];
        this.branches = new BranchInstruction[nc];
        this.branchDestHandles = new InstructionHandle[nc];
        this.lastInstrHandles = new InstructionHandle[nc];
    }

    public void initializeSlots() {
        int slot = 0;
        this.createUpvalues(-1, 0, this.p.maxstacksize);
        if (this.superclassType == SUPERTYPE_VARARGS) {
            for (slot = 0; slot < this.p.numparams; ++slot) {
                if (!this.pi.isInitialValueUsed(slot)) continue;
                this.append(new ALOAD(1));
                this.append(new PUSH(this.cp, slot + 1));
                this.append(this.factory.createInvoke(STR_VARARGS, "arg", TYPE_LUAVALUE, ARG_TYPES_INT, (short)182));
                this.storeLocal(-1, slot);
            }
            this.append(new ALOAD(1));
            this.append(new PUSH(this.cp, 1 + this.p.numparams));
            this.append(this.factory.createInvoke(STR_VARARGS, "subargs", TYPE_VARARGS, ARG_TYPES_INT, (short)182));
            this.append(new ASTORE(1));
        } else {
            for (slot = 0; slot < this.p.numparams; ++slot) {
                this.plainSlotVars.put(slot, 1 + slot);
                if (!this.pi.isUpvalueCreate(-1, slot)) continue;
                this.append(new ALOAD(1 + slot));
                this.storeLocal(-1, slot);
            }
        }
        while (slot < this.p.maxstacksize) {
            if (this.pi.isInitialValueUsed(slot)) {
                this.loadNil();
                this.storeLocal(-1, slot);
            }
            ++slot;
        }
    }

    public byte[] completeClass(boolean genmain) {
        MethodGen mg;
        if (!this.init.isEmpty()) {
            mg = new MethodGen(8, Type.VOID, ARG_TYPES_NONE, new String[0], "<clinit>", this.cg.getClassName(), this.init, this.cg.getConstantPool());
            this.init.append(InstructionConstants.RETURN);
            mg.setMaxStack();
            this.cg.addMethod(mg.getMethod());
            this.init.dispose();
        }
        this.cg.addEmptyConstructor(1);
        this.resolveBranches();
        this.mg.setMaxStack();
        this.cg.addMethod(this.mg.getMethod());
        this.main.dispose();
        if (this.p.upvalues.length == 1 && this.superclassType == SUPERTYPE_VARARGS) {
            mg = new MethodGen(17, Type.VOID, ARG_TYPES_LUAVALUE, new String[]{"env"}, "initupvalue1", STR_LUAVALUE, this.main, this.cp);
            boolean isrw = this.pi.isReadWriteUpvalue(this.pi.upvals[0]);
            this.append(InstructionConstants.THIS);
            this.append(new ALOAD(1));
            if (isrw) {
                this.append(this.factory.createInvoke(this.classname, "newupl", TYPE_LOCALUPVALUE, ARG_TYPES_LUAVALUE, (short)184));
                this.append(this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(0), TYPE_LOCALUPVALUE, (short)181));
            } else {
                this.append(this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(0), TYPE_LUAVALUE, (short)181));
            }
            this.append(InstructionConstants.RETURN);
            mg.setMaxStack();
            this.cg.addMethod(mg.getMethod());
            this.main.dispose();
        }
        if (genmain) {
            mg = new MethodGen(9, Type.VOID, ARG_TYPES_STRINGARRAY, new String[]{"arg"}, "main", this.classname, this.main, this.cp);
            this.append(this.factory.createNew(this.classname));
            this.append(InstructionConstants.DUP);
            this.append(this.factory.createInvoke(this.classname, "<init>", Type.VOID, ARG_TYPES_NONE, (short)183));
            this.append(new ALOAD(0));
            this.append(this.factory.createInvoke(STR_JSEPLATFORM, "luaMain", Type.VOID, ARG_TYPES_LUAVALUE_STRINGARRAY, (short)184));
            this.append(InstructionConstants.RETURN);
            mg.setMaxStack();
            this.cg.addMethod(mg.getMethod());
            this.main.dispose();
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.cg.getJavaClass().dump(baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException("JavaClass.dump() threw " + ioe);
        }
    }

    public void dup() {
        this.append(InstructionConstants.DUP);
    }

    public void pop() {
        this.append(InstructionConstants.POP);
    }

    public void loadNil() {
        this.append(this.factory.createFieldAccess(STR_LUAVALUE, "NIL", TYPE_LUAVALUE, (short)178));
    }

    public void loadNone() {
        this.append(this.factory.createFieldAccess(STR_LUAVALUE, "NONE", TYPE_LUAVALUE, (short)178));
    }

    public void loadBoolean(boolean b) {
        String field = b ? "TRUE" : "FALSE";
        this.append(this.factory.createFieldAccess(STR_LUAVALUE, field, TYPE_LUABOOLEAN, (short)178));
    }

    private int findSlot(int slot, Map<Integer, Integer> map, String prefix, Type type2) {
        Integer islot = slot;
        if (map.containsKey(islot)) {
            return map.get(islot);
        }
        String name = prefix + slot;
        LocalVariableGen local = this.mg.addLocalVariable(name, type2, null, null);
        int index = local.getIndex();
        map.put(islot, index);
        this.localVarGenBySlot.put(islot, local);
        return index;
    }

    private int findSlotIndex(int slot, boolean isupvalue) {
        return isupvalue ? this.findSlot(slot, this.upvalueSlotVars, PREFIX_UPVALUE_SLOT, TYPE_LOCALUPVALUE) : this.findSlot(slot, this.plainSlotVars, PREFIX_PLAIN_SLOT, TYPE_LUAVALUE);
    }

    public void loadLocal(int pc, int slot) {
        boolean isupval = this.pi.isUpvalueRefer(pc, slot);
        int index = this.findSlotIndex(slot, isupval);
        this.append(new ALOAD(index));
        if (isupval) {
            this.append(new PUSH(this.cp, 0));
            this.append(InstructionConstants.AALOAD);
        }
    }

    public void storeLocal(int pc, int slot) {
        boolean isupval = this.pi.isUpvalueAssign(pc, slot);
        int index = this.findSlotIndex(slot, isupval);
        if (isupval) {
            boolean isupcreate = this.pi.isUpvalueCreate(pc, slot);
            if (isupcreate) {
                this.append(this.factory.createInvoke(this.classname, "newupe", TYPE_LOCALUPVALUE, ARG_TYPES_NONE, (short)184));
                this.append(InstructionConstants.DUP);
                this.append(new ASTORE(index));
            } else {
                this.append(new ALOAD(index));
            }
            this.append(InstructionConstants.SWAP);
            this.append(new PUSH(this.cp, 0));
            this.append(InstructionConstants.SWAP);
            this.append(InstructionConstants.AASTORE);
        } else {
            this.append(new ASTORE(index));
        }
    }

    public void createUpvalues(int pc, int firstslot, int numslots) {
        for (int i = 0; i < numslots; ++i) {
            int slot = firstslot + i;
            boolean isupcreate = this.pi.isUpvalueCreate(pc, slot);
            if (!isupcreate) continue;
            int index = this.findSlotIndex(slot, true);
            this.append(this.factory.createInvoke(this.classname, "newupn", TYPE_LOCALUPVALUE, ARG_TYPES_NONE, (short)184));
            this.append(new ASTORE(index));
        }
    }

    public void convertToUpvalue(int pc, int slot) {
        boolean isupassign = this.pi.isUpvalueAssign(pc, slot);
        if (isupassign) {
            int index = this.findSlotIndex(slot, false);
            this.append(new ALOAD(index));
            this.append(this.factory.createInvoke(this.classname, "newupl", TYPE_LOCALUPVALUE, ARG_TYPES_LUAVALUE, (short)184));
            int upindex = this.findSlotIndex(slot, true);
            this.append(new ASTORE(upindex));
        }
    }

    private static String upvalueName(int upindex) {
        return PREFIX_UPVALUE + upindex;
    }

    public void loadUpvalue(int upindex) {
        boolean isrw = this.pi.isReadWriteUpvalue(this.pi.upvals[upindex]);
        this.append(InstructionConstants.THIS);
        if (isrw) {
            this.append(this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(upindex), TYPE_LOCALUPVALUE, (short)180));
            this.append(new PUSH(this.cp, 0));
            this.append(InstructionConstants.AALOAD);
        } else {
            this.append(this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(upindex), TYPE_LUAVALUE, (short)180));
        }
    }

    public void storeUpvalue(int pc, int upindex, int slot) {
        boolean isrw = this.pi.isReadWriteUpvalue(this.pi.upvals[upindex]);
        this.append(InstructionConstants.THIS);
        if (isrw) {
            this.append(this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(upindex), TYPE_LOCALUPVALUE, (short)180));
            this.append(new PUSH(this.cp, 0));
            this.loadLocal(pc, slot);
            this.append(InstructionConstants.AASTORE);
        } else {
            this.loadLocal(pc, slot);
            this.append(this.factory.createFieldAccess(this.classname, JavaBuilder.upvalueName(upindex), TYPE_LUAVALUE, (short)181));
        }
    }

    public void newTable(int b, int c) {
        this.append(new PUSH(this.cp, b));
        this.append(new PUSH(this.cp, c));
        this.append(this.factory.createInvoke(STR_LUAVALUE, "tableOf", TYPE_LUATABLE, ARG_TYPES_INT_INT, (short)184));
    }

    public void loadVarargs() {
        this.append(new ALOAD(1));
    }

    public void loadVarargs(int argindex) {
        this.loadVarargs();
        this.arg(argindex);
    }

    public void arg(int argindex) {
        if (argindex == 1) {
            this.append(this.factory.createInvoke(STR_VARARGS, "arg1", TYPE_LUAVALUE, ARG_TYPES_NONE, (short)182));
        } else {
            this.append(new PUSH(this.cp, argindex));
            this.append(this.factory.createInvoke(STR_VARARGS, "arg", TYPE_LUAVALUE, ARG_TYPES_INT, (short)182));
        }
    }

    private int getVarresultIndex() {
        if (this.varresult == null) {
            this.varresult = this.mg.addLocalVariable(NAME_VARRESULT, TYPE_VARARGS, null, null);
        }
        return this.varresult.getIndex();
    }

    public void loadVarresult() {
        this.append(new ALOAD(this.getVarresultIndex()));
    }

    public void storeVarresult() {
        this.append(new ASTORE(this.getVarresultIndex()));
    }

    public void subargs(int firstarg) {
        this.append(new PUSH(this.cp, firstarg));
        this.append(this.factory.createInvoke(STR_VARARGS, "subargs", TYPE_VARARGS, ARG_TYPES_INT, (short)182));
    }

    public void getTable() {
        this.append(this.factory.createInvoke(STR_LUAVALUE, "get", TYPE_LUAVALUE, ARG_TYPES_LUAVALUE, (short)182));
    }

    public void setTable() {
        this.append(this.factory.createInvoke(STR_LUAVALUE, "set", Type.VOID, ARG_TYPES_LUAVALUE_LUAVALUE, (short)182));
    }

    public void unaryop(int o) {
        this.append(this.factory.createInvoke(STR_LUAVALUE, switch (o) {
            default -> "neg";
            case 20 -> "not";
            case 21 -> "len";
        }, TYPE_LUAVALUE, Type.NO_ARGS, (short)182));
    }

    public void binaryop(int o) {
        this.append(this.factory.createInvoke(STR_LUAVALUE, switch (o) {
            default -> "add";
            case 14 -> "sub";
            case 15 -> "mul";
            case 16 -> "div";
            case 17 -> "mod";
            case 18 -> "pow";
        }, TYPE_LUAVALUE, ARG_TYPES_LUAVALUE, (short)182));
    }

    public void compareop(int o) {
        this.append(this.factory.createInvoke(STR_LUAVALUE, switch (o) {
            default -> "eq_b";
            case 25 -> "lt_b";
            case 26 -> "lteq_b";
        }, Type.BOOLEAN, ARG_TYPES_LUAVALUE, (short)182));
    }

    public void areturn() {
        this.append(InstructionConstants.ARETURN);
    }

    public void toBoolean() {
        this.append(this.factory.createInvoke(STR_LUAVALUE, "toboolean", Type.BOOLEAN, Type.NO_ARGS, (short)182));
    }

    public void tostring() {
        this.append(this.factory.createInvoke(STR_BUFFER, "tostring", TYPE_LUASTRING, Type.NO_ARGS, (short)182));
    }

    public void isNil() {
        this.append(this.factory.createInvoke(STR_LUAVALUE, "isnil", Type.BOOLEAN, Type.NO_ARGS, (short)182));
    }

    public void testForLoop() {
        this.append(this.factory.createInvoke(STR_LUAVALUE, "testfor_b", Type.BOOLEAN, ARG_TYPES_LUAVALUE_LUAVALUE, (short)182));
    }

    public void loadArrayArgs(int pc, int firstslot, int nargs) {
        this.append(new PUSH(this.cp, nargs));
        this.append(new ANEWARRAY(this.cp.addClass(STR_LUAVALUE)));
        for (int i = 0; i < nargs; ++i) {
            this.append(InstructionConstants.DUP);
            this.append(new PUSH(this.cp, i));
            this.loadLocal(pc, firstslot++);
            this.append(new AASTORE());
        }
    }

    public void newVarargs(int pc, int firstslot, int nargs) {
        switch (nargs) {
            case 0: {
                this.loadNone();
                break;
            }
            case 1: {
                this.loadLocal(pc, firstslot);
                break;
            }
            case 2: {
                this.loadLocal(pc, firstslot);
                this.loadLocal(pc, firstslot + 1);
                this.append(this.factory.createInvoke(STR_LUAVALUE, "varargsOf", TYPE_VARARGS, ARG_TYPES_LUAVALUE_VARARGS, (short)184));
                break;
            }
            case 3: {
                this.loadLocal(pc, firstslot);
                this.loadLocal(pc, firstslot + 1);
                this.loadLocal(pc, firstslot + 2);
                this.append(this.factory.createInvoke(STR_LUAVALUE, "varargsOf", TYPE_VARARGS, ARG_TYPES_LUAVALUE_LUAVALUE_VARARGS, (short)184));
                break;
            }
            default: {
                this.loadArrayArgs(pc, firstslot, nargs);
                this.append(this.factory.createInvoke(STR_LUAVALUE, "varargsOf", TYPE_VARARGS, ARG_TYPES_LUAVALUEARRAY, (short)184));
            }
        }
    }

    public void newVarargsVarresult(int pc, int firstslot, int nslots) {
        this.loadArrayArgs(pc, firstslot, nslots);
        this.loadVarresult();
        this.append(this.factory.createInvoke(STR_LUAVALUE, "varargsOf", TYPE_VARARGS, ARG_TYPES_LUAVALUEARRAY_VARARGS, (short)184));
    }

    public void call(int nargs) {
        switch (nargs) {
            case 0: {
                this.append(this.factory.createInvoke(STR_LUAVALUE, "call", TYPE_LUAVALUE, ARG_TYPES_NONE, (short)182));
                break;
            }
            case 1: {
                this.append(this.factory.createInvoke(STR_LUAVALUE, "call", TYPE_LUAVALUE, ARG_TYPES_LUAVALUE, (short)182));
                break;
            }
            case 2: {
                this.append(this.factory.createInvoke(STR_LUAVALUE, "call", TYPE_LUAVALUE, ARG_TYPES_LUAVALUE_LUAVALUE, (short)182));
                break;
            }
            case 3: {
                this.append(this.factory.createInvoke(STR_LUAVALUE, "call", TYPE_LUAVALUE, ARG_TYPES_LUAVALUE_LUAVALUE_LUAVALUE, (short)182));
                break;
            }
            default: {
                throw new IllegalArgumentException("can't call with " + nargs + " args");
            }
        }
    }

    public void newTailcallVarargs() {
        this.append(this.factory.createInvoke(STR_LUAVALUE, "tailcallOf", TYPE_VARARGS, ARG_TYPES_LUAVALUE_VARARGS, (short)184));
    }

    public void invoke(int nargs) {
        switch (nargs) {
            case -1: {
                this.append(this.factory.createInvoke(STR_LUAVALUE, "invoke", TYPE_VARARGS, ARG_TYPES_VARARGS, (short)182));
                break;
            }
            case 0: {
                this.append(this.factory.createInvoke(STR_LUAVALUE, "invoke", TYPE_VARARGS, ARG_TYPES_NONE, (short)182));
                break;
            }
            case 1: {
                this.append(this.factory.createInvoke(STR_LUAVALUE, "invoke", TYPE_VARARGS, ARG_TYPES_VARARGS, (short)182));
                break;
            }
            case 2: {
                this.append(this.factory.createInvoke(STR_LUAVALUE, "invoke", TYPE_VARARGS, ARG_TYPES_LUAVALUE_VARARGS, (short)182));
                break;
            }
            case 3: {
                this.append(this.factory.createInvoke(STR_LUAVALUE, "invoke", TYPE_VARARGS, ARG_TYPES_LUAVALUE_LUAVALUE_VARARGS, (short)182));
                break;
            }
            default: {
                throw new IllegalArgumentException("can't invoke with " + nargs + " args");
            }
        }
    }

    public void closureCreate(String protoname) {
        this.append(this.factory.createNew(new ObjectType(protoname)));
        this.append(InstructionConstants.DUP);
        this.append(this.factory.createInvoke(protoname, "<init>", Type.VOID, Type.NO_ARGS, (short)183));
    }

    public void closureInitUpvalueFromUpvalue(String protoname, int newup, int upindex) {
        boolean isrw = this.pi.isReadWriteUpvalue(this.pi.upvals[upindex]);
        ReferenceType uptype = isrw ? TYPE_LOCALUPVALUE : TYPE_LUAVALUE;
        String srcname = JavaBuilder.upvalueName(upindex);
        String destname = JavaBuilder.upvalueName(newup);
        this.append(InstructionConstants.THIS);
        this.append(this.factory.createFieldAccess(this.classname, srcname, uptype, (short)180));
        this.append(this.factory.createFieldAccess(protoname, destname, uptype, (short)181));
    }

    public void closureInitUpvalueFromLocal(String protoname, int newup, int pc, int srcslot) {
        boolean isrw = this.pi.isReadWriteUpvalue(this.pi.vars[srcslot][pc].upvalue);
        ReferenceType uptype = isrw ? TYPE_LOCALUPVALUE : TYPE_LUAVALUE;
        String destname = JavaBuilder.upvalueName(newup);
        int index = this.findSlotIndex(srcslot, isrw);
        this.append(new ALOAD(index));
        this.append(this.factory.createFieldAccess(protoname, destname, uptype, (short)181));
    }

    public void loadConstant(LuaValue value) {
        switch (value.type()) {
            case 0: {
                this.loadNil();
                break;
            }
            case 1: {
                this.loadBoolean(value.toboolean());
                break;
            }
            case 3: 
            case 4: {
                String name = this.constants.get(value);
                if (name == null) {
                    name = value.type() == 3 ? (value.isinttype() ? this.createLuaIntegerField(value.checkint()) : this.createLuaDoubleField(value.checkdouble())) : this.createLuaStringField(value.checkstring());
                    this.constants.put(value, name);
                }
                this.append(this.factory.createGetStatic(this.classname, name, TYPE_LUAVALUE));
                break;
            }
            default: {
                throw new IllegalArgumentException("bad constant type: " + value.type());
            }
        }
    }

    private String createLuaIntegerField(int value) {
        String name = PREFIX_CONSTANT + this.constants.size();
        FieldGen fg = new FieldGen(24, TYPE_LUAVALUE, name, this.cp);
        this.cg.addField(fg.getField());
        this.init.append(new PUSH(this.cp, value));
        this.init.append(this.factory.createInvoke(STR_LUAVALUE, "valueOf", TYPE_LUAINTEGER, ARG_TYPES_INT, (short)184));
        this.init.append(this.factory.createPutStatic(this.classname, name, TYPE_LUAVALUE));
        return name;
    }

    private String createLuaDoubleField(double value) {
        String name = PREFIX_CONSTANT + this.constants.size();
        FieldGen fg = new FieldGen(24, TYPE_LUAVALUE, name, this.cp);
        this.cg.addField(fg.getField());
        this.init.append(new PUSH(this.cp, value));
        this.init.append(this.factory.createInvoke(STR_LUAVALUE, "valueOf", TYPE_LUANUMBER, ARG_TYPES_DOUBLE, (short)184));
        this.init.append(this.factory.createPutStatic(this.classname, name, TYPE_LUAVALUE));
        return name;
    }

    private String createLuaStringField(LuaString value) {
        String name = PREFIX_CONSTANT + this.constants.size();
        FieldGen fg = new FieldGen(24, TYPE_LUAVALUE, name, this.cp);
        this.cg.addField(fg.getField());
        LuaString ls = value.checkstring();
        if (ls.isValidUtf8()) {
            this.init.append(new PUSH(this.cp, value.tojstring()));
            this.init.append(this.factory.createInvoke(STR_LUASTRING, "valueOf", TYPE_LUASTRING, ARG_TYPES_STRING, (short)184));
        } else {
            char[] c = new char[ls.m_length];
            for (int j = 0; j < ls.m_length; ++j) {
                c[j] = (char)(0xFF & ls.m_bytes[ls.m_offset + j]);
            }
            this.init.append(new PUSH(this.cp, new String(c)));
            this.init.append(this.factory.createInvoke(STR_STRING, "toCharArray", TYPE_CHARARRAY, Type.NO_ARGS, (short)182));
            this.init.append(this.factory.createInvoke(STR_LUASTRING, "valueOf", TYPE_LUASTRING, ARG_TYPES_CHARARRAY, (short)184));
        }
        this.init.append(this.factory.createPutStatic(this.classname, name, TYPE_LUAVALUE));
        return name;
    }

    public void addBranch(int pc, int branchType, int targetpc) {
        switch (branchType) {
            default: {
                this.branches[pc] = new GOTO(null);
                break;
            }
            case 2: {
                this.branches[pc] = new IFNE(null);
                break;
            }
            case 3: {
                this.branches[pc] = new IFEQ(null);
            }
        }
        this.targets[pc] = targetpc;
        this.append(this.branches[pc]);
    }

    private void append(Instruction i) {
        this.conditionalSetBeginningOfLua(this.main.append(i));
    }

    private void append(CompoundInstruction i) {
        this.conditionalSetBeginningOfLua(this.main.append(i));
    }

    private void append(BranchInstruction i) {
        this.conditionalSetBeginningOfLua(this.main.append(i));
    }

    private void conditionalSetBeginningOfLua(InstructionHandle ih) {
        if (this.beginningOfLuaInstruction == null) {
            this.beginningOfLuaInstruction = ih;
        }
    }

    public void onEndOfLuaInstruction(int pc, int line) {
        this.branchDestHandles[pc] = this.beginningOfLuaInstruction;
        this.lastInstrHandles[pc] = this.main.getEnd();
        if (line != this.prev_line) {
            this.prev_line = line;
            this.mg.addLineNumber(this.beginningOfLuaInstruction, this.prev_line);
        }
        this.beginningOfLuaInstruction = null;
    }

    public void setVarStartEnd(int slot, int start_pc, int end_pc, String name) {
        Integer islot = slot;
        if (this.localVarGenBySlot.containsKey(islot)) {
            name = name.replaceAll("[^a-zA-Z0-9]", "_");
            LocalVariableGen l = this.localVarGenBySlot.get(islot);
            l.setEnd(this.lastInstrHandles[end_pc - 1]);
            if (start_pc > 1) {
                l.setStart(this.lastInstrHandles[start_pc - 2]);
            }
            l.setName(name);
        }
    }

    private void resolveBranches() {
        int nc = this.p.code.length;
        for (int pc = 0; pc < nc; ++pc) {
            int t2;
            if (this.branches[pc] == null) continue;
            for (t2 = this.targets[pc]; t2 < this.branchDestHandles.length && this.branchDestHandles[t2] == null; ++t2) {
            }
            if (t2 >= this.branchDestHandles.length) {
                throw new IllegalArgumentException("no target at or after " + this.targets[pc] + " op=" + Lua.GET_OPCODE(this.p.code[this.targets[pc]]));
            }
            this.branches[pc].setTarget(this.branchDestHandles[t2]);
        }
    }

    public void setlistStack(int pc, int a0, int index0, int nvals) {
        for (int i = 0; i < nvals; ++i) {
            this.dup();
            this.append(new PUSH(this.cp, index0 + i));
            this.loadLocal(pc, a0 + i);
            this.append(this.factory.createInvoke(STR_LUAVALUE, "rawset", Type.VOID, ARG_TYPES_INT_LUAVALUE, (short)182));
        }
    }

    public void setlistVarargs(int index0, int vresultbase) {
        this.append(new PUSH(this.cp, index0));
        this.loadVarresult();
        this.append(this.factory.createInvoke(STR_LUAVALUE, "rawsetlist", Type.VOID, ARG_TYPES_INT_VARARGS, (short)182));
    }

    public void concatvalue() {
        this.append(this.factory.createInvoke(STR_LUAVALUE, "concat", TYPE_LUAVALUE, ARG_TYPES_LUAVALUE, (short)182));
    }

    public void concatbuffer() {
        this.append(this.factory.createInvoke(STR_LUAVALUE, "concat", TYPE_BUFFER, ARG_TYPES_BUFFER, (short)182));
    }

    public void tobuffer() {
        this.append(this.factory.createInvoke(STR_LUAVALUE, "buffer", TYPE_BUFFER, Type.NO_ARGS, (short)182));
    }

    public void tovalue() {
        this.append(this.factory.createInvoke(STR_BUFFER, "value", TYPE_LUAVALUE, Type.NO_ARGS, (short)182));
    }

    public void closeUpvalue(int pc, int upindex) {
    }
}

