/*
 * Decompiled with CFR 0.152.
 */
package imgui.extension.imguizmo;

import imgui.ImDrawList;
import imgui.ImGui;

public final class ImGuizmo {
    private static final float[] MATRICES = new float[64];

    private ImGuizmo() {
    }

    private static native void nEnabled(boolean var0);

    public static void setEnabled(boolean isEnabled) {
        ImGuizmo.nEnabled(isEnabled);
    }

    private static native boolean nIsUsing();

    public static boolean isUsing() {
        return ImGuizmo.nIsUsing();
    }

    private static native boolean nIsOver();

    public static boolean isOver() {
        return ImGuizmo.nIsOver();
    }

    private static native void nSetDrawList(long var0);

    public static void setDrawList(ImDrawList drawList) {
        ImGuizmo.nSetDrawList(drawList.ptr);
    }

    public static void setDrawList() {
        ImGuizmo.setDrawList(ImGui.getWindowDrawList());
    }

    public static native void beginFrame();

    private static native void nDecomposeMatrixToComponents(float[] var0, float[] var1, float[] var2, float[] var3);

    public static void decomposeMatrixToComponents(float[] modelMatrix, float[] translation, float[] rotation, float[] scale) {
        ImGuizmo.nDecomposeMatrixToComponents(modelMatrix, translation, rotation, scale);
    }

    private static native void nRecomposeMatrixFromComponents(float[] var0, float[] var1, float[] var2, float[] var3);

    public static void recomposeMatrixFromComponents(float[] modelMatrix, float[] translation, float[] rotation, float[] scale) {
        ImGuizmo.nRecomposeMatrixFromComponents(modelMatrix, translation, rotation, scale);
    }

    public static native void nSetRect(float var0, float var1, float var2, float var3);

    public static void setRect(float x, float y, float width, float height) {
        ImGuizmo.nSetRect(x, y, width, height);
    }

    private static native void nSetOrthographic(boolean var0);

    public static void setOrthographic(boolean ortho) {
        ImGuizmo.nSetOrthographic(ortho);
    }

    private static native void nDrawCubes(float[] var0, float[] var1, float[] var2, int var3);

    public static void drawCubes(float[] view, float[] projection, float[] ... cubeMatrices) {
        if (cubeMatrices.length > 4) {
            throw new IllegalArgumentException("Drawing cubes with ImGuizmo only supports up to 4 cubes because it should only be used for debugging purposes");
        }
        int cubeMatricesLength = cubeMatrices.length;
        for (int i = 0; i < cubeMatricesLength; ++i) {
            float[] cubeMatrix = cubeMatrices[i];
            System.arraycopy(cubeMatrix, 0, MATRICES, i * cubeMatrix.length, cubeMatrix.length);
        }
        ImGuizmo.nDrawCubes(view, projection, MATRICES, cubeMatrices.length);
    }

    private static native void nDrawGrid(float[] var0, float[] var1, float[] var2, int var3);

    public static void drawGrid(float[] view, float[] projection, float[] matrix, int gridSize) {
        ImGuizmo.nDrawGrid(view, projection, matrix, gridSize);
    }

    private static native void nManipulate(float[] var0, float[] var1, int var2, int var3, float[] var4);

    private static native void nManipulate(float[] var0, float[] var1, int var2, int var3, float[] var4, float[] var5);

    private static native void nManipulate(float[] var0, float[] var1, int var2, int var3, float[] var4, float[] var5, float[] var6);

    private static native void nManipulate(float[] var0, float[] var1, int var2, int var3, float[] var4, float[] var5, float[] var6, float[] var7);

    private static native void nManipulate(float[] var0, float[] var1, int var2, int var3, float[] var4, float[] var5, float[] var6, float[] var7, float[] var8);

    public static void manipulate(float[] view, float[] projection, float[] modelMatrix, int operation, int mode) {
        ImGuizmo.nManipulate(view, projection, operation, mode, modelMatrix);
    }

    public static void manipulate(float[] view, float[] projection, float[] modelMatrix, int operation, int mode, float[] snap) {
        ImGuizmo.nManipulate(view, projection, operation, mode, modelMatrix, snap);
    }

    public static void manipulate(float[] view, float[] projection, float[] modelMatrix, int operation, int mode, float[] snap, float[] bounds) {
        ImGuizmo.nManipulate(view, projection, operation, mode, modelMatrix, snap, bounds);
    }

    public static void manipulate(float[] view, float[] projection, float[] modelMatrix, int operation, int mode, float[] snap, float[] bounds, float[] boundsSnap) {
        ImGuizmo.nManipulate(view, projection, operation, mode, modelMatrix, snap, bounds, boundsSnap);
    }

    public static void manipulate(float[] view, float[] projection, float[] modelMatrix, float[] deltaMatrix, int operation, int mode, float[] snap, float[] bounds, float[] boundsSnap) {
        ImGuizmo.nManipulate(view, projection, operation, mode, modelMatrix, deltaMatrix, snap, bounds, boundsSnap);
    }

    private static native void nViewManipulate(float[] var0, float var1, float[] var2, float[] var3, int var4);

    public static void viewManipulate(float[] view, float length, float[] position, float[] size, int color) {
        ImGuizmo.nViewManipulate(view, length, position, size, color);
    }

    private static native void nSetId(int var0);

    public static void setId(int id) {
        ImGuizmo.nSetId(id);
    }

    private static native boolean nIsOver(int var0);

    public static boolean isOver(int operation) {
        return ImGuizmo.nIsOver(operation);
    }

    private static native void nSetGizmoSizeClipSpace(float var0);

    private static native void nAllowAxisFlip(boolean var0);

    public static void setAllowAxisFlip(boolean value) {
        ImGuizmo.nAllowAxisFlip(value);
    }
}

