/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.world_properties.server;

import com.moulberry.axiom.packets.AxiomClientboundRegisterWorldProperties;
import com.moulberry.axiom.world_properties.AxiomGameRules;
import com.moulberry.axiom.world_properties.DefaultServerWorldProperties;
import com.moulberry.axiom.world_properties.WorldPropertyCategory;
import com.moulberry.axiom.world_properties.WorldPropertyWidgetType;
import com.moulberry.axiom.world_properties.server.ServerWorldProperty;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1928;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3902;

public class ServerWorldPropertiesRegistry {
    public final LinkedHashMap<WorldPropertyCategory, List<ServerWorldProperty<?>>> propertyList = new LinkedHashMap();
    public final Map<class_2960, ServerWorldProperty<?>> propertyMap = new HashMap();

    public ServerWorldPropertiesRegistry(class_3218 serverLevel) {
        this.registerDefault(serverLevel);
    }

    public void clear() {
        this.propertyMap.clear();
        this.propertyList.clear();
    }

    public void addCategory(WorldPropertyCategory category, List<ServerWorldProperty<?>> properties) {
        this.propertyList.put(category, properties);
        for (ServerWorldProperty<?> property : properties) {
            class_2960 id = property.getId();
            if (this.propertyMap.containsKey(id)) {
                throw new RuntimeException("Duplicate property: " + String.valueOf(id));
            }
            this.propertyMap.put(id, property);
        }
    }

    public void registerFor(class_3222 serverPlayer) {
        new AxiomClientboundRegisterWorldProperties(this.propertyList).send(serverPlayer);
    }

    public void registerDefault(class_3218 serverLevel) {
        class_1928 gameRules = serverLevel.method_8450();
        WorldPropertyCategory timeCategory = new WorldPropertyCategory("axiom.editorui.window.world_properties.time", true);
        ServerWorldProperty<class_3902> time = new ServerWorldProperty<class_3902>(new class_2960("axiom:time"), "axiom.editorui.window.world_properties.time", true, WorldPropertyWidgetType.TIME, class_3902.field_17274, unit -> false);
        this.addCategory(timeCategory, List.of(time));
        WorldPropertyCategory weatherCategory = new WorldPropertyCategory("axiom.editorui.window.world_properties.weather", true);
        ServerWorldProperty<Boolean> pauseWeather = new ServerWorldProperty<Boolean>(DefaultServerWorldProperties.PAUSE_WEATHER, "axiom.editorui.window.world_properties.pause_weather", true, WorldPropertyWidgetType.CHECKBOX, !((class_1928.class_4310)gameRules.method_20746(class_1928.field_19406)).method_20753(), bool -> {
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19406)).method_20758(bool == false, serverLevel.method_8503());
            return false;
        });
        ServerWorldProperty<Integer> weatherType = new ServerWorldProperty<Integer>(DefaultServerWorldProperties.WEATHER_TYPE, "axiom.editorui.window.world_properties.clear_weather", true, new WorldPropertyWidgetType.ButtonArray(List.of("axiom.editorui.window.world_properties.rain_weather", "axiom.editorui.window.world_properties.thunder_weather")), 0, index -> {
            if (index == 0) {
                serverLevel.method_27910(class_3218.field_41749.method_35008(serverLevel.field_9229), 0, false, false);
            } else if (index == 1) {
                serverLevel.method_27910(0, class_3218.field_41750.method_35008(serverLevel.field_9229), true, false);
            } else if (index == 2) {
                serverLevel.method_27910(0, class_3218.field_41751.method_35008(serverLevel.field_9229), true, true);
            }
            return false;
        });
        this.addCategory(weatherCategory, List.of(pauseWeather, weatherType));
        WorldPropertyCategory playerCategory = new WorldPropertyCategory("axiom.editorui.window.world_properties.player", true);
        ServerWorldProperty<Boolean> playerInvulnerability = new ServerWorldProperty<Boolean>(DefaultServerWorldProperties.PLAYER_INVULNERABILITY, "axiom.editorui.window.world_properties.player_invulnerability", true, WorldPropertyWidgetType.CHECKBOX, ((class_1928.class_4310)gameRules.method_20746(AxiomGameRules.RULE_PLAYERINVULNERABILITY)).method_20753(), bool -> {
            ((class_1928.class_4310)gameRules.method_20746(AxiomGameRules.RULE_PLAYERINVULNERABILITY)).method_20758(bool.booleanValue(), serverLevel.method_8503());
            return false;
        });
        ServerWorldProperty<Boolean> trampleFarmland = new ServerWorldProperty<Boolean>(DefaultServerWorldProperties.TRAMPLE_FARMLAND, "axiom.editorui.window.world_properties.trample_farmland", true, WorldPropertyWidgetType.CHECKBOX, ((class_1928.class_4310)gameRules.method_20746(AxiomGameRules.RULE_DOTRAMPLEFARMLAND)).method_20753(), bool -> {
            ((class_1928.class_4310)gameRules.method_20746(AxiomGameRules.RULE_DOTRAMPLEFARMLAND)).method_20758(bool.booleanValue(), serverLevel.method_8503());
            return false;
        });
        ServerWorldProperty<Boolean> mobSpawning = new ServerWorldProperty<Boolean>(DefaultServerWorldProperties.MOB_SPAWNING, "axiom.editorui.window.world_properties.mob_spawning", true, WorldPropertyWidgetType.CHECKBOX, ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19390)).method_20753(), bool -> {
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19390)).method_20758(bool.booleanValue(), serverLevel.method_8503());
            return false;
        });
        this.addCategory(playerCategory, List.of(playerInvulnerability, trampleFarmland, mobSpawning));
        WorldPropertyCategory blocksCategory = new WorldPropertyCategory("axiom.editorui.window.world_properties.blocks", true);
        ServerWorldProperty<Boolean> blockDrops = new ServerWorldProperty<Boolean>(DefaultServerWorldProperties.BLOCK_DROPS, "axiom.editorui.window.world_properties.block_drops", true, WorldPropertyWidgetType.CHECKBOX, ((class_1928.class_4310)gameRules.method_20746(AxiomGameRules.RULE_DOBLOCKDROPS)).method_20753(), bool -> {
            ((class_1928.class_4310)gameRules.method_20746(AxiomGameRules.RULE_DOBLOCKDROPS)).method_20758(bool.booleanValue(), serverLevel.method_8503());
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19392)).method_20758(bool.booleanValue(), serverLevel.method_8503());
            return false;
        });
        ServerWorldProperty<Boolean> blockGravity = new ServerWorldProperty<Boolean>(DefaultServerWorldProperties.BLOCK_GRAVITY, "axiom.editorui.window.world_properties.block_gravity", true, WorldPropertyWidgetType.CHECKBOX, ((class_1928.class_4310)gameRules.method_20746(AxiomGameRules.RULE_DOBLOCKGRAVITY)).method_20753(), bool -> {
            ((class_1928.class_4310)gameRules.method_20746(AxiomGameRules.RULE_DOBLOCKGRAVITY)).method_20758(bool.booleanValue(), serverLevel.method_8503());
            return false;
        });
        ServerWorldProperty<Boolean> fireTick = new ServerWorldProperty<Boolean>(DefaultServerWorldProperties.FIRE_TICK, "axiom.editorui.window.world_properties.fire_tick", true, WorldPropertyWidgetType.CHECKBOX, gameRules.method_8355(class_1928.field_19387), bool -> {
            ((class_1928.class_4310)gameRules.method_20746(class_1928.field_19387)).method_20758(bool.booleanValue(), serverLevel.method_8503());
            return false;
        });
        ServerWorldProperty<Integer> randomTickSpeed = new ServerWorldProperty<Integer>(DefaultServerWorldProperties.RANDOM_TICK_SPEED, "axiom.editorui.window.world_properties.random_tick_speed", true, new WorldPropertyWidgetType.Slider(0, 50), ((class_1928.class_4312)gameRules.method_20746(class_1928.field_19399)).method_20763(), integer -> {
            ((class_1928.class_4312)gameRules.method_20746(class_1928.field_19399)).method_35236(integer.intValue(), serverLevel.method_8503());
            return false;
        });
        this.addCategory(blocksCategory, List.of(blockDrops, blockGravity, fireTick, randomTickSpeed));
    }
}

