/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.painter;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.block_maps.FamilyMap;
import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.brush_shapes.SinglePointBrushShape;
import com.moulberry.axiom.clipboard.Clipboard;
import com.moulberry.axiom.clipboard.ClipboardObject;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.custom_blocks.ServerCustomBlocks;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.widgets.BrushWidget;
import com.moulberry.axiom.editor.widgets.PresetWidget;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.mask.MaskManager;
import com.moulberry.axiom.noise.WhiteNoise;
import com.moulberry.axiom.pather.async.AsyncToolPathProvider;
import com.moulberry.axiom.pather.async.AsyncToolPather;
import com.moulberry.axiom.pather.async.AsyncToolPatherMinSDF;
import com.moulberry.axiom.pather.async.AsyncToolPatherUnique;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiom.utils.BezierOperator;
import com.moulberry.axiom.utils.BlockManipulation;
import com.moulberry.axiom.utils.BlockWithFloat;
import com.moulberry.axiom.utils.NbtHelper;
import com.moulberry.axiom.utils.RegionHelper;
import imgui.ImGui;
import imgui.type.ImString;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.DoubleUnaryOperator;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class PainterTool
implements Tool {
    private final ChunkedBlockRegion chunkedBlockRegion = new ChunkedBlockRegion();
    private final ChunkedBooleanRegion airRegion = new ChunkedBooleanRegion();
    private boolean paintingAir = false;
    private boolean usingTool = false;
    private AsyncToolPathProvider pathProvider = null;
    private final BrushWidget brushWidget = new BrushWidget();
    private boolean maskSurface = true;
    private boolean copyProperties = false;
    private boolean typeReplace = false;
    private final int[] mode = new int[]{0};
    private Position2FloatMap minDistances = new Position2FloatMap(Float.MAX_VALUE);
    private final int[] gradientInterpolation = new int[]{0};
    private final List<BlockWithFloat> blockPercentages = new ArrayList<BlockWithFloat>();
    private final SelectBlockWidget selectBlockWidget = new SelectBlockWidget(false);
    private final ImString noiseSeed = new ImString();
    private final int defaultRandomValue = ThreadLocalRandom.current().nextInt();
    private boolean softEdge = false;
    private boolean mergeStrokes = true;
    private final float[] minimumRadius = new float[]{0.0f};
    private final PresetWidget presetWidget = new PresetWidget(this, "painter");

    public PainterTool() {
        this.blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_10340.method_9564(), new float[]{50.0f}, null));
        this.blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_10474.method_9564(), new float[]{50.0f}, null));
        this.noiseSeed.set(String.valueOf(this.defaultRandomValue), false);
    }

    @Override
    public void reset() {
        this.partialReset();
        this.minDistances.clear();
    }

    private void partialReset() {
        this.usingTool = false;
        this.chunkedBlockRegion.clear();
        this.airRegion.clear();
        if (this.pathProvider != null) {
            this.pathProvider.close();
            this.pathProvider = null;
        }
    }

    @Override
    public UserAction.ActionResult callAction(UserAction action, Object object) {
        switch (action) {
            case RIGHT_MOUSE: {
                this.partialReset();
                BrushShape brushShape = this.brushWidget.getBrushShape();
                AsyncToolPather pather = this.createToolPather(brushShape);
                if (pather != null) {
                    this.usingTool = true;
                    this.pathProvider = new AsyncToolPathProvider(pather).includeNonSolid(false);
                }
                return UserAction.ActionResult.USED_STOP;
            }
            case ESCAPE: {
                if (!this.usingTool) break;
                this.partialReset();
                return UserAction.ActionResult.USED_STOP;
            }
        }
        return UserAction.ActionResult.NOT_HANDLED;
    }

    @Override
    public void afterBlockBufferUndo() {
        this.reset();
    }

    @Override
    public void afterBlockBufferRedo() {
        this.reset();
    }

    @Override
    public void render(class_4184 camera, float tickDelta, long time, class_4587 matrices, Matrix4f projection) {
        if (!this.usingTool) {
            RayCaster.RaycastResult result = Tool.raycastBlock(false, false, Tool.defaultIncludeFluids());
            if (result == null) {
                Selection.render(camera, time, matrices, projection, 7);
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            if (this.mode[0] != 2) {
                this.brushWidget.renderPreview(camera, class_243.method_24954((class_2382)result.getBlockPos()), matrices, projection, time, 3);
            }
        } else if (Tool.cancelUsing()) {
            this.partialReset();
        } else if (!Tool.isMouseDown(1)) {
            this.pathProvider.finish();
            String countString = NumberFormat.getInstance().format(this.chunkedBlockRegion.count());
            String historyDescription = AxiomI18n.get("axiom.history_description.painted", countString);
            RegionHelper.pushBlockRegionChange(this.chunkedBlockRegion, historyDescription);
            this.partialReset();
        } else {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            Selection.render(camera, time, matrices, projection, 4);
            this.pathProvider.update();
            if (this.paintingAir) {
                this.airRegion.render(camera, class_243.field_1353, matrices, projection, time, 8);
            } else {
                float opacity = (float)Math.sin((float)time / 1000000.0f / 50.0f / 8.0f);
                this.chunkedBlockRegion.render(camera, class_243.field_1353, matrices, projection, 0.75f + opacity * 0.25f, 0.3f - opacity * 0.2f);
            }
        }
    }

    private static <T extends Comparable<T>> class_2680 copyProperty(class_2680 blockState, class_2680 blockState2, class_2769<T> property) {
        return (class_2680)blockState2.method_11657(property, blockState.method_11654(property));
    }

    @Nullable
    private AsyncToolPather createToolPather(BrushShape brushShape) {
        int seed;
        BlockWithFloat[] blockArray;
        DoubleUnaryOperator[] interpolationArray;
        MaskElement destMask = MaskManager.createSolidDestMask();
        MaskContext maskContext = new MaskContext((class_1937)class_310.method_1551().field_1687);
        this.paintingAir = false;
        boolean copyProperties = this.canCopyProperties() && this.copyProperties;
        boolean typeReplace = this.canTypeReplace() && this.typeReplace;
        switch (this.mode[0]) {
            default: {
                class_2680 blockState = Tool.getActiveBlock();
                if (blockState.method_26215()) {
                    this.paintingAir = true;
                }
                FamilyMap.AxiomBlockFamily typeReplaceFamily = typeReplace ? FamilyMap.getFamilyForBase(blockState.method_26204()) : null;
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                return new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
                    if (!destMask.test(maskContext.reset(), x, y, z)) {
                        return;
                    }
                    if (this.maskSurface && maskContext.getBlockState(x, y, z, 1, 0, 0).method_51366() && maskContext.getBlockState(x, y, z, -1, 0, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, 1, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, -1, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, 0, 1).method_51366() && maskContext.getBlockState(x, y, z, 0, 0, -1).method_51366()) {
                        return;
                    }
                    if (typeReplaceFamily != null) {
                        class_2680 existing = maskContext.getBlockState(x, y, z);
                        class_2680 to = FamilyMap.typeReplace(existing, typeReplaceFamily, (class_2338)mutableBlockPos.method_10103(x, y, z), (class_1937)class_310.method_1551().field_1687);
                        if (to != null) {
                            this.chunkedBlockRegion.addBlock(x, y, z, to);
                        }
                    } else if (copyProperties) {
                        class_2680 existing = maskContext.getBlockState(x, y, z);
                        class_2680 newState = blockState;
                        for (class_2769 property : existing.method_28501()) {
                            if (!newState.method_28498(property)) continue;
                            newState = PainterTool.copyProperty(existing, newState, property);
                        }
                        this.chunkedBlockRegion.addBlock(x, y, z, newState);
                    } else {
                        this.chunkedBlockRegion.addBlock(x, y, z, blockState);
                        if (this.paintingAir) {
                            this.airRegion.add(x, y, z);
                        }
                    }
                });
            }
            case 1: {
                ClipboardObject clipboardObject = Clipboard.INSTANCE.getClipboard();
                if (clipboardObject == null) {
                    return null;
                }
                ChunkedBlockRegion copyFrom = clipboardObject.blockRegion();
                if (copyFrom.isEmpty() || copyFrom.min() == null || copyFrom.max() == null) {
                    return null;
                }
                int minX = copyFrom.min().method_10263();
                int minY = copyFrom.min().method_10264();
                int minZ = copyFrom.min().method_10260();
                int maxX = copyFrom.max().method_10263();
                int maxY = copyFrom.max().method_10264();
                int maxZ = copyFrom.max().method_10260();
                int sizeX = maxX - minX + 1;
                int sizeY = maxY - minY + 1;
                int sizeZ = maxZ - minZ + 1;
                return new AsyncToolPatherUnique(brushShape, (x, y, z) -> {
                    class_2680 blockState;
                    int modZ;
                    int modY;
                    if (!destMask.test(maskContext.reset(), x, y, z)) {
                        return;
                    }
                    if (this.maskSurface && maskContext.getBlockState(x, y, z, 1, 0, 0).method_51366() && maskContext.getBlockState(x, y, z, -1, 0, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, 1, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, -1, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, 0, 1).method_51366() && maskContext.getBlockState(x, y, z, 0, 0, -1).method_51366()) {
                        return;
                    }
                    int modX = x % sizeX;
                    if (modX < 0) {
                        modX += sizeX;
                    }
                    if ((modY = y % sizeY) < 0) {
                        modY += sizeY;
                    }
                    if ((modZ = z % sizeZ) < 0) {
                        modZ += sizeZ;
                    }
                    if (!(blockState = copyFrom.getBlockStateOrAir(minX + modX, minY + modY, minZ + modZ)).method_26215()) {
                        this.chunkedBlockRegion.addBlock(x, y, z, blockState);
                    }
                });
            }
            case 2: {
                ClipboardObject clipboardObject = Clipboard.INSTANCE.getClipboard();
                if (clipboardObject == null) {
                    return null;
                }
                ChunkedBlockRegion copyFrom = clipboardObject.blockRegion();
                if (copyFrom.isEmpty() || copyFrom.min() == null || copyFrom.max() == null) {
                    return null;
                }
                int minX = copyFrom.min().method_10263();
                int minY = copyFrom.min().method_10264();
                int minZ = copyFrom.min().method_10260();
                int maxX = copyFrom.max().method_10263();
                int maxY = copyFrom.max().method_10264();
                int maxZ = copyFrom.max().method_10260();
                return new AsyncToolPatherUnique(new SinglePointBrushShape(), (x, y, z) -> {
                    for (int xo = minX; xo <= maxX; ++xo) {
                        for (int yo = minY; yo <= maxY; ++yo) {
                            for (int zo = minZ; zo <= maxZ; ++zo) {
                                class_2680 blockState;
                                if (!destMask.test(maskContext.reset(), x + xo, y + yo, z + zo) || this.maskSurface && maskContext.getBlockState(x + xo, y + yo, z + zo, 1, 0, 0).method_51366() && maskContext.getBlockState(x + xo, y + yo, z + zo, -1, 0, 0).method_51366() && maskContext.getBlockState(x + xo, y + yo, z + zo, 0, 1, 0).method_51366() && maskContext.getBlockState(x + xo, y + yo, z + zo, 0, -1, 0).method_51366() && maskContext.getBlockState(x + xo, y + yo, z + zo, 0, 0, 1).method_51366() && maskContext.getBlockState(x + xo, y + yo, z + zo, 0, 0, -1).method_51366() || (blockState = copyFrom.getBlockStateOrAir(xo, yo, zo)).method_26215()) continue;
                                this.chunkedBlockRegion.addBlock(x + xo, y + yo, z + zo, blockState);
                            }
                        }
                    }
                });
            }
            case 3: 
        }
        PositionSet blacklistedPositions = new PositionSet();
        if (this.gradientInterpolation[0] == 1) {
            size = this.softEdge ? this.blockPercentages.size() + 1 : this.blockPercentages.size();
            interpolationArray = new DoubleUnaryOperator[size - 1];
            blockArray = new BlockWithFloat[size];
            for (i = 0; i < size; ++i) {
                if (i < interpolationArray.length) {
                    record LinearOperator(int index, int count) implements DoubleUnaryOperator
                    {
                        @Override
                        public double applyAsDouble(double operand) {
                            if (this.index == 0 && operand * (double)this.count < 0.5) {
                                return 1.0;
                            }
                            return 1.0 - Math.abs((double)this.index + 0.5 - (double)this.count * operand);
                        }
                    }
                    interpolationArray[i] = new LinearOperator(i, size);
                }
                if (i >= this.blockPercentages.size()) continue;
                blockArray[i] = this.blockPercentages.get(i);
            }
        } else if (this.gradientInterpolation[0] == 2) {
            size = this.softEdge ? this.blockPercentages.size() + 1 : this.blockPercentages.size();
            interpolationArray = new DoubleUnaryOperator[size - 1];
            blockArray = new BlockWithFloat[size];
            for (i = 0; i < size; ++i) {
                if (i < interpolationArray.length) {
                    interpolationArray[i] = new BezierOperator(i, size);
                }
                if (i >= this.blockPercentages.size()) continue;
                blockArray[i] = this.blockPercentages.get(i);
            }
        } else {
            interpolationArray = null;
            blockArray = null;
        }
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        if (blockArray == null || interpolationArray == null) {
            float totalAmount = 0.0f;
            for (BlockWithFloat blockPercentage : this.blockPercentages) {
                totalAmount += blockPercentage.percentage()[0] / 100.0f;
            }
            if (totalAmount <= 0.0f) {
                return null;
            }
            float totalAmountF = totalAmount;
            return new AsyncToolPatherMinSDF(brushShape, (x, y, z, sdf) -> {
                if (blacklistedPositions.contains(x, y, z)) {
                    return;
                }
                if (!destMask.test(maskContext.reset(), x, y, z)) {
                    blacklistedPositions.add(x, y, z);
                    return;
                }
                if (this.maskSurface && maskContext.getBlockState(x, y, z, 1, 0, 0).method_51366() && maskContext.getBlockState(x, y, z, -1, 0, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, 1, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, -1, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, 0, 1).method_51366() && maskContext.getBlockState(x, y, z, 0, 0, -1).method_51366()) {
                    blacklistedPositions.add(x, y, z);
                    return;
                }
                if (this.mergeStrokes) {
                    float old = this.minDistances.get(x, y, z);
                    if (old < sdf) {
                        sdf = old;
                    } else {
                        this.minDistances.put(x, y, z, sdf);
                    }
                }
                for (BlockWithFloat blockPercentage : this.blockPercentages) {
                    if (!((sdf -= blockPercentage.percentage()[0] / 100.0f / totalAmountF) < 0.0f)) continue;
                    BlockManipulation.setWithCopyPropertiesAndTypeReplace(this.chunkedBlockRegion, x, y, z, blockPercentage.blockState(), typeReplace, copyProperties, blockPercentage.randomProperties(), maskContext, mutableBlockPos);
                    return;
                }
                BlockWithFloat last = this.blockPercentages.get(this.blockPercentages.size() - 1);
                BlockManipulation.setWithCopyPropertiesAndTypeReplace(this.chunkedBlockRegion, x, y, z, last.blockState(), typeReplace, copyProperties, last.randomProperties(), maskContext, mutableBlockPos);
            });
        }
        String seedStr = ImGuiHelper.getString(this.noiseSeed).trim();
        if (seedStr.isEmpty()) {
            seed = this.defaultRandomValue;
        } else {
            try {
                seed = Integer.parseInt(seedStr);
            }
            catch (NumberFormatException numberFormatException) {
                seed = 0;
                for (char c : seedStr.toCharArray()) {
                    seed = 31 * seed + c;
                }
            }
        }
        WhiteNoise whiteNoise = new WhiteNoise(seed);
        float minimumRadius = this.gradientInterpolation[0] == 2 ? this.minimumRadius[0] : 0.0f;
        return new AsyncToolPatherMinSDF(brushShape, (x, y, z, sdf) -> {
            if (blacklistedPositions.contains(x, y, z)) {
                return;
            }
            if (!destMask.test(maskContext.reset(), x, y, z)) {
                blacklistedPositions.add(x, y, z);
                return;
            }
            if (this.maskSurface && maskContext.getBlockState(x, y, z, 1, 0, 0).method_51366() && maskContext.getBlockState(x, y, z, -1, 0, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, 1, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, -1, 0).method_51366() && maskContext.getBlockState(x, y, z, 0, 0, 1).method_51366() && maskContext.getBlockState(x, y, z, 0, 0, -1).method_51366()) {
                blacklistedPositions.add(x, y, z);
                return;
            }
            if (this.mergeStrokes) {
                float old = this.minDistances.get(x, y, z);
                if (old < sdf) {
                    sdf = old;
                } else {
                    this.minDistances.put(x, y, z, sdf);
                }
            }
            if (sdf <= minimumRadius) {
                BlockWithFloat blockWithFloat = blockArray[0];
                if (blockWithFloat != null) {
                    BlockManipulation.setWithCopyPropertiesAndTypeReplace(this.chunkedBlockRegion, x, y, z, blockWithFloat.blockState(), typeReplace, copyProperties, blockWithFloat.randomProperties(), maskContext, mutableBlockPos);
                }
                return;
            }
            sdf = (sdf - minimumRadius) / (1.0f - minimumRadius);
            double randomValue = whiteNoise.evaluate((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
            int i = 0;
            for (DoubleUnaryOperator operator : interpolationArray) {
                if ((randomValue -= Math.max(0.0, operator.applyAsDouble(sdf))) < 0.0) {
                    BlockWithFloat blockWithFloat = blockArray[i];
                    if (blockWithFloat != null) {
                        BlockManipulation.setWithCopyPropertiesAndTypeReplace(this.chunkedBlockRegion, x, y, z, blockWithFloat.blockState(), typeReplace, copyProperties, blockWithFloat.randomProperties(), maskContext, mutableBlockPos);
                    }
                    return;
                }
                ++i;
            }
            BlockWithFloat blockWithFloat = blockArray[blockArray.length - 1];
            if (blockWithFloat != null) {
                BlockManipulation.setWithCopyPropertiesAndTypeReplace(this.chunkedBlockRegion, x, y, z, blockWithFloat.blockState(), typeReplace, copyProperties, blockWithFloat.randomProperties(), maskContext, mutableBlockPos);
            }
        });
    }

    @Override
    public void displayImguiOptions() {
        boolean changed = false;
        if (this.mode[0] != 2) {
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.brush"));
            changed |= this.brushWidget.displayImgui();
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.painter"));
        if (ImGui.checkbox(AxiomI18n.get("axiom.tool.generic.mask_surface"), this.maskSurface)) {
            this.maskSurface = !this.maskSurface;
            changed = true;
        }
        if (this.mode[0] == 0) {
            boolean showCopyProperties = true;
            boolean filledLine = false;
            if (FamilyMap.getFamilyForBase(Tool.getActiveBlock().method_26204()) != null) {
                ImGui.sameLine();
                if (ImGui.checkbox(AxiomI18n.get("axiom.contextmenu.type_replace"), this.typeReplace)) {
                    boolean bl = this.typeReplace = !this.typeReplace;
                }
                if (this.typeReplace) {
                    showCopyProperties = false;
                }
                filledLine = true;
            }
            if (showCopyProperties && !Tool.getActiveBlock().method_28501().isEmpty()) {
                if (!filledLine) {
                    ImGui.sameLine();
                }
                if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.replace.copy_properties"), this.copyProperties)) {
                    this.copyProperties = !this.copyProperties;
                }
            }
        }
        changed |= ImGuiHelper.combo(AxiomI18n.get("axiom.tool.painter.paint_mode"), this.mode, new String[]{AxiomI18n.get("axiom.tool.painter.paint_mode.active_block"), AxiomI18n.get("axiom.tool.painter.paint_mode.tiled_clipboard"), AxiomI18n.get("axiom.tool.painter.paint_mode.stamped_clipboard"), AxiomI18n.get("axiom.tool.painter.paint_mode.gradient")});
        if (this.mode[0] == 1) {
            boolean showEmptyWarning;
            ClipboardObject clipboardObject = Clipboard.INSTANCE.getClipboard();
            if (clipboardObject == null) {
                showEmptyWarning = true;
            } else {
                ChunkedBlockRegion copyFrom = clipboardObject.blockRegion();
                boolean bl = showEmptyWarning = copyFrom.isEmpty() || copyFrom.min() == null || copyFrom.max() == null;
            }
            if (showEmptyWarning) {
                ImGuiHelper.setupBorder();
                ImGui.text("\u26a0 " + AxiomI18n.get("axiom.tool.painter.clipboard_empty_warning"));
                ImGuiHelper.finishBorder();
            }
        } else if (this.mode[0] == 3) {
            ImGuiHelper.setupBorder();
            changed |= ImGuiHelper.radio(AxiomI18n.get("axiom.tool.gradient_painter.gradient_interpolation"), this.gradientInterpolation, new String[]{AxiomI18n.get("axiom.tool.gradient_painter.gradient_interpolation_nearest"), AxiomI18n.get("axiom.tool.gradient_painter.gradient_interpolation_linear"), AxiomI18n.get("axiom.tool.gradient_painter.gradient_interpolation_bezier")});
            if (this.gradientInterpolation[0] != 0) {
                ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.generic.noise"));
                changed |= ImGui.inputText(AxiomI18n.get("axiom.tool.generic.noise_seed"), this.noiseSeed);
                if (ImGui.button(AxiomI18n.get("axiom.tool.generic.noise_seed_do_randomize"))) {
                    this.noiseSeed.set(String.valueOf(ThreadLocalRandom.current().nextInt()), false);
                    changed = true;
                }
                ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
                if (ImGui.checkbox(AxiomI18n.get("axiom.tool.painter.soft_edge"), this.softEdge)) {
                    this.softEdge = !this.softEdge;
                    changed = true;
                }
            } else {
                ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.options"));
            }
            if (ImGui.checkbox(AxiomI18n.get("axiom.tool.painter.merge_strokes"), this.mergeStrokes)) {
                this.mergeStrokes = !this.mergeStrokes;
                changed = true;
            }
            if (this.gradientInterpolation[0] == 2) {
                changed |= ImGui.sliderFloat(AxiomI18n.get("axiom.tool.painter.inner_radius"), this.minimumRadius, 0.0f, 1.0f, "%.2f");
            }
            ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.tool.noise_painter.blocks"));
            BlockWithFloat.ExtraRenderType extraRenderType = this.gradientInterpolation[0] == 0 ? BlockWithFloat.ExtraRenderType.PERCENTAGE : BlockWithFloat.ExtraRenderType.BLOCKNAME;
            changed |= BlockWithFloat.renderList(this.blockPercentages, this.selectBlockWidget, extraRenderType, this.softEdge ? 1 : 2, true);
            if (this.mode[0] == 3) {
                if (this.canCopyProperties() && ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.replace.copy_properties"), this.copyProperties)) {
                    boolean bl = this.copyProperties = !this.copyProperties;
                }
                if (this.canTypeReplace() && ImGui.checkbox(AxiomI18n.get("axiom.contextmenu.type_replace"), this.typeReplace)) {
                    this.typeReplace = !this.typeReplace;
                }
            }
            ImGuiHelper.finishBorder();
        }
        ImGuiHelper.separatorWithText(AxiomI18n.get("axiom.widget.presets"));
        this.presetWidget.displayImgui(changed);
    }

    private boolean canCopyProperties() {
        if (this.mode[0] == 0) {
            class_2680 blockState = Tool.getActiveBlock();
            return !blockState.method_28501().isEmpty();
        }
        if (this.mode[0] == 3) {
            for (BlockWithFloat blockThreshold : this.blockPercentages) {
                if (blockThreshold.blockState().getProperties().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canTypeReplace() {
        if (this.mode[0] == 0) {
            class_2680 blockState = Tool.getActiveBlock();
            return FamilyMap.getFamilyForBase(blockState.method_26204()) != null;
        }
        if (this.mode[0] == 3) {
            for (BlockWithFloat blockThreshold : this.blockPercentages) {
                if (blockThreshold.blockState().getProperties().isEmpty()) continue;
                return true;
            }
        }
        return true;
    }

    @Override
    public String listenForEsc() {
        if (!this.usingTool) {
            return null;
        }
        return AxiomI18n.get("axiom.widget.cancel");
    }

    @Override
    public boolean initiateAdjustment() {
        return this.brushWidget.initiateAdjustment();
    }

    @Override
    public class_241 renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        return this.brushWidget.renderAdjustment(mouseX, mouseY, mouseDelta);
    }

    @Override
    public String name() {
        return AxiomI18n.get("axiom.tool.painter");
    }

    @Override
    public void writeSettings(class_2487 tag) {
        this.brushWidget.writeSettings(tag);
        tag.method_10556("MaskSurface", this.maskSurface);
        tag.method_10567("Mode", (byte)this.mode[0]);
        tag.method_10567("GradientInterpolation", (byte)this.gradientInterpolation[0]);
        class_2499 blockPercentages = new class_2499();
        for (BlockWithFloat blockWithFloat : this.blockPercentages) {
            class_2487 blockWithFloatTag = new class_2487();
            blockWithFloatTag.method_10582("Block", ServerCustomBlocks.serialize(blockWithFloat.blockState()));
            blockWithFloatTag.method_10548("Percentage", blockWithFloat.percentage()[0]);
            blockPercentages.add((Object)blockWithFloatTag);
        }
        tag.method_10566("BlockPercentages", (class_2520)blockPercentages);
        tag.method_10582("NoiseSeed", ImGuiHelper.getString(this.noiseSeed));
        tag.method_10556("SoftEdge", this.softEdge);
        tag.method_10556("MergeStrokes", this.mergeStrokes);
        tag.method_10548("MinimumRadius", this.minimumRadius[0]);
    }

    @Override
    public void loadSettings(class_2487 tag) {
        this.brushWidget.loadSettings(tag);
        this.maskSurface = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "MaskSurface", true);
        this.mode[0] = VersionUtilsNbt.helperCompoundTagGetByteOr(tag, "Mode", (byte)0);
        this.gradientInterpolation[0] = VersionUtilsNbt.helperCompoundTagGetByteOr(tag, "GradientInterpolation", (byte)0);
        this.blockPercentages.clear();
        class_2499 blockPercentagesList = NbtHelper.getList(tag, "BlockPercentages", 10);
        for (class_2520 blockPercentageTag : blockPercentagesList) {
            class_2487 blockPercentage = (class_2487)blockPercentageTag;
            String block = VersionUtilsNbt.helperCompoundTagGetString(blockPercentage, "Block").get();
            float percentage = VersionUtilsNbt.helperCompoundTagGetFloat(blockPercentage, "Percentage").get().floatValue();
            this.blockPercentages.add(new BlockWithFloat(Objects.requireNonNullElse(ServerCustomBlocks.deserialize(block), (CustomBlockState)class_2246.field_10340.method_9564()), new float[]{percentage}, null));
        }
        if (this.blockPercentages.isEmpty()) {
            this.blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_10340.method_9564(), new float[]{50.0f}, null));
            this.blockPercentages.add(new BlockWithFloat((CustomBlockState)class_2246.field_10474.method_9564(), new float[]{50.0f}, null));
        }
        this.noiseSeed.set(VersionUtilsNbt.helperCompoundTagGetStringOr(tag, "NoiseSeed", String.valueOf(this.defaultRandomValue)), false);
        this.softEdge = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "SoftEdge", false);
        this.mergeStrokes = VersionUtilsNbt.helperCompoundTagGetBooleanOr(tag, "MergeStrokes", true);
        this.minimumRadius[0] = VersionUtilsNbt.helperCompoundTagGetFloatOr(tag, "MinimumRadius", 0.0f);
    }

    public void setGradientBlocks(List<CustomBlockState> blocks) {
        this.mode[0] = 3;
        this.blockPercentages.clear();
        for (CustomBlockState block : blocks) {
            this.blockPercentages.add(new BlockWithFloat(block, new float[]{100.0f / (float)blocks.size()}, null));
        }
        BlockWithFloat.ensureFilledToMinimum(this.blockPercentages, 2);
    }

    @Override
    public boolean showToolSmoothing() {
        return true;
    }

    @Override
    public char iconChar() {
        return '\ue910';
    }

    @Override
    public String keybindId() {
        return "painter";
    }

    @Override
    public int defaultKeybind() {
        return 80;
    }

    @Override
    public EnumSet<AxiomPermission> requiredPermissions() {
        return EnumSet.of(AxiomPermission.TOOL_PAINTER, AxiomPermission.BUILD_SECTION);
    }
}

