/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.restrictions;

import com.moulberry.axiom.restrictions.AxiomPermission;
import com.moulberry.axiom.utils.Box;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2540;

public class Restrictions {
    private static final Map<String, AxiomPermission> PERMISSION_BY_NAME = new LinkedHashMap<String, AxiomPermission>();
    public EnumSet<AxiomPermission> allowedPermissions = EnumSet.of(AxiomPermission.DEFAULT);
    public EnumSet<AxiomPermission> deniedPermissions = EnumSet.noneOf(AxiomPermission.class);
    public int infiniteReachLimit = -1;
    public List<Box> bounds = new ArrayList<Box>();
    public Box globalBounds = null;

    public Restrictions() {
    }

    public Restrictions(class_2540 friendlyByteBuf) {
        this.allowedPermissions = EnumSet.noneOf(AxiomPermission.class);
        int allowedPermissionCount = friendlyByteBuf.method_10816();
        for (int i = 0; i < allowedPermissionCount; ++i) {
            String name = friendlyByteBuf.method_19772();
            AxiomPermission permission = PERMISSION_BY_NAME.get(name);
            if (permission == null) continue;
            this.allowedPermissions.add(permission);
        }
        this.deniedPermissions = EnumSet.noneOf(AxiomPermission.class);
        int disallowedPermissionCount = friendlyByteBuf.method_10816();
        for (int i = 0; i < disallowedPermissionCount; ++i) {
            String name = friendlyByteBuf.method_19772();
            AxiomPermission permission = PERMISSION_BY_NAME.get(name);
            if (permission == null) continue;
            this.deniedPermissions.add(permission);
        }
        this.infiniteReachLimit = friendlyByteBuf.readInt();
        int count = friendlyByteBuf.method_10816();
        if (count <= 0) {
            this.bounds = List.of();
            this.globalBounds = null;
        } else {
            this.bounds = new ArrayList<Box>();
            class_2338 globalMin = null;
            class_2338 globalMax = null;
            for (int i = 0; i < count; ++i) {
                class_2338 one = friendlyByteBuf.method_10811();
                class_2338 two = friendlyByteBuf.method_10811();
                int minX = Math.min(one.method_10263(), two.method_10263());
                int minY = Math.min(one.method_10264(), two.method_10264());
                int minZ = Math.min(one.method_10260(), two.method_10260());
                int maxX = Math.max(one.method_10263(), two.method_10263());
                int maxY = Math.max(one.method_10264(), two.method_10264());
                int maxZ = Math.max(one.method_10260(), two.method_10260());
                if (globalMin == null) {
                    globalMin = new class_2338(minX, minY, minZ);
                    globalMax = new class_2338(maxX, maxY, maxZ);
                } else {
                    globalMin = new class_2338(Math.min(minX, globalMin.method_10263()), Math.min(minY, globalMin.method_10264()), Math.min(minZ, globalMin.method_10260()));
                    globalMax = new class_2338(Math.max(maxX, globalMax.method_10263()), Math.max(maxY, globalMax.method_10264()), Math.max(maxZ, globalMax.method_10260()));
                }
                this.bounds.add(new Box(new class_2338(minX, minY, minZ), new class_2338(maxX, maxY, maxZ)));
            }
            this.globalBounds = new Box(globalMin, globalMax);
        }
    }

    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.method_10804(this.allowedPermissions.size());
        for (AxiomPermission allowedPermission : this.allowedPermissions) {
            friendlyByteBuf.method_10814(allowedPermission.getInternalName());
        }
        friendlyByteBuf.method_10804(this.deniedPermissions.size());
        for (AxiomPermission disallowedPermission : this.deniedPermissions) {
            friendlyByteBuf.method_10814(disallowedPermission.getInternalName());
        }
        friendlyByteBuf.writeInt(this.infiniteReachLimit);
        friendlyByteBuf.method_10804(this.bounds.size());
        for (Box bound : this.bounds) {
            friendlyByteBuf.method_10807(bound.pos1());
            friendlyByteBuf.method_10807(bound.pos2());
        }
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Restrictions that = (Restrictions)o;
        return this.infiniteReachLimit == that.infiniteReachLimit && this.allowedPermissions.equals(that.allowedPermissions) && this.deniedPermissions.equals(that.deniedPermissions) && this.bounds.equals(that.bounds) && Objects.equals(this.globalBounds, that.globalBounds);
    }

    public int hashCode() {
        int result = this.allowedPermissions.hashCode();
        result = 31 * result + this.deniedPermissions.hashCode();
        result = 31 * result + this.infiniteReachLimit;
        result = 31 * result + this.bounds.hashCode();
        result = 31 * result + Objects.hashCode(this.globalBounds);
        return result;
    }

    static {
        for (AxiomPermission value : AxiomPermission.values()) {
            PERMISSION_BY_NAME.put(value.getInternalName(), value);
        }
    }
}

