/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render.regions;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.moulberry.axiom.GlobalCleaner;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.PositionConsumer;
import com.moulberry.axiom.collections.list.IntrusiveLinkedElement;
import com.moulberry.axiom.collections.list.IntrusiveLinkedList;
import com.moulberry.axiom.core_rendering.AxiomBufferUsage;
import com.moulberry.axiom.core_rendering.AxiomDraw;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.core_rendering.AxiomRenderPipeline;
import com.moulberry.axiom.core_rendering.AxiomRenderPipelines;
import com.moulberry.axiom.core_rendering.AxiomRenderer;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.exceptions.FaultyImplementationError;
import com.moulberry.axiom.render.BlockTessellator;
import com.moulberry.axiom.render.MeshDataHelper;
import com.moulberry.axiom.render.SortStateWrapper;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.cache.TessellatedBlockCache;
import com.moulberry.axiom.render.regions.EmptyChunkSource;
import com.moulberry.axiom.utils.AxiomVertexFormats;
import com.moulberry.axiom.utils.BlockHelper;
import com.moulberry.axiom.utils.DFUHelper;
import com.moulberry.axiom.utils.RenderHelper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiomclientapi.regions.BlockRegion;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.blockview.v2.FabricBlockView;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1163;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1953;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2359;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2841;
import net.minecraft.class_287;
import net.minecraft.class_2874;
import net.minecraft.class_290;
import net.minecraft.class_2902;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4543;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5217;
import net.minecraft.class_5455;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_6539;
import net.minecraft.class_6756;
import net.minecraft.class_6880;
import net.minecraft.class_7134;
import net.minecraft.class_7699;
import net.minecraft.class_776;
import net.minecraft.class_8251;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ChunkedBlockRegion
implements FabricBlockView,
class_1920,
class_1936,
BlockRegion,
RenderAttachedBlockView {
    public static final int SOLID_RENDER_LIMIT = 0x1000000;
    public static final int TRANSLUCENT_RENDER_LIMIT = 262144;
    public static int staticPackReloadIndex = 0;
    private int packReloadIndex;
    private class_2338.class_2339 min = null;
    private class_2338.class_2339 max = null;
    public class_2680 uniqueBlockState = null;
    private int count;
    private final Position2ObjectMap<class_2680> blockData;
    private LongSet dirtyChunks = new LongOpenHashSet();
    private long lastSortMillis;
    private float lastSortX;
    private float lastSortY;
    private float lastSortZ;
    private int lastSortChunkX;
    private int lastSortChunkY;
    private int lastSortChunkZ;
    private final boolean drawOutlineForNonBlockingMotion;
    @Nullable
    private RenderData renderData = null;
    private float lastBlockOpacity = 1.0f;
    private final IntrusiveLinkedList<ChunkData> sortedChunkData = new IntrusiveLinkedList();
    private static final class_2874 DUMMY_DIMENSION_TYPE = new class_2874(OptionalLong.empty(), true, false, false, true, 1.0, true, false, -64, 384, 384, class_3481.field_25588, class_7134.field_37670, 0.0f, new class_2874.class_7512(false, true, (class_6017)class_6019.method_35017((int)0, (int)7), 0));
    private static final class_2680 AIR = class_2246.field_10124.method_9564();
    private final EmptyChunkSource emptyChunkSource = new EmptyChunkSource((class_1922)this);
    private final class_5819 randomSource = class_5819.method_43049((long)0L);

    public ChunkedBlockRegion() {
        this(true);
    }

    public ChunkedBlockRegion(boolean drawOutlineForNonBlockingMotion) {
        this.drawOutlineForNonBlockingMotion = drawOutlineForNonBlockingMotion;
        this.blockData = new Position2ObjectMap(k -> new class_2680[4096]);
        this.packReloadIndex = staticPackReloadIndex;
    }

    public void render(class_4184 camera, class_243 translation, class_4587 matrix, Matrix4f projection, float blockOpacity, float outlineOpacity) {
        this.render(camera, translation, null, matrix, projection, blockOpacity, outlineOpacity);
    }

    public void render(class_4184 camera, class_243 translation, Quaternionf rotation, class_4587 matrix, Matrix4f projection, float blockOpacity, float outlineOpacity) {
        this.render(camera, translation, rotation, matrix, projection, blockOpacity, outlineOpacity, true);
    }

    public void render(class_4184 camera, class_243 translation, Quaternionf rotation, class_4587 matrix, Matrix4f projection, float blockOpacity, float outlineOpacity, boolean polygonOffset) {
        this.render(camera, translation, rotation, matrix, projection, blockOpacity, outlineOpacity, polygonOffset, null);
    }

    public void render(class_4184 camera, class_243 translation, Quaternionf rotation, class_4587 matrix, Matrix4f projection, float blockOpacity, float outlineOpacity, boolean polygonOffset, class_276 renderTarget) {
        AxiomRenderPipeline pipeline;
        boolean canResort;
        RenderSystem.assertOnRenderThread();
        if (blockOpacity <= 0.01f && outlineOpacity <= 0.01f) {
            return;
        }
        if (this.count() <= 0 || this.count() >= 0x1000000) {
            return;
        }
        boolean canUseAmbientOcclusion = true;
        boolean bl = canResort = (double)blockOpacity < 0.99;
        if (this.count() > 262144) {
            canUseAmbientOcclusion = false;
            if (this.lastBlockOpacity < 1.0f) {
                this.lastBlockOpacity += Math.max(0.001f, VersionUtilsClient.getPartialTick(class_310.method_1551()) / 50.0f);
            }
            if (this.lastBlockOpacity > 1.0f) {
                this.lastBlockOpacity = 1.0f;
            }
            blockOpacity = this.lastBlockOpacity;
            canResort = false;
        } else {
            this.lastBlockOpacity = blockOpacity;
        }
        if (this.packReloadIndex != staticPackReloadIndex) {
            this.packReloadIndex = staticPackReloadIndex;
            this.dirtyAll();
        }
        this.uploadDirty(camera, translation, canResort, canUseAmbientOcclusion);
        if (this.sortedChunkData.isEmpty()) {
            return;
        }
        ChunkData firstChunkData = this.sortedChunkData.first();
        double originX = firstChunkData.offsetX;
        double originY = firstChunkData.offsetY;
        double originZ = firstChunkData.offsetZ;
        Matrix4d initialTransform = new Matrix4d();
        initialTransform.translate(translation.field_1352, translation.field_1351, translation.field_1350);
        if (camera != null) {
            initialTransform.translate(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
        }
        if (rotation != null) {
            initialTransform.rotate((Quaternionfc)rotation);
        }
        initialTransform.translate(originX, originY, originZ);
        matrix.method_22903();
        matrix.method_34425(new Matrix4f((Matrix4dc)initialTransform));
        Matrix4f modelViewMatrix = matrix.method_23760().method_23761();
        RenderHelper.pushModelViewMatrix(modelViewMatrix);
        ArrayList<AxiomDraw> blockDraws = new ArrayList<AxiomDraw>(this.sortedChunkData.size());
        ArrayList<AxiomDraw> outlineDraws = new ArrayList<AxiomDraw>(this.sortedChunkData.size());
        for (ChunkData data : this.sortedChunkData) {
            Matrix4f translated = new Matrix4f((Matrix4fc)modelViewMatrix);
            translated = translated.translate((float)((double)data.offsetX - originX), (float)((double)data.offsetY - originY), (float)((double)data.offsetZ - originZ));
            if (data.block != null && blockOpacity > 0.01f) {
                blockDraws.add(new AxiomDraw(data.block, translated, null, null));
            }
            if (data.outline == null || !(outlineOpacity > 0.01f)) continue;
            outlineDraws.add(new AxiomDraw(data.outline, translated, null, null));
        }
        if (blockOpacity > 0.01f && !blockDraws.isEmpty()) {
            AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, blockOpacity);
            pipeline = polygonOffset ? AxiomRenderPipelines.AXIOM_BLOCK_WITH_OFFSET : AxiomRenderPipelines.AXIOM_BLOCK;
            AxiomRenderer.renderPipeline(pipeline, renderTarget, blockDraws);
        }
        if (outlineOpacity > 0.01f && !outlineDraws.isEmpty()) {
            AxiomRenderer.setShaderColour(0.7f, 0.7f, 1.0f, outlineOpacity);
            pipeline = polygonOffset ? AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH_WITH_OFFSET : AxiomRenderPipelines.LINES_WITHOUT_WRITE_DEPTH;
            AxiomRenderer.renderPipeline(pipeline, renderTarget, outlineDraws);
        }
        RenderHelper.popModelViewStack();
        matrix.method_22909();
        AxiomRenderer.setShaderColour(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void uploadDirty(class_4184 camera, class_243 translation, boolean canResort, boolean canUseAmbientOcclusion) {
        if (this.renderData == null) {
            this.renderData = new RenderData((Long2ObjectMap<ChunkData>)new Long2ObjectOpenHashMap(), new TessellatedBlockCache(), VertexConsumerProvider.owned(256));
            GlobalCleaner.INSTANCE.register(this, new CleanState(this.renderData));
        }
        LongSet chunksToUpload = this.dirtyChunks;
        this.dirtyChunks = new LongOpenHashSet();
        VertexConsumerProvider blockProvider = VertexConsumerProvider.shared();
        class_776 renderManager = class_310.method_1551().method_1541();
        class_5819 rand = class_5819.method_43047();
        class_4587 matrices = new class_4587();
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        float sortX = (float)((camera != null ? camera.method_19326().field_1352 : 0.0) - translation.field_1352);
        float sortY = (float)((camera != null ? camera.method_19326().field_1351 : 0.0) - translation.field_1351);
        float sortZ = (float)((camera != null ? camera.method_19326().field_1350 : 0.0) - translation.field_1350);
        boolean addedNewChunk = false;
        TessellatedBlockCache tessellatedBlockCache = null;
        if (this.uniqueBlockState != null && this.blockData.chunkKeySet().size() > 8) {
            this.renderData.tessellatedBlockCache.setBlockState(this.uniqueBlockState);
            tessellatedBlockCache = this.renderData.tessellatedBlockCache;
        }
        BlockTessellator blockTessellator = new BlockTessellator(class_310.method_1588() && canUseAmbientOcclusion, true);
        LongIterator longIterator = chunksToUpload.longIterator();
        while (longIterator.hasNext()) {
            ChunkData chunkData;
            class_2680 dataState;
            boolean blockPlusYZ;
            boolean blockPlusXZ;
            boolean blockPlusXY;
            boolean blockPlusZ;
            boolean blockPlusY;
            boolean blockPlusYZ2;
            boolean blockPlusXZ2;
            boolean blockPlusXY2;
            boolean blockPlusZ2;
            boolean blockPlusY2;
            boolean blockPlusX;
            int index;
            long pos = longIterator.nextLong();
            int chunkX = class_2338.method_10061((long)pos);
            int chunkY = class_2338.method_10071((long)pos);
            int chunkZ = class_2338.method_10083((long)pos);
            int offsetX = chunkX * 16;
            int offsetY = chunkY * 16;
            int offsetZ = chunkZ * 16;
            class_287 blockBuilder = blockProvider.begin(class_293.class_5596.field_27382, AxiomVertexFormats.AXIOM_BLOCK);
            class_287 outlineBuilder = this.renderData.outlineProvider.begin(class_293.class_5596.field_27377, class_290.field_29337);
            this.renderData.tessellatedBlockCache.setVertexFormat(AxiomVertexFormats.AXIOM_BLOCK);
            class_2680[] blocks = this.blockData.getChunk(pos);
            class_2680[] plusX = this.blockData.getChunk(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ));
            class_2680[] plusY = this.blockData.getChunk(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ));
            class_2680[] plusXY = this.blockData.getChunk(class_2338.method_10064((int)(chunkX + 1), (int)(chunkY + 1), (int)chunkZ));
            class_2680[] plusZ = this.blockData.getChunk(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1)));
            class_2680[] plusXZ = this.blockData.getChunk(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)(chunkZ + 1)));
            class_2680[] plusYZ = this.blockData.getChunk(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)(chunkZ + 1)));
            Matrix4f currentPoseMatrix = matrices.method_23760().method_23761();
            Matrix4f basePoseMatrix = new Matrix4f((Matrix4fc)currentPoseMatrix);
            for (int z = 0; z < 15; ++z) {
                class_2680 dataState2;
                for (int y = 0; y < 15; ++y) {
                    class_2680 dataState3;
                    if (blocks != null) {
                        for (int x = 0; x < 15; ++x) {
                            index = z * 16 * 16 + y * 16 + x;
                            class_2680 dataState4 = blocks[index];
                            if (dataState4 != null) {
                                blockPos.method_10103(offsetX + x, offsetY + y, offsetZ + z);
                                if (tessellatedBlockCache != null) {
                                    tessellatedBlockCache.renderBlock(blockBuilder, renderManager, this, (class_2338)blockPos, x, y, z);
                                } else {
                                    blockTessellator.tessellateBlockAndLiquidWithOffset(blockBuilder, renderManager, blockPos, rand, matrices, this, currentPoseMatrix, basePoseMatrix, x, y, z, dataState4);
                                }
                            }
                            boolean blockOutline = this.shouldBlockBeOutlined(dataState4);
                            boolean blockPlusX2 = this.shouldBlockBeOutlined(blocks[index + 1]);
                            boolean blockPlusY3 = this.shouldBlockBeOutlined(blocks[index + 16]);
                            boolean blockPlusZ3 = this.shouldBlockBeOutlined(blocks[index + 256]);
                            boolean blockPlusXY3 = this.shouldBlockBeOutlined(blocks[index + 17]);
                            boolean blockPlusXZ3 = this.shouldBlockBeOutlined(blocks[index + 257]);
                            boolean blockPlusYZ3 = this.shouldBlockBeOutlined(blocks[index + 272]);
                            ChunkedBlockRegion.renderOutline(outlineBuilder, x, y, z, blockOutline, blockPlusX2, blockPlusY3, blockPlusZ3, blockPlusXY3, blockPlusXZ3, blockPlusYZ3);
                        }
                    }
                    index = z * 16 * 16 + y * 16 + 15;
                    class_2680 class_26802 = dataState3 = blocks == null ? null : blocks[index];
                    if (dataState3 != null) {
                        blockPos.method_10103(offsetX + 15, offsetY + y, offsetZ + z);
                        if (tessellatedBlockCache != null) {
                            tessellatedBlockCache.renderBlock(blockBuilder, renderManager, this, (class_2338)blockPos, 15, y, z);
                        } else {
                            blockTessellator.tessellateBlockAndLiquidWithOffset(blockBuilder, renderManager, blockPos, rand, matrices, this, currentPoseMatrix, basePoseMatrix, 15, y, z, dataState3);
                        }
                    }
                    boolean blockOutline = this.shouldBlockBeOutlined(dataState3);
                    blockPlusX = plusX != null && this.shouldBlockBeOutlined(plusX[y * 16 + z * 16 * 16]);
                    blockPlusY2 = blocks != null && this.shouldBlockBeOutlined(blocks[index + 16]);
                    blockPlusZ2 = blocks != null && this.shouldBlockBeOutlined(blocks[index + 256]);
                    blockPlusXY2 = plusX != null && this.shouldBlockBeOutlined(plusX[(y + 1) * 16 + z * 16 * 16]);
                    blockPlusXZ2 = plusX != null && this.shouldBlockBeOutlined(plusX[y * 16 + (z + 1) * 16 * 16]);
                    blockPlusYZ2 = blocks != null && this.shouldBlockBeOutlined(blocks[index + 272]);
                    ChunkedBlockRegion.renderOutline(outlineBuilder, 15, y, z, blockOutline, blockPlusX, blockPlusY2, blockPlusZ2, blockPlusXY2, blockPlusXZ2, blockPlusYZ2);
                }
                for (int x = 0; x < 15; ++x) {
                    class_2680 dataState5;
                    index = z * 16 * 16 + 240 + x;
                    class_2680 class_26803 = dataState5 = blocks == null ? null : blocks[index];
                    if (dataState5 != null) {
                        blockPos.method_10103(offsetX + x, offsetY + 15, offsetZ + z);
                        if (tessellatedBlockCache != null) {
                            tessellatedBlockCache.renderBlock(blockBuilder, renderManager, this, (class_2338)blockPos, x, 15, z);
                        } else {
                            blockTessellator.tessellateBlockAndLiquidWithOffset(blockBuilder, renderManager, blockPos, rand, matrices, this, currentPoseMatrix, basePoseMatrix, x, 15, z, dataState5);
                        }
                    }
                    boolean blockOutline = this.shouldBlockBeOutlined(dataState5);
                    blockPlusX = blocks != null && this.shouldBlockBeOutlined(blocks[index + 1]);
                    blockPlusY2 = plusY != null && this.shouldBlockBeOutlined(plusY[x + z * 16 * 16]);
                    blockPlusZ2 = blocks != null && this.shouldBlockBeOutlined(blocks[index + 256]);
                    blockPlusXY2 = plusY != null && this.shouldBlockBeOutlined(plusY[x + 1 + z * 16 * 16]);
                    blockPlusXZ2 = blocks != null && this.shouldBlockBeOutlined(blocks[index + 257]);
                    blockPlusYZ2 = plusY != null && this.shouldBlockBeOutlined(plusY[x + (z + 1) * 16 * 16]);
                    ChunkedBlockRegion.renderOutline(outlineBuilder, x, 15, z, blockOutline, blockPlusX, blockPlusY2, blockPlusZ2, blockPlusXY2, blockPlusXZ2, blockPlusYZ2);
                }
                index = z * 16 * 16 + 240 + 15;
                class_2680 class_26804 = dataState2 = blocks == null ? null : blocks[index];
                if (dataState2 != null) {
                    blockPos.method_10103(offsetX + 15, offsetY + 15, offsetZ + z);
                    if (tessellatedBlockCache != null) {
                        tessellatedBlockCache.renderBlock(blockBuilder, renderManager, this, (class_2338)blockPos, 15, 15, z);
                    } else {
                        blockTessellator.tessellateBlockAndLiquidWithOffset(blockBuilder, renderManager, blockPos, rand, matrices, this, currentPoseMatrix, basePoseMatrix, 15, 15, z, dataState2);
                    }
                }
                boolean blockOutline = this.shouldBlockBeOutlined(dataState2);
                boolean blockPlusX3 = plusX != null && this.shouldBlockBeOutlined(plusX[240 + z * 16 * 16]);
                blockPlusY = plusY != null && this.shouldBlockBeOutlined(plusY[15 + z * 16 * 16]);
                blockPlusZ = blocks != null && this.shouldBlockBeOutlined(blocks[index + 256]);
                blockPlusXY = plusXY != null && this.shouldBlockBeOutlined(plusXY[z * 16 * 16]);
                blockPlusXZ = plusX != null && this.shouldBlockBeOutlined(plusX[240 + (z + 1) * 16 * 16]);
                blockPlusYZ = plusY != null && this.shouldBlockBeOutlined(plusY[15 + (z + 1) * 16 * 16]);
                ChunkedBlockRegion.renderOutline(outlineBuilder, 15, 15, z, blockOutline, blockPlusX3, blockPlusY, blockPlusZ, blockPlusXY, blockPlusXZ, blockPlusYZ);
            }
            for (int y = 0; y < 15; ++y) {
                class_2680 dataState6;
                for (int x = 0; x < 15; ++x) {
                    class_2680 dataState7;
                    index = 3840 + y * 16 + x;
                    class_2680 class_26805 = dataState7 = blocks == null ? null : blocks[index];
                    if (dataState7 != null) {
                        blockPos.method_10103(offsetX + x, offsetY + y, offsetZ + 15);
                        if (tessellatedBlockCache != null) {
                            tessellatedBlockCache.renderBlock(blockBuilder, renderManager, this, (class_2338)blockPos, x, y, 15);
                        } else {
                            blockTessellator.tessellateBlockAndLiquidWithOffset(blockBuilder, renderManager, blockPos, rand, matrices, this, currentPoseMatrix, basePoseMatrix, x, y, 15, dataState7);
                        }
                    }
                    boolean blockOutline = this.shouldBlockBeOutlined(dataState7);
                    blockPlusX = blocks != null && this.shouldBlockBeOutlined(blocks[index + 1]);
                    blockPlusY2 = blocks != null && this.shouldBlockBeOutlined(blocks[index + 16]);
                    blockPlusZ2 = plusZ != null && this.shouldBlockBeOutlined(plusZ[x + y * 16]);
                    blockPlusXY2 = blocks != null && this.shouldBlockBeOutlined(blocks[index + 17]);
                    blockPlusXZ2 = plusZ != null && this.shouldBlockBeOutlined(plusZ[x + 1 + y * 16]);
                    blockPlusYZ2 = plusZ != null && this.shouldBlockBeOutlined(plusZ[x + (y + 1) * 16]);
                    ChunkedBlockRegion.renderOutline(outlineBuilder, x, y, 15, blockOutline, blockPlusX, blockPlusY2, blockPlusZ2, blockPlusXY2, blockPlusXZ2, blockPlusYZ2);
                }
                index = 3840 + y * 16 + 15;
                class_2680 class_26806 = dataState6 = blocks == null ? null : blocks[index];
                if (dataState6 != null) {
                    blockPos.method_10103(offsetX + 15, offsetY + y, offsetZ + 15);
                    if (tessellatedBlockCache != null) {
                        tessellatedBlockCache.renderBlock(blockBuilder, renderManager, this, (class_2338)blockPos, 15, y, 15);
                    } else {
                        blockTessellator.tessellateBlockAndLiquidWithOffset(blockBuilder, renderManager, blockPos, rand, matrices, this, currentPoseMatrix, basePoseMatrix, 15, y, 15, dataState6);
                    }
                }
                boolean blockOutline = this.shouldBlockBeOutlined(dataState6);
                boolean blockPlusX4 = plusX != null && this.shouldBlockBeOutlined(plusX[y * 16 + 3840]);
                blockPlusY = blocks != null && this.shouldBlockBeOutlined(blocks[index + 16]);
                blockPlusZ = plusZ != null && this.shouldBlockBeOutlined(plusZ[15 + y * 16]);
                blockPlusXY = plusX != null && this.shouldBlockBeOutlined(plusX[(y + 1) * 16 + 3840]);
                blockPlusXZ = plusXZ != null && this.shouldBlockBeOutlined(plusXZ[y * 16]);
                blockPlusYZ = plusZ != null && this.shouldBlockBeOutlined(plusZ[15 + (y + 1) * 16]);
                ChunkedBlockRegion.renderOutline(outlineBuilder, 15, y, 15, blockOutline, blockPlusX4, blockPlusY, blockPlusZ, blockPlusXY, blockPlusXZ, blockPlusYZ);
            }
            for (int x = 0; x < 15; ++x) {
                class_2680 dataState8;
                index = 4080 + x;
                class_2680 class_26807 = dataState8 = blocks == null ? null : blocks[index];
                if (dataState8 != null) {
                    blockPos.method_10103(offsetX + x, offsetY + 15, offsetZ + 15);
                    if (tessellatedBlockCache != null) {
                        tessellatedBlockCache.renderBlock(blockBuilder, renderManager, this, (class_2338)blockPos, x, 15, 15);
                    } else {
                        blockTessellator.tessellateBlockAndLiquidWithOffset(blockBuilder, renderManager, blockPos, rand, matrices, this, currentPoseMatrix, basePoseMatrix, x, 15, 15, dataState8);
                    }
                }
                boolean blockOutline = this.shouldBlockBeOutlined(dataState8);
                boolean blockPlusX5 = blocks != null && this.shouldBlockBeOutlined(blocks[index + 1]);
                blockPlusY = plusY != null && this.shouldBlockBeOutlined(plusY[x + 3840]);
                blockPlusZ = plusZ != null && this.shouldBlockBeOutlined(plusZ[x + 240]);
                blockPlusXY = plusY != null && this.shouldBlockBeOutlined(plusY[x + 1 + 3840]);
                blockPlusXZ = plusZ != null && this.shouldBlockBeOutlined(plusZ[x + 1 + 240]);
                blockPlusYZ = plusYZ != null && this.shouldBlockBeOutlined(plusYZ[x]);
                ChunkedBlockRegion.renderOutline(outlineBuilder, x, 15, 15, blockOutline, blockPlusX5, blockPlusY, blockPlusZ, blockPlusXY, blockPlusXZ, blockPlusYZ);
            }
            index = 4095;
            class_2680 class_26808 = dataState = blocks == null ? null : blocks[index];
            if (dataState != null) {
                blockPos.method_10103(offsetX + 15, offsetY + 15, offsetZ + 15);
                if (tessellatedBlockCache != null) {
                    tessellatedBlockCache.renderBlock(blockBuilder, renderManager, this, (class_2338)blockPos, 15, 15, 15);
                } else {
                    blockTessellator.tessellateBlockAndLiquidWithOffset(blockBuilder, renderManager, blockPos, rand, matrices, this, currentPoseMatrix, basePoseMatrix, 15, 15, 15, dataState);
                }
            }
            boolean blockOutline = this.shouldBlockBeOutlined(dataState);
            boolean blockPlusX6 = plusX != null && this.shouldBlockBeOutlined(plusX[4080]);
            boolean blockPlusY4 = plusY != null && this.shouldBlockBeOutlined(plusY[3855]);
            boolean blockPlusZ4 = plusZ != null && this.shouldBlockBeOutlined(plusZ[255]);
            boolean blockPlusXY4 = plusXY != null && this.shouldBlockBeOutlined(plusXY[3840]);
            boolean blockPlusXZ4 = plusXZ != null && this.shouldBlockBeOutlined(plusXZ[240]);
            boolean blockPlusYZ4 = plusYZ != null && this.shouldBlockBeOutlined(plusYZ[15]);
            ChunkedBlockRegion.renderOutline(outlineBuilder, 15, 15, 15, blockOutline, blockPlusX6, blockPlusY4, blockPlusZ4, blockPlusXY4, blockPlusXZ4, blockPlusYZ4);
            currentPoseMatrix.set((Matrix4fc)basePoseMatrix);
            if (blockBuilder.field_1554 == 0 && outlineBuilder.field_1554 == 0) {
                MeshDataHelper.discard(VersionUtilsClient.helperOldBufferBuilderEndOrDiscard(blockBuilder));
                MeshDataHelper.discard(VersionUtilsClient.helperOldBufferBuilderEndOrDiscard(outlineBuilder));
                chunkData = (ChunkData)this.renderData.chunkData.remove(pos);
                if (chunkData == null) continue;
                this.sortedChunkData.remove(chunkData);
                if (chunkData.block != null) {
                    chunkData.block.close();
                    chunkData.block = null;
                }
                if (chunkData.outline == null) continue;
                chunkData.outline.close();
                chunkData.outline = null;
                continue;
            }
            chunkData = (ChunkData)this.renderData.chunkData.get(pos);
            if (chunkData == null) {
                chunkData = new ChunkData(offsetX, offsetY, offsetZ);
                this.renderData.chunkData.put(pos, (Object)chunkData);
                float dx = this.lastSortChunkX * 16 - chunkData.offsetX;
                float dy = this.lastSortChunkY * 16 - chunkData.offsetY;
                float dz = this.lastSortChunkZ * 16 - chunkData.offsetZ;
                chunkData.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
                this.sortedChunkData.add(chunkData);
                addedNewChunk = true;
            }
            if (blockBuilder.field_1554 > 0) {
                MeshDataHelper.MeshDataAndSortState meshDataAndSortState = MeshDataHelper.buildAndSort(blockBuilder, class_8251.method_49906((float)(sortX - (float)chunkData.offsetX), (float)(sortY - (float)chunkData.offsetY), (float)(sortZ - (float)chunkData.offsetZ)));
                if (meshDataAndSortState != null) {
                    chunkData.sortState = meshDataAndSortState.sortStateWrapper();
                    if (chunkData.block == null) {
                        chunkData.block = new AxiomDrawBuffer(AxiomBufferUsage.STATIC_WRITE);
                    }
                    chunkData.block.upload(meshDataAndSortState.meshData());
                }
            } else {
                MeshDataHelper.discard(VersionUtilsClient.helperOldBufferBuilderEndOrDiscard(blockBuilder));
            }
            if (outlineBuilder.field_1554 > 0) {
                class_287.class_7433 meshData = VersionUtilsClient.helperOldBufferBuilderEndOrDiscard(outlineBuilder);
                if (meshData == null) continue;
                if (chunkData.outline == null) {
                    chunkData.outline = new AxiomDrawBuffer(AxiomBufferUsage.STATIC_WRITE);
                }
                chunkData.outline.upload(meshData);
                continue;
            }
            MeshDataHelper.discard(VersionUtilsClient.helperOldBufferBuilderEndOrDiscard(outlineBuilder));
        }
        if (!canResort) {
            if (addedNewChunk) {
                this.sortedChunkData.sort(Comparator.comparingDouble(c -> -c.distanceSqToCamera));
            }
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSortMillis < 250L) {
            if (addedNewChunk) {
                this.sortedChunkData.sort(Comparator.comparingDouble(c -> -c.distanceSqToCamera));
            }
            return;
        }
        this.lastSortMillis = currentTime;
        double dX = sortX - this.lastSortX;
        double dY = sortY - this.lastSortY;
        double dZ = sortZ - this.lastSortZ;
        if (dX * dX + dY * dY + dZ * dZ < 1.0) {
            if (addedNewChunk) {
                this.sortedChunkData.sort(Comparator.comparingDouble(c -> -c.distanceSqToCamera));
            }
            return;
        }
        this.lastSortX = sortX;
        this.lastSortY = sortY;
        this.lastSortZ = sortZ;
        int chunkX = class_4076.method_32204((double)sortX);
        int chunkY = class_4076.method_32204((double)sortY);
        int chunkZ = class_4076.method_32204((double)sortZ);
        boolean resortChunkList = chunkX != this.lastSortChunkX || chunkY != this.lastSortChunkY || chunkZ != this.lastSortChunkZ;
        for (ChunkData chunkData : this.sortedChunkData) {
            float relSortX = sortX - (float)chunkData.offsetX;
            float relSortY = sortY - (float)chunkData.offsetY;
            float relSortZ = sortZ - (float)chunkData.offsetZ;
            if (chunkData.sortState != null && chunkData.block != null) {
                class_287 bufferBuilder = blockProvider.begin(class_293.class_5596.field_27382, AxiomVertexFormats.AXIOM_BLOCK);
                chunkData.sortState = MeshDataHelper.resort(bufferBuilder, chunkData.sortState, chunkData.block, class_8251.method_49906((float)relSortX, (float)relSortY, (float)relSortZ));
            }
            if (!resortChunkList) continue;
            float dx = chunkX * 16 - chunkData.offsetX;
            float dy = chunkY * 16 - chunkData.offsetY;
            float dz = chunkZ * 16 - chunkData.offsetZ;
            chunkData.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
        }
        if (resortChunkList) {
            this.lastSortChunkX = chunkX;
            this.lastSortChunkY = chunkY;
            this.lastSortChunkZ = chunkZ;
            this.sortedChunkData.sort(Comparator.comparingDouble(c -> -c.distanceSqToCamera));
        } else if (addedNewChunk) {
            this.sortedChunkData.sort(Comparator.comparingDouble(c -> -c.distanceSqToCamera));
        }
    }

    private static void renderOutline(class_287 outlineBuilder, int x, int y, int z, boolean blockOutline, boolean blockPlusX, boolean blockPlusY, boolean blockPlusZ, boolean blockPlusXY, boolean blockPlusXZ, boolean blockPlusYZ) {
        if (blockOutline ^ blockPlusZ ^ blockPlusY ^ blockPlusYZ) {
            VersionUtilsClient.legacySetLineWidthIgnored(VersionUtilsClient.helperOldAddVertex((class_4588)outlineBuilder, x, y + 1, z + 1).method_39415(-1).method_22914(1.0f, 0.0f, 0.0f), RenderHelper.baseLineWidth);
            VersionUtilsClient.legacySetLineWidthIgnored(VersionUtilsClient.helperOldAddVertex((class_4588)outlineBuilder, x + 1, y + 1, z + 1).method_39415(-1).method_22914(1.0f, 0.0f, 0.0f), RenderHelper.baseLineWidth);
        }
        if (blockOutline ^ blockPlusZ ^ blockPlusX ^ blockPlusXZ) {
            VersionUtilsClient.legacySetLineWidthIgnored(VersionUtilsClient.helperOldAddVertex((class_4588)outlineBuilder, x + 1, y, z + 1).method_39415(-1).method_22914(0.0f, 1.0f, 0.0f), RenderHelper.baseLineWidth);
            VersionUtilsClient.legacySetLineWidthIgnored(VersionUtilsClient.helperOldAddVertex((class_4588)outlineBuilder, x + 1, y + 1, z + 1).method_39415(-1).method_22914(0.0f, 1.0f, 0.0f), RenderHelper.baseLineWidth);
        }
        if (blockOutline ^ blockPlusX ^ blockPlusY ^ blockPlusXY) {
            VersionUtilsClient.legacySetLineWidthIgnored(VersionUtilsClient.helperOldAddVertex((class_4588)outlineBuilder, x + 1, y + 1, z).method_39415(-1).method_22914(0.0f, 0.0f, 1.0f), RenderHelper.baseLineWidth);
            VersionUtilsClient.legacySetLineWidthIgnored(VersionUtilsClient.helperOldAddVertex((class_4588)outlineBuilder, x + 1, y + 1, z + 1).method_39415(-1).method_22914(0.0f, 0.0f, 1.0f), RenderHelper.baseLineWidth);
        }
    }

    public class_2338 min() {
        return this.min;
    }

    public class_2338 max() {
        return this.max;
    }

    public void forEachEntry(PositionConsumer<class_2680> consumer) {
        this.blockData.forEachEntry(consumer);
    }

    public void forEachEntryLowestFirst(PositionConsumer<class_2680> consumer) {
        LongArrayList chunks = new LongArrayList((LongCollection)this.blockData.chunkKeySet());
        chunks.sort((first, second) -> Integer.compare(class_2338.method_10071((long)first), class_2338.method_10071((long)second)));
        LongIterator longIterator = chunks.longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            class_2680[] chunk = this.blockData.getChunk(pos);
            int cx = class_2338.method_10061((long)pos) * 16;
            int cy = class_2338.method_10071((long)pos) * 16;
            int cz = class_2338.method_10083((long)pos) * 16;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        class_2680 t2;
                        if ((t2 = chunk[index++]) == null) continue;
                        consumer.accept(cx + x, cy + y, cz + z, t2);
                    }
                }
            }
        }
    }

    public void forEachChunk(PositionConsumer<class_2680[]> consumer) {
        this.blockData.forEachChunk(consumer);
    }

    public ChunkedBlockRegion rotate(class_2350.class_2351 axis, int count) {
        if ((count %= 4) < 0) {
            count += 4;
        }
        if (count == 0) {
            return this;
        }
        ChunkedBlockRegion rotated = new ChunkedBlockRegion();
        block0 : switch (axis) {
            case field_11048: {
                switch (count) {
                    case 1: {
                        this.forEachEntry((x, y, z, block) -> rotated.addBlock(x, -z, y, BlockHelper.rotateX(block, class_2470.field_11465)));
                        break block0;
                    }
                    case 2: {
                        this.forEachEntry((x, y, z, block) -> rotated.addBlock(x, -y, -z, BlockHelper.rotateX(block, class_2470.field_11464)));
                        break block0;
                    }
                    case 3: {
                        this.forEachEntry((x, y, z, block) -> rotated.addBlock(x, z, -y, BlockHelper.rotateX(block, class_2470.field_11463)));
                        break block0;
                    }
                }
                throw new FaultyImplementationError();
            }
            case field_11052: {
                switch (count) {
                    case 1: {
                        this.forEachEntry((x, y, z, block) -> rotated.addBlock(z, y, -x, BlockHelper.rotateY(block, class_2470.field_11465)));
                        break block0;
                    }
                    case 2: {
                        this.forEachEntry((x, y, z, block) -> rotated.addBlock(-x, y, -z, BlockHelper.rotateY(block, class_2470.field_11464)));
                        break block0;
                    }
                    case 3: {
                        this.forEachEntry((x, y, z, block) -> rotated.addBlock(-z, y, x, BlockHelper.rotateY(block, class_2470.field_11463)));
                        break block0;
                    }
                }
                throw new FaultyImplementationError();
            }
            case field_11051: {
                switch (count) {
                    case 1: {
                        this.forEachEntry((x, y, z, block) -> rotated.addBlock(-y, x, z, BlockHelper.rotateZ(block, class_2470.field_11465)));
                        break block0;
                    }
                    case 2: {
                        this.forEachEntry((x, y, z, block) -> rotated.addBlock(-x, -y, z, BlockHelper.rotateZ(block, class_2470.field_11464)));
                        break block0;
                    }
                    case 3: {
                        this.forEachEntry((x, y, z, block) -> rotated.addBlock(y, -x, z, BlockHelper.rotateZ(block, class_2470.field_11463)));
                        break block0;
                    }
                }
                throw new FaultyImplementationError();
            }
        }
        return rotated;
    }

    public ChunkedBlockRegion flip(class_2350.class_2351 axis) {
        ChunkedBlockRegion flipped = new ChunkedBlockRegion();
        switch (axis) {
            case field_11048: {
                this.forEachEntry((x, y, z, block) -> flipped.addBlock(-x, y, z, BlockHelper.flipX(block)));
                break;
            }
            case field_11052: {
                this.forEachEntry((x, y, z, block) -> flipped.addBlock(x, -y, z, BlockHelper.flipY(block)));
                break;
            }
            case field_11051: {
                this.forEachEntry((x, y, z, block) -> flipped.addBlock(x, y, -z, BlockHelper.flipZ(block)));
            }
        }
        return flipped;
    }

    public void save(class_2499 list) {
        Codec<class_2841<class_2680>> codec = BlockBuffer.getCodecForEmptyBlockState(BlockBuffer.EMPTY_STATE);
        this.blockData.forEachChunk((int cx, int cy, int cz, T[] data) -> {
            class_2841<class_2680> container = DFUHelper.createPalettedContainer((class_2359<class_2680>)class_2248.field_10651, BlockBuffer.EMPTY_STATE);
            boolean containsBlock = false;
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        class_2680 blockState;
                        if ((blockState = data[index++]) == null) continue;
                        container.method_35321(x, y, z, (Object)blockState);
                        containsBlock = true;
                    }
                }
            }
            if (!containsBlock) {
                return;
            }
            class_2487 tag = new class_2487();
            tag.method_10569("X", cx);
            tag.method_10569("Y", cy);
            tag.method_10569("Z", cz);
            class_2520 encoded = (class_2520)VersionUtils.getOrThrow(codec.encodeStart((DynamicOps)class_2509.field_11560, container));
            tag.method_10566("BlockStates", encoded);
            list.add((Object)tag);
        });
    }

    public LongSet chunkKeySet() {
        return this.blockData.chunkKeySet();
    }

    public class_2680[] getChunk(int cx, int cy, int cz) {
        return this.blockData.getChunk(cx, cy, cz);
    }

    public Position2ObjectMap<class_2680> copyBlockData() {
        return this.blockData.copy();
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int count() {
        return this.count;
    }

    public void clear() {
        if (this.renderData != null) {
            for (ChunkData chunkDatum : this.renderData.chunkData.values()) {
                if (chunkDatum.block != null) {
                    chunkDatum.block.close();
                }
                if (chunkDatum.outline == null) continue;
                chunkDatum.outline.close();
            }
            this.renderData.chunkData.clear();
            this.renderData.tessellatedBlockCache.clear();
        }
        this.blockData.clear();
        this.sortedChunkData.clear();
        this.dirtyChunks.clear();
        this.min = null;
        this.max = null;
        this.uniqueBlockState = null;
        this.count = 0;
    }

    public class_2338 getCenter() {
        if (this.min == null || this.max == null) {
            return class_2338.field_10980;
        }
        return new class_2338((this.min.method_10263() + this.max.method_10263()) / 2, (this.min.method_10264() + this.max.method_10264()) / 2, (this.min.method_10260() + this.max.method_10260()) / 2);
    }

    private boolean shouldBlockBeOutlined(class_2680 blockState) {
        if (blockState == null) {
            return false;
        }
        if (this.drawOutlineForNonBlockingMotion) {
            return !blockState.method_26215();
        }
        return blockState.method_51366();
    }

    public void addBlockIfNotPresent(int x, int y, int z, class_2680 block) {
        if (this.blockData.get(x, y, z) == null) {
            this.addBlock(x, y, z, block);
        }
    }

    public void addBlock(int x, int y, int z, class_2680 block) {
        boolean onNegZBorder;
        Objects.requireNonNull(block);
        if (this.count == 0) {
            this.min = new class_2338.class_2339(x, y, z);
            this.max = new class_2338.class_2339(x, y, z);
            this.uniqueBlockState = block;
        } else {
            if (x < this.min.method_10263()) {
                this.min.method_33097(x);
            }
            if (y < this.min.method_10264()) {
                this.min.method_33098(y);
            }
            if (z < this.min.method_10260()) {
                this.min.method_33099(z);
            }
            if (x > this.max.method_10263()) {
                this.max.method_33097(x);
            }
            if (y > this.max.method_10264()) {
                this.max.method_33098(y);
            }
            if (z > this.max.method_10260()) {
                this.max.method_33099(z);
            }
            if (this.uniqueBlockState != block) {
                this.uniqueBlockState = null;
            }
        }
        class_2680 oldState = this.blockData.getAndPut(x, y, z, block);
        if (oldState == block) {
            return;
        }
        if (oldState == null) {
            ++this.count;
        }
        int chunkX = x >> 4;
        int chunkY = y >> 4;
        int chunkZ = z >> 4;
        boolean onNegXBorder = (x & 0xF) == 0;
        boolean onNegYBorder = (y & 0xF) == 0;
        boolean bl = onNegZBorder = (z & 0xF) == 0;
        if (onNegXBorder) {
            this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ));
            if (onNegYBorder) {
                this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)(chunkY - 1), (int)chunkZ));
            }
            if (onNegZBorder) {
                this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)(chunkZ - 1)));
            }
        } else if ((x & 0xF) == 15) {
            this.dirtyChunks.add(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ));
        }
        if (onNegYBorder) {
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ));
            if (onNegZBorder) {
                this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)(chunkZ - 1)));
            }
        } else if ((y & 0xF) == 15) {
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ));
        }
        if (onNegZBorder) {
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1)));
        } else if ((z & 0xF) == 15) {
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1)));
        }
        this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)chunkZ));
    }

    public void addBlock(class_2338 pos, class_2680 block) {
        this.addBlock(pos.method_10263(), pos.method_10264(), pos.method_10260(), block);
    }

    public void addBlockWithoutDirty(int x, int y, int z, class_2680 block) {
        Objects.requireNonNull(block);
        if (this.min == null) {
            this.min = new class_2338.class_2339(x, y, z);
        } else {
            if (x < this.min.method_10263()) {
                this.min.method_33097(x);
            }
            if (y < this.min.method_10264()) {
                this.min.method_33098(y);
            }
            if (z < this.min.method_10260()) {
                this.min.method_33099(z);
            }
        }
        if (this.max == null) {
            this.max = new class_2338.class_2339(x, y, z);
        } else {
            if (x > this.max.method_10263()) {
                this.max.method_33097(x);
            }
            if (y > this.max.method_10264()) {
                this.max.method_33098(y);
            }
            if (z > this.max.method_10260()) {
                this.max.method_33099(z);
            }
        }
        class_2680 oldState = this.blockData.getAndPut(x, y, z, block);
        if (oldState == null) {
            ++this.count;
        }
    }

    @Deprecated
    public void unsafeRemoveBlockWithoutDirty(int x, int y, int z) {
        class_2680 oldState = this.blockData.getAndPut(x, y, z, null);
        if (oldState != null) {
            --this.count;
        }
    }

    public void dirtyAll() {
        LongIterator iterator = this.blockData.chunkKeySet().iterator();
        while (iterator.hasNext()) {
            long chunkPos = iterator.nextLong();
            int chunkX = class_2338.method_10061((long)chunkPos);
            int chunkY = class_2338.method_10071((long)chunkPos);
            int chunkZ = class_2338.method_10083((long)chunkPos);
            this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)chunkZ));
            this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)(chunkY - 1), (int)chunkZ));
            this.dirtyChunks.add(class_2338.method_10064((int)(chunkX - 1), (int)chunkY, (int)(chunkZ - 1)));
            this.dirtyChunks.add(class_2338.method_10064((int)(chunkX + 1), (int)chunkY, (int)chunkZ));
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)chunkZ));
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY - 1), (int)(chunkZ - 1)));
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)(chunkY + 1), (int)chunkZ));
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ - 1)));
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)(chunkZ + 1)));
            this.dirtyChunks.add(class_2338.method_10064((int)chunkX, (int)chunkY, (int)chunkZ));
        }
    }

    public class_2680 getBlockStateOrDelegate(class_2338 blockPos, class_1937 level) {
        class_2680 blockState = this.blockData.get(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        if (blockState != null) {
            return blockState;
        }
        return level.method_8320(blockPos);
    }

    public float method_24852(class_2350 direction, boolean shaded) {
        switch (direction) {
            case field_11033: {
                return 0.5f;
            }
            case field_11036: {
                return 1.0f;
            }
            case field_11043: 
            case field_11035: {
                return 0.8f;
            }
            case field_11039: 
            case field_11034: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    public class_3568 method_22336() {
        throw new UnsupportedOperationException();
    }

    public int method_8314(class_1944 type2, class_2338 pos) {
        return 15;
    }

    public int method_22335(class_2338 pos, int ambientDarkness) {
        return 15;
    }

    public boolean method_8311(class_2338 pos) {
        return false;
    }

    @Nullable
    public class_2791 method_8402(int i, int j, class_2806 chunkStatus, boolean bl) {
        return null;
    }

    public int method_8624(class_2902.class_2903 types, int i, int j) {
        return 0;
    }

    public int method_8594() {
        return 0;
    }

    public class_4543 method_22385() {
        return null;
    }

    public int method_23752(class_2338 pos, class_6539 colorResolver) {
        if (colorResolver == class_1163.field_5666) {
            return 4159204;
        }
        if (colorResolver == class_1163.field_5665) {
            return class_1933.method_8377((double)0.8f, (double)0.4f);
        }
        if (colorResolver == class_1163.field_5664) {
            return class_1926.method_8344((double)0.8f, (double)0.4f);
        }
        return 0xFFFFFF;
    }

    public class_6880<class_1959> method_22387(int i, int j, int k) {
        return null;
    }

    public boolean method_8608() {
        return false;
    }

    public int method_8615() {
        return 70;
    }

    public class_2874 method_8597() {
        return DUMMY_DIMENSION_TYPE;
    }

    @Nullable
    public class_2586 method_8321(class_2338 pos) {
        return null;
    }

    public class_2680 getBlockStateOrNull(int x, int y, int z) {
        return this.blockData.get(x, y, z);
    }

    public class_2680 getBlockStateOrAir(int x, int y, int z) {
        class_2680 blockState = this.blockData.get(x, y, z);
        if (blockState != null) {
            return blockState;
        }
        return AIR;
    }

    @NotNull
    public class_2680 method_8320(class_2338 pos) {
        class_2680 blockState = this.blockData.get(pos.method_10263(), pos.method_10264(), pos.method_10260());
        if (blockState != null) {
            return blockState;
        }
        return AIR;
    }

    @NotNull
    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_26227();
    }

    public int method_31607() {
        return this.min.method_10264();
    }

    public int method_31605() {
        return this.max.method_10264() - this.min.method_10264() + 1;
    }

    @NotNull
    public class_5455 method_30349() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public class_7699 method_45162() {
        return class_7699.method_45397();
    }

    public long method_39224() {
        return 0L;
    }

    @NotNull
    public class_6756<class_2248> method_8397() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public class_6756<class_3611> method_8405() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public class_5217 method_8401() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public class_1266 method_8404(class_2338 blockPos) {
        return new class_1266(class_1267.field_5802, 0L, 0L, 0.0f);
    }

    @Nullable
    public MinecraftServer method_8503() {
        return null;
    }

    @NotNull
    public class_2802 method_8398() {
        return this.emptyChunkSource;
    }

    @NotNull
    public class_5819 method_8409() {
        return this.randomSource;
    }

    public void method_8396(@Nullable class_1657 player, class_2338 blockPos, class_3414 soundEvent, class_3419 soundSource, float f, float g2) {
    }

    public void method_8406(class_2394 particleOptions, double d, double e, double f, double g2, double h2, double i) {
    }

    public void method_8444(@Nullable class_1657 player, int i, class_2338 blockPos, int j) {
    }

    public void method_32888(class_5712 gameEvent, class_243 vec3, class_5712.class_7397 context) {
    }

    public class_2784 method_8621() {
        throw new UnsupportedOperationException();
    }

    public List<class_1297> method_8333(@Nullable class_1297 entity, class_238 aABB, Predicate<? super class_1297> predicate) {
        return List.of();
    }

    public <T extends class_1297> List<T> method_18023(class_5575<class_1297, T> entityTypeTest, class_238 aABB, Predicate<? super T> predicate) {
        return List.of();
    }

    public List<? extends class_1657> method_18456() {
        return List.of();
    }

    public boolean method_16358(class_2338 blockPos, Predicate<class_2680> predicate) {
        return predicate.test(this.method_8320(blockPos));
    }

    public boolean method_35237(class_2338 blockPos, Predicate<class_3610> predicate) {
        return predicate.test(this.method_8316(blockPos));
    }

    public boolean method_30092(class_2338 blockPos, class_2680 blockState, int i, int j) {
        this.addBlock(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), blockState);
        return true;
    }

    public boolean method_8650(class_2338 blockPos, boolean bl) {
        this.addBlock(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), AIR);
        return true;
    }

    public boolean method_30093(class_2338 blockPos, boolean bl, @Nullable class_1297 entity, int i) {
        this.addBlock(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260(), AIR);
        return true;
    }

    public void method_39279(class_2338 blockPos, class_2248 block, int i) {
    }

    public void method_39281(class_2338 blockPos, class_3611 fluid, int i) {
    }

    public void method_39280(class_2338 blockPos, class_2248 block, int i, class_1953 tickPriority) {
    }

    public void method_39282(class_2338 blockPos, class_3611 fluid, int i, class_1953 tickPriority) {
    }

    private record RenderData(Long2ObjectMap<ChunkData> chunkData, TessellatedBlockCache tessellatedBlockCache, VertexConsumerProvider outlineProvider) {
    }

    private static final class ChunkData
    extends IntrusiveLinkedElement<ChunkData> {
        AxiomDrawBuffer block = null;
        AxiomDrawBuffer outline = null;
        SortStateWrapper sortState = null;
        int offsetX;
        int offsetY;
        int offsetZ;
        float distanceSqToCamera;

        public ChunkData(int offsetX, int offsetY, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }
    }

    private record CleanState(RenderData renderData) implements Runnable
    {
        @Override
        public void run() {
            for (ChunkData chunkDatum : this.renderData.chunkData.values()) {
                if (chunkDatum.block != null) {
                    EditorUI.deferredClose(chunkDatum.block);
                }
                if (chunkDatum.outline == null) continue;
                EditorUI.deferredClose(chunkDatum.outline);
            }
            this.renderData.chunkData.clear();
            this.renderData.tessellatedBlockCache.close();
            this.renderData.outlineProvider.close();
        }
    }
}

