/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.pather;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.tools.Tool;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ToolPatherPoint
implements com.moulberry.axiomclientapi.pathers.ToolPatherPoint {
    private class_243 lastPosition = null;
    private class_243 lastLookDirection = null;
    public boolean includeNonSolid;
    public boolean includeFluids;
    private static final class_2350.class_2351[][][] AXIS_PERMUTATIONS = ToolPatherPoint.computeAxisPermutationArray();
    private static final class_2350.class_2351[][] AXIS_PERMUTATIONS_NO_X_PRIO_Y = new class_2350.class_2351[][]{{class_2350.class_2351.field_11052, class_2350.class_2351.field_11051}, {class_2350.class_2351.field_11051, class_2350.class_2351.field_11052}};
    private static final class_2350.class_2351[][] AXIS_PERMUTATIONS_NO_X_PRIO_Z = new class_2350.class_2351[][]{{class_2350.class_2351.field_11051, class_2350.class_2351.field_11052}, {class_2350.class_2351.field_11052, class_2350.class_2351.field_11051}};
    private static final class_2350.class_2351[][] AXIS_PERMUTATIONS_NO_Y_PRIO_X = new class_2350.class_2351[][]{{class_2350.class_2351.field_11048, class_2350.class_2351.field_11051}, {class_2350.class_2351.field_11051, class_2350.class_2351.field_11048}};
    private static final class_2350.class_2351[][] AXIS_PERMUTATIONS_NO_Y_PRIO_Z = new class_2350.class_2351[][]{{class_2350.class_2351.field_11051, class_2350.class_2351.field_11048}, {class_2350.class_2351.field_11048, class_2350.class_2351.field_11051}};
    private static final class_2350.class_2351[][] AXIS_PERMUTATIONS_NO_Z_PRIO_X = new class_2350.class_2351[][]{{class_2350.class_2351.field_11048, class_2350.class_2351.field_11052}, {class_2350.class_2351.field_11052, class_2350.class_2351.field_11048}};
    private static final class_2350.class_2351[][] AXIS_PERMUTATIONS_NO_Z_PRIO_Y = new class_2350.class_2351[][]{{class_2350.class_2351.field_11052, class_2350.class_2351.field_11048}, {class_2350.class_2351.field_11048, class_2350.class_2351.field_11052}};

    public ToolPatherPoint(boolean includeNonSolid) {
        this.includeNonSolid = includeNonSolid;
        this.includeFluids = Tool.defaultIncludeFluids() && this.includeNonSolid;
    }

    public ToolPatherPoint() {
        this(true);
    }

    public void update(TriIntConsumer consumer) {
        class_746 entity = class_310.method_1551().field_1724;
        if (entity == null || entity != class_310.method_1551().field_1719) {
            return;
        }
        class_243 lookDirection = null;
        if (EditorUI.isActive()) {
            if (EditorUI.isMovingCamera()) {
                return;
            }
            lookDirection = EditorUI.getMouseLookVector();
        } else if (class_310.method_1551().field_1719 != null) {
            lookDirection = class_310.method_1551().field_1719.method_5720();
        }
        if (lookDirection == null) {
            return;
        }
        class_243 start = entity.method_33571();
        if (this.lastLookDirection == null || this.lastPosition == null) {
            RayCaster.RaycastResult raycastResult = RayCaster.raycast(entity.method_37908(), start, lookDirection, false, this.includeFluids, this.includeNonSolid);
            if (raycastResult != null) {
                this.lastLookDirection = lookDirection;
                this.lastPosition = raycastResult.getPositionWithinBlock();
                consumer.accept(raycastResult.blockPos().method_10263(), raycastResult.blockPos().method_10264(), raycastResult.blockPos().method_10260());
            }
        } else {
            double dot = this.lastLookDirection.method_1026(lookDirection);
            double angleChange = Math.toDegrees(Math.acos(dot));
            int steps = 1;
            if (angleChange > 1.0) {
                steps = (int)Math.ceil(angleChange);
            }
            for (int i = 1; i <= steps; ++i) {
                float f = (float)i / (float)steps;
                class_243 look = this.lastLookDirection.method_35590(lookDirection, (double)f);
                RayCaster.RaycastResult raycastResult = RayCaster.raycast(entity.method_37908(), start, look, false, this.includeFluids, this.includeNonSolid);
                if (raycastResult == null) continue;
                class_243 withinBlock = raycastResult.getPositionWithinBlock();
                ToolPatherPoint.smartDDASkipFrom(entity.method_37908(), this.lastPosition, withinBlock, this.includeNonSolid, consumer);
                this.lastPosition = withinBlock;
            }
            this.lastLookDirection = lookDirection;
        }
    }

    public static void smartDDASkipFrom(class_1937 world, class_243 from, class_243 to, boolean includeNonSolid, TriIntConsumer consumer) {
        int dz;
        int dy;
        int fromX = (int)Math.floor(from.field_1352);
        int fromY = (int)Math.floor(from.field_1351);
        int fromZ = (int)Math.floor(from.field_1350);
        int toX = (int)Math.floor(to.field_1352);
        int toY = (int)Math.floor(to.field_1351);
        int toZ = (int)Math.floor(to.field_1350);
        if (fromX == toX && fromY == toY && fromZ == toZ) {
            return;
        }
        int dx = Math.abs(toX - fromX);
        if (dx + (dy = Math.abs(toY - fromY)) + (dz = Math.abs(toZ - fromZ)) == 1) {
            consumer.accept(toX, toY, toZ);
            return;
        }
        if (dx <= 1 && dy <= 1 && dz <= 1) {
            class_243 ray = to.method_1020(from).method_1029();
            double deltaDistX = Math.abs(1.0 / ray.field_1352);
            double deltaDistY = Math.abs(1.0 / ray.field_1351);
            double deltaDistZ = Math.abs(1.0 / ray.field_1350);
            double sideDistX = (ray.field_1352 > 0.0 ? 1.0 - from.field_1352 + (double)fromX : from.field_1352 - (double)fromX) * deltaDistX;
            double sideDistY = (ray.field_1351 > 0.0 ? 1.0 - from.field_1351 + (double)fromY : from.field_1351 - (double)fromY) * deltaDistY;
            double sideDistZ = (ray.field_1350 > 0.0 ? 1.0 - from.field_1350 + (double)fromZ : from.field_1350 - (double)fromZ) * deltaDistZ;
            if (Double.isNaN(sideDistX)) {
                sideDistX = Double.POSITIVE_INFINITY;
            }
            if (Double.isNaN(sideDistY)) {
                sideDistY = Double.POSITIVE_INFINITY;
            }
            if (Double.isNaN(sideDistZ)) {
                sideDistZ = Double.POSITIVE_INFINITY;
            }
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            class_2350.class_2351[][] axisPermutations = dx == 0 ? (sideDistY < sideDistZ ? AXIS_PERMUTATIONS_NO_X_PRIO_Y : AXIS_PERMUTATIONS_NO_X_PRIO_Z) : (dy == 0 ? (sideDistX < sideDistZ ? AXIS_PERMUTATIONS_NO_Y_PRIO_X : AXIS_PERMUTATIONS_NO_Y_PRIO_Z) : (dz == 0 ? (sideDistX < sideDistY ? AXIS_PERMUTATIONS_NO_Z_PRIO_X : AXIS_PERMUTATIONS_NO_Z_PRIO_Y) : AXIS_PERMUTATIONS[ToolPatherPoint.calculatePriorityIndex(sideDistX, sideDistY, sideDistZ)]));
            block10: for (class_2350.class_2351[] axisPermutation : axisPermutations) {
                int x = fromX;
                int y = fromY;
                int z = fromZ;
                for (class_2350.class_2351 axis : axisPermutation) {
                    switch (axis) {
                        case field_11048: {
                            x = toX;
                            break;
                        }
                        case field_11052: {
                            y = toY;
                            break;
                        }
                        case field_11051: {
                            z = toZ;
                        }
                    }
                    if (x == toX && y == toY && z == toZ) {
                        x = fromX;
                        y = fromY;
                        z = fromZ;
                        for (class_2350.class_2351 axis2 : axisPermutation) {
                            switch (axis2) {
                                case field_11048: {
                                    x = toX;
                                    break;
                                }
                                case field_11052: {
                                    y = toY;
                                    break;
                                }
                                case field_11051: {
                                    z = toZ;
                                }
                            }
                            consumer.accept(x, y, z);
                        }
                        return;
                    }
                    class_2680 blockState = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    if (blockState.method_26215() || !includeNonSolid && blockState.method_45474()) continue block10;
                }
            }
        }
        Rasterization3D.ddaSkipFrom(from, to, consumer);
    }

    private static class_2350.class_2351[][][] computeAxisPermutationArray() {
        class_2350.class_2351[][] axes = new class_2350.class_2351[][]{{class_2350.class_2351.field_11048, class_2350.class_2351.field_11052, class_2350.class_2351.field_11051}, {class_2350.class_2351.field_11048, class_2350.class_2351.field_11051, class_2350.class_2351.field_11052}, {class_2350.class_2351.field_11052, class_2350.class_2351.field_11048, class_2350.class_2351.field_11051}, {class_2350.class_2351.field_11052, class_2350.class_2351.field_11051, class_2350.class_2351.field_11048}, {class_2350.class_2351.field_11051, class_2350.class_2351.field_11048, class_2350.class_2351.field_11052}, {class_2350.class_2351.field_11051, class_2350.class_2351.field_11052, class_2350.class_2351.field_11048}};
        class_2350.class_2351[][][] allAxisByPriority = new class_2350.class_2351[6][][];
        for (int prio = 0; prio < 6; ++prio) {
            class_2350.class_2351[][] sortedAxes = (class_2350.class_2351[][])Arrays.copyOf(axes, 6);
            class_2350.class_2351[] order = axes[prio];
            Arrays.sort(sortedAxes, Comparator.comparingInt(triple -> {
                int priority = 0;
                if (triple[0] == order[0]) {
                    priority -= 1000;
                } else if (triple[0] == order[1]) {
                    priority -= 100;
                }
                if (triple[1] == order[0]) {
                    priority -= 10;
                } else if (triple[1] == order[1]) {
                    --priority;
                }
                return priority;
            }));
            allAxisByPriority[prio] = sortedAxes;
        }
        return allAxisByPriority;
    }

    private static int calculatePriorityIndex(double sideDistX, double sideDistY, double sideDistZ) {
        if (sideDistX < sideDistY && sideDistX < sideDistZ) {
            if (sideDistY < sideDistZ) {
                return 0;
            }
            return 1;
        }
        if (sideDistY < sideDistZ) {
            if (sideDistX < sideDistZ) {
                return 2;
            }
            return 3;
        }
        if (sideDistX < sideDistY) {
            return 4;
        }
        return 5;
    }
}

