/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.packets;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.AxiomClient;
import com.moulberry.axiom.ClientEvents;
import com.moulberry.axiom.HotbarManager;
import com.moulberry.axiom.ServerConfig;
import com.moulberry.axiom.editor.views.ViewManager;
import com.moulberry.axiom.packets.AxiomClientboundPacket;
import com.moulberry.axiom.utils.BlockHelper;
import java.util.Set;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5455;

public class AxiomClientboundEnable
implements AxiomClientboundPacket {
    private static final class_2960 IDENTIFIER = new class_2960("axiom:enable");
    private boolean enabled;
    private ServerConfig config;
    public static ServerConfig lastReadServerConfig = null;

    public AxiomClientboundEnable() {
        this(true, ServerConfig.createDefault());
    }

    public AxiomClientboundEnable(boolean enabled, ServerConfig config) {
        this.enabled = enabled;
        this.config = config;
    }

    public AxiomClientboundEnable(class_2540 friendlyByteBuf) {
        try {
            this.enabled = friendlyByteBuf.readBoolean();
            if (this.enabled) {
                this.config = ServerConfig.read(friendlyByteBuf);
                if (this.config.setBufferMaxSize() < 30000) {
                    throw new RuntimeException("Max Buffer Size is too low, got " + this.config.setBufferMaxSize() + ", minimum 30000");
                }
                lastReadServerConfig = this.config;
            } else {
                this.config = null;
            }
        }
        catch (Exception e) {
            Axiom.LOGGER.error("Error while reading AxiomClientboundEnable", e);
            this.enabled = false;
            this.config = null;
        }
        if (friendlyByteBuf.readerIndex() < friendlyByteBuf.writerIndex()) {
            friendlyByteBuf.readerIndex(friendlyByteBuf.writerIndex());
        }
    }

    @Override
    public class_2960 packetIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public void write(class_2540 friendlyByteBuf) {
        friendlyByteBuf.writeBoolean(this.enabled);
        if (this.enabled) {
            this.config.write(friendlyByteBuf);
        }
    }

    @Override
    public void handle(class_310 client, class_5455 registryAccess) {
        boolean wasNotEnabled = Axiom.getInstance().serverConfig == null;
        Axiom.getInstance().serverConfig = this.config;
        if (wasNotEnabled && this.config != null) {
            AxiomClient.onAxiomEnabled(client);
        }
        BlockHelper.ignoreRotation = this.config != null ? this.config.ignoreRotationSet() : Set.of();
        ClientEvents.setNoPhysicalTrigger = TriState.DEFAULT;
        HotbarManager.updateLocation();
        ViewManager.updateLocation();
    }

    public static void register() {
        AxiomClientboundPacket.register(IDENTIFIER, AxiomClientboundEnable::new);
    }
}

