/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows.operations;

import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.block_maps.LegacyBlocks;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.clipboard.SelectionBuffer;
import com.moulberry.axiom.custom_blocks.CustomBlock;
import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.editor.widgets.SelectBlockWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.operations.ReplaceCopyPropertiesOperation;
import com.moulberry.axiom.operations.ReplaceOperation;
import com.moulberry.axiom.tools.ToolManager;
import com.moulberry.axiom.utils.BlockCondition;
import imgui.ImGui;
import imgui.ImVec2;
import imgui.type.ImString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class QuickReplaceWindow {
    private static final List<CustomBlock> fromBlocks = new ArrayList<CustomBlock>();
    private static boolean fromBlocksHasProperties = false;
    private static BlockList.MinecraftOrCustomTagSet fromTag;
    private static final SelectBlockWidget toBlockWidget;
    public static boolean openQuickReplaceWindow;
    private static Set<class_2248> selectedBlocks;
    private static boolean filterSelectedBlocks;
    private static boolean copyProperties;
    private static boolean fromJustOpened;
    private static boolean fromShowingTags;
    private static List<BlockList.Entry> fromSearchedBlocks;

    public static boolean fromHasProperties() {
        return fromBlocksHasProperties || fromTag != null;
    }

    public static void render(BlockList blockList) {
        boolean openFrom;
        if (Placement.INSTANCE.isPlacing()) {
            return;
        }
        boolean bl = openFrom = EditorUI.canProcessKeybinds && Keybinds.QUICK_REPLACE.isPressed(false) && !Selection.getSelectionBuffer().isEmpty();
        if (openFrom || openQuickReplaceWindow) {
            if (ToolManager.isToolActive()) {
                ToolManager.getCurrentTool().reset();
            }
            if (Selection.getSelectionBuffer().isEmpty()) {
                return;
            }
            ImGui.openPopup("###SelectBlockModalFrom");
            selectedBlocks = null;
            fromBlocks.clear();
            fromBlocksHasProperties = false;
            fromTag = null;
            fromJustOpened = true;
            fromShowingTags = false;
            openQuickReplaceWindow = false;
        } else if (Selection.getSelectionBuffer().isEmpty()) {
            return;
        }
        if (QuickReplaceWindow.renderFromSelector(AxiomI18n.get("axiom.keybinds.quick_replace.replace_from"), blockList)) {
            toBlockWidget.open();
        }
        if (!fromBlocks.isEmpty() || fromTag != null) {
            toBlockWidget.render(AxiomI18n.get("axiom.keybinds.quick_replace.replace_to"), blockList);
            CustomBlockState blockState = toBlockWidget.getResultState();
            if (blockState != null) {
                BlockCondition blockCondition = null;
                if (fromTag != null) {
                    blockCondition = BlockCondition.fromMinecraftOrCustomTag(fromTag);
                } else if (!fromBlocks.isEmpty()) {
                    blockCondition = BlockCondition.fromCustomBlocks(fromBlocks);
                }
                if (blockCondition != null) {
                    if (copyProperties && QuickReplaceWindow.fromHasProperties()) {
                        ReplaceCopyPropertiesOperation.replace(blockCondition, blockState);
                    } else {
                        ReplaceOperation.replace(blockCondition, blockState.getVanillaState());
                    }
                }
                fromBlocks.clear();
                fromBlocksHasProperties = false;
                fromTag = null;
            }
        }
    }

    public static boolean renderFromSelector(String label, BlockList blockList) {
        boolean justOpened = fromJustOpened;
        fromJustOpened = false;
        if (justOpened) {
            blockList.search("", QuickReplaceWindow.getFromFilter(), true);
            fromSearchedBlocks = blockList.getBlocks();
        }
        ImVec2 center = ImGui.getMainViewport().getCenter();
        ImGui.setNextWindowPos(center.x, center.y, 8, 0.5f, 0.5f);
        if (ImGuiHelper.beginPopupModalCloseable(label + "###SelectBlockModalFrom", 320)) {
            boolean effectiveShowingTags;
            ImString searchInput = new ImString(blockList.getLastSearchRaw(), 64);
            if (justOpened) {
                ImGui.setKeyboardFocusHere();
            }
            if (ImGui.inputText(AxiomI18n.get("axiom.widget.search_block"), searchInput)) {
                String search = ImGuiHelper.getString(searchInput);
                blockList.search(search, QuickReplaceWindow.getFromFilter());
                fromSearchedBlocks = blockList.getBlocks();
                String[] split = search.split(":");
                if (split.length >= 1) {
                    try {
                        class_2680 blockState;
                        int blockId = Integer.parseInt(split[0]);
                        int blockData = 0;
                        if (split.length >= 2) {
                            blockData = Integer.parseInt(split[1]);
                        }
                        if (blockId <= 255 && blockData <= 15 && (blockState = LegacyBlocks.getLegacyBlocks()[blockId * 16 + blockData]) != null) {
                            fromSearchedBlocks = new ArrayList<BlockList.Entry>(fromSearchedBlocks);
                            fromSearchedBlocks.add(0, BlockList.createEntry(blockState));
                        }
                    }
                    catch (NumberFormatException blockId) {
                        // empty catch block
                    }
                }
            }
            ImGui.sameLine();
            boolean showTagsBecauseOfPrefix = blockList.getLastSearchRaw().startsWith("#");
            boolean down = effectiveShowingTags = fromShowingTags || showTagsBecauseOfPrefix;
            if (down) {
                ImGuiHelper.pushStyleVar(0, ImGui.getStyle().getAlpha() * ImGui.getStyle().getDisabledAlpha());
            }
            if (ImGui.button(AxiomI18n.get("axiom.widget.block_tags"))) {
                boolean bl = fromShowingTags = !effectiveShowingTags;
                if (!fromShowingTags && showTagsBecauseOfPrefix) {
                    blockList.search(blockList.getLastSearchRaw().substring(1), QuickReplaceWindow.getFromFilter());
                }
            }
            if (down) {
                ImGuiHelper.popStyleVar();
            }
            if (effectiveShowingTags) {
                List<BlockList.TagEntry> tags = blockList.getTags();
                if (!justOpened && ImGui.isKeyPressed(257) && !tags.isEmpty()) {
                    BlockList.MinecraftOrCustomTagSet clickedTag = tags.get(0).tag();
                    ImGui.closeCurrentPopup();
                    ImGui.endPopup();
                    fromTag = clickedTag;
                    return true;
                }
                BlockList.MinecraftOrCustomTagSet selectedTag = ImGuiHelper.tagScrollList(tags, 384, 256, justOpened);
                if (selectedTag != null) {
                    ImGui.closeCurrentPopup();
                    ImGui.endPopup();
                    fromTag = selectedTag;
                    return true;
                }
            } else {
                if (fromSearchedBlocks == null) {
                    fromSearchedBlocks = blockList.getBlocks();
                }
                if (!justOpened && ImGui.isKeyPressed(257) && !fromSearchedBlocks.isEmpty()) {
                    ImGui.closeCurrentPopup();
                    ImGui.endPopup();
                    CustomBlock customBlock = fromSearchedBlocks.get(0).state().getCustomBlock();
                    if (!fromBlocks.contains(customBlock)) {
                        fromBlocks.add(customBlock);
                        fromBlocksHasProperties |= !customBlock.axiom$getProperties().isEmpty();
                    }
                    return true;
                }
                CustomBlockState selectedBlock = ImGuiHelper.blockScrollList(fromSearchedBlocks, (int)(384.0f * EditorUI.getUiScale()), (int)(256.0f * EditorUI.getUiScale()), justOpened);
                if (selectedBlock != null) {
                    CustomBlock customBlock = selectedBlock.getCustomBlock();
                    if (!fromBlocks.contains(customBlock)) {
                        fromBlocks.add(customBlock);
                        fromBlocksHasProperties |= !customBlock.axiom$getProperties().isEmpty();
                    }
                    if (!EditorUI.isCtrlOrCmdDown()) {
                        ImGui.closeCurrentPopup();
                        ImGui.endPopup();
                        return true;
                    }
                }
            }
            if (!fromShowingTags) {
                if (ImGui.checkbox("Filter Selected Blocks", filterSelectedBlocks)) {
                    filterSelectedBlocks = !filterSelectedBlocks;
                    blockList.search(blockList.getLastSearchRaw(), QuickReplaceWindow.getFromFilter(), true);
                    fromSearchedBlocks = blockList.getBlocks();
                }
                if (Axiom.configuration.internal.showQuickReplaceCtrlClickTip) {
                    ImGui.separator();
                    ImGui.pushTextWrapPos(380.0f);
                    ImGui.text("Tip: You can use Ctrl+Click to select multiple blocks for replacement");
                    ImGui.popTextWrapPos();
                    if (ImGui.smallButton("Don't show this tip again")) {
                        Axiom.configuration.internal.showQuickReplaceCtrlClickTip = false;
                    }
                    if (fromBlocks.isEmpty()) {
                        ImGui.separator();
                    }
                }
                if (!fromBlocks.isEmpty()) {
                    ImGuiHelper.separatorWithText("Replace List");
                    float available = ImGui.getContentRegionAvailX() + ImGui.getStyle().getItemSpacingX();
                    float itemWidth = (float)((int)(32.0f * EditorUI.getUiScale())) + ImGui.getStyle().getItemSpacingX();
                    int count = (int)Math.max(1.0, Math.floor(available / itemWidth));
                    int removeBlock = -1;
                    for (int i = 0; i < fromBlocks.size(); ++i) {
                        CustomBlock entry = fromBlocks.get(i);
                        if (i != 0 && i % count != 0) {
                            ImGui.sameLine();
                        }
                        if (ImGuiHelper.blockStateButton(entry.axiom$defaultCustomState(), i, (int)(32.0f * EditorUI.getUiScale()))) {
                            removeBlock = i;
                        }
                        if (!ImGui.isItemHovered()) continue;
                        ImGui.beginTooltip();
                        ImGui.text(AxiomI18n.get(entry.axiom$translationKey()));
                        ImGui.textDisabled(entry.axiom$getIdentifier().toString());
                        ImGui.endTooltip();
                    }
                    if (removeBlock >= 0) {
                        fromBlocks.remove(removeBlock);
                        fromBlocksHasProperties = false;
                        for (CustomBlock fromBlock : fromBlocks) {
                            fromBlocksHasProperties |= !fromBlock.axiom$getProperties().isEmpty();
                        }
                    }
                    if (ImGui.button(AxiomI18n.get("axiom.keybinds.quick_replace.replace_all"), ImGui.getContentRegionAvailX(), 0.0f)) {
                        ImGui.closeCurrentPopup();
                        ImGui.endPopup();
                        return true;
                    }
                }
            }
            if (ImGui.button(AxiomI18n.get("axiom.widget.cancel"), ImGui.getContentRegionAvailX(), 0.0f)) {
                ImGui.closeCurrentPopup();
            }
            ImGuiHelper.endPopupModalCloseable();
        }
        return false;
    }

    public static Predicate<CustomBlockState> getFromFilter() {
        if (!filterSelectedBlocks) {
            return null;
        }
        if (selectedBlocks == null) {
            selectedBlocks = new HashSet<class_2248>();
            SelectionBuffer buffer = Selection.getSelectionBuffer();
            class_638 level = class_310.method_1551().field_1687;
            if (buffer instanceof SelectionBuffer.AABB) {
                SelectionBuffer.AABB aabb = (SelectionBuffer.AABB)buffer;
                class_2338 min2 = aabb.min();
                class_2338 max2 = aabb.max();
                int minX = min2.method_10263();
                int minY = min2.method_10264();
                int minZ = min2.method_10260();
                int maxX = max2.method_10263();
                int maxY = max2.method_10264();
                int maxZ = max2.method_10260();
                int minChunkX = minX >> 4;
                int minChunkY = minY >> 4;
                int minChunkZ = minZ >> 4;
                int maxChunkX = maxX >> 4;
                int maxChunkY = maxY >> 4;
                int maxChunkZ = maxZ >> 4;
                for (int cx2 = minChunkX; cx2 <= maxChunkX; ++cx2) {
                    for (int cy2 = minChunkY; cy2 <= maxChunkY; ++cy2) {
                        for (int cz2 = minChunkZ; cz2 <= maxChunkZ; ++cz2) {
                            class_2818 levelChunk;
                            int sectionIndex = level.method_31603(cy2);
                            if (sectionIndex < 0 || sectionIndex >= level.method_32890() || (levelChunk = (class_2818)level.method_8402(cx2, cz2, class_2806.field_12803, false)) == null) continue;
                            class_2826 section = levelChunk.method_38259(sectionIndex);
                            if (section.method_38292()) {
                                selectedBlocks.add(class_2246.field_10124);
                                continue;
                            }
                            class_2841 states = section.method_12265();
                            boolean maybeHasUnseenValue = states.method_19526(blockState -> !selectedBlocks.contains(blockState.method_26204()));
                            if (!maybeHasUnseenValue) continue;
                            int minRelativeX = Math.max(0, minX - (cx2 << 4));
                            int minRelativeY = Math.max(0, minY - (cy2 << 4));
                            int minRelativeZ = Math.max(0, minZ - (cz2 << 4));
                            int maxRelativeX = Math.min(15, maxX - (cx2 << 4));
                            int maxRelativeY = Math.min(15, maxY - (cy2 << 4));
                            int maxRelativeZ = Math.min(15, maxZ - (cz2 << 4));
                            if (minRelativeX == 0 && minRelativeY == 0 && minRelativeZ == 0 && maxRelativeX == 15 && maxRelativeY == 15 && maxRelativeZ == 15) {
                                states.method_39793(blockState -> selectedBlocks.add(blockState.method_26204()));
                                continue;
                            }
                            for (int y2 = minRelativeY; y2 <= maxRelativeY; ++y2) {
                                for (int z2 = minRelativeZ; z2 <= maxRelativeZ; ++z2) {
                                    for (int x2 = minRelativeX; x2 <= maxRelativeX; ++x2) {
                                        selectedBlocks.add(((class_2680)states.method_12321(x2, y2, z2)).method_26204());
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (buffer instanceof SelectionBuffer.Set) {
                SelectionBuffer.Set set = (SelectionBuffer.Set)buffer;
                set.selectionRegion.forEachChunk((cx, cy, cz, chunk) -> {
                    int sectionIndex = level.method_31603(cy);
                    if (sectionIndex < 0 || sectionIndex >= level.method_32890()) {
                        return;
                    }
                    class_2818 levelChunk = (class_2818)level.method_8402(cx, cz, class_2806.field_12803, false);
                    if (levelChunk == null) {
                        return;
                    }
                    class_2826 section = levelChunk.method_38259(sectionIndex);
                    if (section.method_38292()) {
                        selectedBlocks.add(class_2246.field_10124);
                        return;
                    }
                    class_2841 states = section.method_12265();
                    boolean maybeHasUnseenValue = states.method_19526(blockState -> !selectedBlocks.contains(blockState.method_26204()));
                    if (!maybeHasUnseenValue) {
                        return;
                    }
                    int index = 0;
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 16; ++y) {
                            short v;
                            if ((v = chunk[index++]) == -1) {
                                selectedBlocks.add(((class_2680)states.method_12321(0, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(1, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(2, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(3, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(4, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(5, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(6, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(7, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(8, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(9, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(10, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(11, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(12, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(13, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(14, y, z)).method_26204());
                                selectedBlocks.add(((class_2680)states.method_12321(15, y, z)).method_26204());
                                continue;
                            }
                            for (int x = 0; x < 16; ++x) {
                                if ((v & 1 << x) == 0) continue;
                                selectedBlocks.add(((class_2680)states.method_12321(x, y, z)).method_26204());
                            }
                        }
                    }
                });
            } else {
                class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
                buffer.forEach((x, y, z) -> {
                    class_2680 blockState = level.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                    selectedBlocks.add(blockState.method_26204());
                });
            }
        }
        if (selectedBlocks.isEmpty()) {
            return null;
        }
        Set<class_2248> selectedBlocksCopy = selectedBlocks;
        return block -> selectedBlocksCopy.contains(block.getVanillaState().method_26204());
    }

    static {
        toBlockWidget = new SelectBlockWidget(false);
        openQuickReplaceWindow = false;
        selectedBlocks = null;
        filterSelectedBlocks = true;
        copyProperties = true;
        QuickReplaceWindow.toBlockWidget.extraRender = () -> {
            if (QuickReplaceWindow.fromHasProperties() && ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.replace.copy_properties"), copyProperties)) {
                copyProperties = !copyProperties;
            }
        };
        fromJustOpened = false;
        fromShowingTags = false;
        fromSearchedBlocks = null;
    }
}

