/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.widgets;

import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.VersionUtilsNbt;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.funcinterfaces.BiIntConsumer;
import com.moulberry.axiom.rasterization.Rasterization2D;
import com.moulberry.axiom.utils.ColourUtils;
import imgui.ImGui;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2487;
import org.joml.Vector2i;

public class FalloffWidget {
    private static final FloatUnaryOperator[] falloffFunctions = new FloatUnaryOperator[]{x -> 1.0f, x -> (float)Math.sqrt(1.0f - x * x), x -> 1.0f - x, x -> 1.0f - x * x * x * x, x -> (double)x < 0.5 ? 1.0f - 2.0f * x * x : (float)Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0f, x -> (1.0f - x) * (1.0f - x) * (1.0f - x)};
    private final class_1043[] falloffDisplay = new class_1043[6];
    private int falloff = 1;

    public FloatUnaryOperator getFalloffFunction() {
        return falloffFunctions[this.falloff];
    }

    public void unload() {
        for (int i = 0; i < 6; ++i) {
            class_1043 falloffDisplay = this.falloffDisplay[i];
            if (falloffDisplay == null) continue;
            falloffDisplay.close();
            this.falloffDisplay[i] = null;
        }
    }

    public boolean displayImgui() {
        int sizeH = (int)((256.0f * EditorUI.getUiScale() - ImGui.getStyle().getItemSpacingX() * 2.0f - ImGui.getStyle().getFramePaddingX() * 6.0f) / 3.0f);
        int sizeV = (int)(37.0f * EditorUI.getUiScale());
        this.uploadFalloffPreviews(sizeH, sizeV);
        boolean changed = false;
        for (int i = 0; i < 6; ++i) {
            boolean selected;
            boolean bl = selected = this.falloff == i;
            if (selected) {
                ImGuiHelper.pushStyleColor(21, ImGui.getColorU32(23));
            }
            if (ImGui.imageButton(new AxiomGpuTexture(this.falloffDisplay[i].method_4624()).glId(), sizeH, sizeV) && !selected) {
                this.falloff = i;
                changed = true;
            }
            if (selected) {
                ImGuiHelper.popStyleColor();
            }
            if (i % 3 == 2) continue;
            ImGui.sameLine();
        }
        return changed;
    }

    public void writeSettings(class_2487 tag) {
        tag.method_10569("FalloffType", this.falloff);
    }

    public void loadSettings(class_2487 tag) {
        this.falloff = VersionUtilsNbt.helperCompoundTagGetIntOr(tag, "FalloffType", 1);
    }

    private void uploadFalloffPreviews(int width, int height) {
        for (int i = 0; i < 6; ++i) {
            class_1011 pixels;
            class_1043 dynamicTexture = this.falloffDisplay[i];
            if (dynamicTexture != null) {
                dynamicTexture.close();
            }
            if (dynamicTexture == null) {
                dynamicTexture = VersionUtilsClient.helperCreateNewWithSizeDynamicTexture(null, width, height, true);
                pixels = dynamicTexture.method_4525();
                this.falloffDisplay[i] = dynamicTexture;
            } else {
                class_1011 oldPixels = dynamicTexture.method_4525();
                if (oldPixels != null && oldPixels.method_4307() == width && oldPixels.method_4323() == height) continue;
                dynamicTexture.close();
                dynamicTexture = VersionUtilsClient.helperCreateNewWithSizeDynamicTexture(null, width, height, true);
                pixels = dynamicTexture.method_4525();
                this.falloffDisplay[i] = dynamicTexture;
            }
            if (pixels == null) continue;
            FloatUnaryOperator operator = falloffFunctions[i];
            int windowBg = ImGui.getColorU32(2);
            for (int x2 = 0; x2 < width; ++x2) {
                for (int y2 = 0; y2 < height; ++y2) {
                    pixels.method_4305(x2, y2, ColourUtils.argbToAbgr(ColourUtils.abgrToArgb(windowBg)));
                }
            }
            BiIntConsumer consumer = (x, y) -> {
                for (int xo = -1; xo <= 1; ++xo) {
                    for (int yo = -1; yo <= 1; ++yo) {
                        int radiusSq = xo * xo + yo * yo;
                        if (radiusSq > 1) continue;
                        int nx = x + xo;
                        int ny = y + yo;
                        if (nx < 0 || nx >= width || ny < 0 || ny >= height) continue;
                        int existing = ColourUtils.abgrToArgb(pixels.method_4315(nx, ny));
                        int alpha = 255 - radiusSq * 255 / 2;
                        int result = ColourUtils.blendARGB(existing, alpha << 24 | 0xFFFFFF);
                        pixels.method_4305(nx, ny, ColourUtils.argbToAbgr(result));
                    }
                }
            };
            float lastH = (1.0f - operator.apply(1.0f)) * (float)(height - 3) + 1.0f;
            for (int x3 = 2; x3 < width - 1; ++x3) {
                float xf = (float)(x3 - 1) / (float)(width - 3);
                float h2 = (1.0f - operator.apply(Math.abs(2.0f * xf - 1.0f))) * (float)(height - 3) + 1.0f;
                if (x3 == 2) {
                    Rasterization2D.bresenham(new Vector2i(x3 - 1, Math.round(lastH)), new Vector2i(x3, Math.round(h2)), consumer, false);
                } else {
                    Rasterization2D.bresenhamSkipFrom(new Vector2i(x3 - 1, Math.round(lastH)), new Vector2i(x3, Math.round(h2)), consumer, false);
                }
                lastH = h2;
            }
            dynamicTexture.method_4524();
        }
    }
}

