/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor;

import com.moulberry.axiom.RayCaster;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.tools.Tool;
import imgui.ImDrawList;
import imgui.ImGui;
import net.minecraft.class_241;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class GenericRadiusAdjustment {
    private int radius = 0;
    private int height = 0;
    private final int maxRadius;
    private float baseRadiusAdjustment = 0.0f;
    private float baseHeightAdjustment = 0.0f;
    private float distance = 16.0f;

    public GenericRadiusAdjustment(int maxRadius) {
        this.maxRadius = maxRadius;
    }

    public boolean initiateAdjustment(int radius, int height) {
        RayCaster.RaycastResult result = Tool.raycastBlock();
        if (result == null) {
            return false;
        }
        float raycastDistance = (float)result.getLocation().method_1022(class_310.method_1551().field_1724.method_33571());
        this.initiateAdjustment(radius, height, raycastDistance);
        return true;
    }

    public void initiateAdjustment(int radius, int height, float distance) {
        this.radius = radius;
        this.height = height;
        float m11 = EditorUI.lastProjectionMatrix.m11();
        this.baseRadiusAdjustment = (float)this.radius / distance / 2.0f * m11 * ImGui.getMainViewport().getSizeY();
        if (height >= 0) {
            this.baseHeightAdjustment = (float)this.height / distance / 2.0f * m11 * ImGui.getMainViewport().getSizeY();
            float r = this.baseRadiusAdjustment;
            float h2 = this.baseHeightAdjustment;
            if (r > h2) {
                this.baseHeightAdjustment = r / (float)Math.sqrt(r / h2 * r / h2 + 1.0f);
                this.baseRadiusAdjustment = (float)Math.sqrt(r * r - this.baseHeightAdjustment * this.baseHeightAdjustment);
            } else {
                this.baseRadiusAdjustment = h2 / (float)Math.sqrt(h2 / r * h2 / r + 1.0f);
                this.baseHeightAdjustment = (float)Math.sqrt(h2 * h2 - this.baseRadiusAdjustment * this.baseRadiusAdjustment);
            }
        } else {
            this.baseHeightAdjustment = 0.0f;
        }
        this.distance = distance;
    }

    public Result renderAdjustment(float mouseX, float mouseY, class_241 mouseDelta) {
        int newHeight;
        int newRadius;
        float deltaX = mouseDelta.field_1343 + this.baseRadiusAdjustment;
        float deltaY = mouseDelta.field_1342 - this.baseHeightAdjustment;
        float actualLength = (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        float factor = actualLength / Math.max(Math.abs(deltaX), Math.abs(deltaY));
        float m11 = EditorUI.lastProjectionMatrix.m11();
        if (this.height >= 0) {
            int maxVolume;
            float lengthForHeight = Math.abs(deltaY * factor);
            float lengthForRadius = Math.abs(deltaX * factor);
            newRadius = Math.round(lengthForRadius / ImGui.getMainViewport().getSizeY() * this.distance * 2.0f / m11);
            newHeight = Math.round(lengthForHeight / ImGui.getMainViewport().getSizeY() * this.distance * 2.0f / m11);
            if (newRadius < 0) {
                newRadius = 0;
            }
            if (newRadius > this.maxRadius * 4) {
                newRadius = this.maxRadius * 4;
            }
            if (newHeight < 0) {
                newHeight = 0;
            }
            if (newHeight > this.maxRadius * 4) {
                newHeight = this.maxRadius * 4;
            }
            if (newRadius * newHeight > (maxVolume = this.maxRadius * this.maxRadius)) {
                float scaleDown = (float)Math.sqrt((float)maxVolume / (float)(newRadius * newHeight));
                newRadius = Math.round((float)newRadius * scaleDown);
                newHeight = Math.round((float)newHeight * scaleDown);
            }
        } else {
            newRadius = Math.round(actualLength / ImGui.getMainViewport().getSizeY() * this.distance * 2.0f / m11);
            newHeight = this.height;
            if (newRadius < 0) {
                newRadius = 0;
            }
            if (newRadius > this.maxRadius) {
                newRadius = this.maxRadius;
            }
        }
        boolean changed = false;
        if (this.radius != newRadius) {
            this.radius = newRadius;
            changed = true;
        }
        if (this.height != newHeight) {
            this.height = newHeight;
            changed = true;
        }
        if (deltaX != 0.0f || deltaY != 0.0f) {
            ImDrawList drawList = ImGui.getForegroundDrawList();
            float targetLength = 6.0f;
            float divisions = actualLength / targetLength;
            if (divisions < 1.0f) {
                divisions = 1.0f;
            }
            if (divisions > 100.0f) {
                divisions = 100.0f;
            }
            int i = 1;
            while ((float)i < divisions) {
                float x1 = deltaX - deltaX * (float)i / divisions;
                float y1 = deltaY - deltaY * (float)i / divisions;
                float x2 = deltaX - deltaX * Math.min(1.0f, (float)(i + 1) / divisions);
                float y2 = deltaY - deltaY * Math.min(1.0f, (float)(i + 1) / divisions);
                drawList.addLine(mouseX + x1, mouseY + y1, mouseX + x2, mouseY + y2, -16777216, 1.0f);
                i += 2;
            }
            float angle = (float)Math.atan2(deltaX, deltaY);
            float arrowMainX = class_3532.method_15374((float)angle);
            float arrowMainY = class_3532.method_15362((float)angle);
            float arrowLeftX = class_3532.method_15374((float)(angle + 2.3561945f));
            float arrowLeftY = class_3532.method_15362((float)(angle + 2.3561945f));
            float arrowRightX = class_3532.method_15374((float)(angle - 2.3561945f));
            float arrowRightY = class_3532.method_15362((float)(angle - 2.3561945f));
            drawList.addLine(mouseX + deltaX + arrowMainX * 4.0f, mouseY + deltaY + arrowMainY * 4.0f, mouseX + deltaX + arrowMainX * 15.0f, mouseY + deltaY + arrowMainY * 15.0f, -16777216, 2.0f);
            drawList.addLine(mouseX + deltaX + arrowMainX * 15.0f - arrowLeftX, mouseY + deltaY + arrowMainY * 15.0f - arrowLeftY, mouseX + deltaX + arrowMainX * 15.0f + arrowLeftX * 7.0f, mouseY + deltaY + arrowMainY * 15.0f + arrowLeftY * 7.0f, -16777216, 2.0f);
            drawList.addLine(mouseX + deltaX + arrowMainX * 15.0f - arrowRightX, mouseY + deltaY + arrowMainY * 15.0f - arrowRightY, mouseX + deltaX + arrowMainX * 15.0f + arrowRightX * 7.0f, mouseY + deltaY + arrowMainY * 15.0f + arrowRightY * 7.0f, -16777216, 2.0f);
            drawList.addLine(mouseX + deltaX - arrowMainX * 4.0f, mouseY + deltaY - arrowMainY * 4.0f, mouseX + deltaX - arrowMainX * 15.0f, mouseY + deltaY - arrowMainY * 15.0f, -16777216, 2.0f);
            drawList.addLine(mouseX + deltaX - arrowMainX * 15.0f + arrowLeftX, mouseY + deltaY - arrowMainY * 15.0f + arrowLeftY, mouseX + deltaX - arrowMainX * 15.0f - arrowLeftX * 7.0f, mouseY + deltaY - arrowMainY * 15.0f - arrowLeftY * 7.0f, -16777216, 2.0f);
            drawList.addLine(mouseX + deltaX - arrowMainX * 15.0f + arrowRightX, mouseY + deltaY - arrowMainY * 15.0f + arrowRightY, mouseX + deltaX - arrowMainX * 15.0f - arrowRightX * 7.0f, mouseY + deltaY - arrowMainY * 15.0f - arrowRightY * 7.0f, -16777216, 2.0f);
        }
        return new Result(mouseDelta, this.radius, this.height, changed);
    }

    public record Result(class_241 mouseDelta, int radius, int height, boolean changed) {
    }
}

